#ifndef __LIBXL_TYPES_H
#define __LIBXL_TYPES_H

/*
 * DO NOT EDIT.
 *
 * This file is autogenerated by
 * "gentypes.py libxl_types.idl __libxl_types.h __libxl_types_private.h __libxl_types_json.h __libxl_types.c"
 */

typedef enum libxl_error {
    ERROR_NONSPECIFIC = -1,
    ERROR_VERSION = -2,
    ERROR_FAIL = -3,
    ERROR_NI = -4,
    ERROR_NOMEM = -5,
    ERROR_INVAL = -6,
    ERROR_BADFAIL = -7,
    ERROR_GUEST_TIMEDOUT = -8,
    ERROR_TIMEDOUT = -9,
    ERROR_NOPARAVIRT = -10,
    ERROR_NOT_READY = -11,
    ERROR_OSEVENT_REG_FAIL = -12,
    ERROR_BUFFERFULL = -13,
    ERROR_UNKNOWN_CHILD = -14,
    ERROR_LOCK_FAIL = -15,
    ERROR_JSON_CONFIG_EMPTY = -16,
    ERROR_DEVICE_EXISTS = -17,
    ERROR_REMUS_DEVOPS_DOES_NOT_MATCH = -18,
    ERROR_REMUS_DEVICE_NOT_SUPPORTED = -19,
} libxl_error;
char *libxl_error_to_json(libxl_ctx *ctx, libxl_error p);
int libxl_error_from_json(libxl_ctx *ctx, libxl_error *p, const char *s);
const char *libxl_error_to_string(libxl_error p);
int libxl_error_from_string(const char *s, libxl_error *e);
extern libxl_enum_string_table libxl_error_string_table[];

typedef enum libxl_domain_type {
    LIBXL_DOMAIN_TYPE_INVALID = -1,
    LIBXL_DOMAIN_TYPE_HVM = 1,
    LIBXL_DOMAIN_TYPE_PV = 2,
} libxl_domain_type;
char *libxl_domain_type_to_json(libxl_ctx *ctx, libxl_domain_type p);
int libxl_domain_type_from_json(libxl_ctx *ctx, libxl_domain_type *p, const char *s);
const char *libxl_domain_type_to_string(libxl_domain_type p);
int libxl_domain_type_from_string(const char *s, libxl_domain_type *e);
extern libxl_enum_string_table libxl_domain_type_string_table[];

typedef enum libxl_channel_connection {
    LIBXL_CHANNEL_CONNECTION_UNKNOWN = 0,
    LIBXL_CHANNEL_CONNECTION_PTY = 1,
    LIBXL_CHANNEL_CONNECTION_SOCKET = 2,
} libxl_channel_connection;
char *libxl_channel_connection_to_json(libxl_ctx *ctx, libxl_channel_connection p);
int libxl_channel_connection_from_json(libxl_ctx *ctx, libxl_channel_connection *p, const char *s);
const char *libxl_channel_connection_to_string(libxl_channel_connection p);
int libxl_channel_connection_from_string(const char *s, libxl_channel_connection *e);
extern libxl_enum_string_table libxl_channel_connection_string_table[];

typedef enum libxl_device_model_version {
    LIBXL_DEVICE_MODEL_VERSION_UNKNOWN = 0,
    LIBXL_DEVICE_MODEL_VERSION_QEMU_XEN_TRADITIONAL = 1,
    LIBXL_DEVICE_MODEL_VERSION_QEMU_XEN = 2,
} libxl_device_model_version;
char *libxl_device_model_version_to_json(libxl_ctx *ctx, libxl_device_model_version p);
int libxl_device_model_version_from_json(libxl_ctx *ctx, libxl_device_model_version *p, const char *s);
const char *libxl_device_model_version_to_string(libxl_device_model_version p);
int libxl_device_model_version_from_string(const char *s, libxl_device_model_version *e);
extern libxl_enum_string_table libxl_device_model_version_string_table[];

typedef enum libxl_console_type {
    LIBXL_CONSOLE_TYPE_UNKNOWN = 0,
    LIBXL_CONSOLE_TYPE_SERIAL = 1,
    LIBXL_CONSOLE_TYPE_PV = 2,
} libxl_console_type;
char *libxl_console_type_to_json(libxl_ctx *ctx, libxl_console_type p);
int libxl_console_type_from_json(libxl_ctx *ctx, libxl_console_type *p, const char *s);
const char *libxl_console_type_to_string(libxl_console_type p);
int libxl_console_type_from_string(const char *s, libxl_console_type *e);
extern libxl_enum_string_table libxl_console_type_string_table[];

typedef enum libxl_disk_format {
    LIBXL_DISK_FORMAT_UNKNOWN = 0,
    LIBXL_DISK_FORMAT_QCOW = 1,
    LIBXL_DISK_FORMAT_QCOW2 = 2,
    LIBXL_DISK_FORMAT_VHD = 3,
    LIBXL_DISK_FORMAT_RAW = 4,
    LIBXL_DISK_FORMAT_EMPTY = 5,
} libxl_disk_format;
char *libxl_disk_format_to_json(libxl_ctx *ctx, libxl_disk_format p);
int libxl_disk_format_from_json(libxl_ctx *ctx, libxl_disk_format *p, const char *s);
const char *libxl_disk_format_to_string(libxl_disk_format p);
int libxl_disk_format_from_string(const char *s, libxl_disk_format *e);
extern libxl_enum_string_table libxl_disk_format_string_table[];

typedef enum libxl_disk_backend {
    LIBXL_DISK_BACKEND_UNKNOWN = 0,
    LIBXL_DISK_BACKEND_PHY = 1,
    LIBXL_DISK_BACKEND_TAP = 2,
    LIBXL_DISK_BACKEND_QDISK = 3,
} libxl_disk_backend;
char *libxl_disk_backend_to_json(libxl_ctx *ctx, libxl_disk_backend p);
int libxl_disk_backend_from_json(libxl_ctx *ctx, libxl_disk_backend *p, const char *s);
const char *libxl_disk_backend_to_string(libxl_disk_backend p);
int libxl_disk_backend_from_string(const char *s, libxl_disk_backend *e);
extern libxl_enum_string_table libxl_disk_backend_string_table[];

typedef enum libxl_nic_type {
    LIBXL_NIC_TYPE_UNKNOWN = 0,
    LIBXL_NIC_TYPE_VIF_IOEMU = 1,
    LIBXL_NIC_TYPE_VIF = 2,
} libxl_nic_type;
char *libxl_nic_type_to_json(libxl_ctx *ctx, libxl_nic_type p);
int libxl_nic_type_from_json(libxl_ctx *ctx, libxl_nic_type *p, const char *s);
const char *libxl_nic_type_to_string(libxl_nic_type p);
int libxl_nic_type_from_string(const char *s, libxl_nic_type *e);
extern libxl_enum_string_table libxl_nic_type_string_table[];

typedef enum libxl_action_on_shutdown {
    LIBXL_ACTION_ON_SHUTDOWN_DESTROY = 1,
    LIBXL_ACTION_ON_SHUTDOWN_RESTART = 2,
    LIBXL_ACTION_ON_SHUTDOWN_RESTART_RENAME = 3,
    LIBXL_ACTION_ON_SHUTDOWN_PRESERVE = 4,
    LIBXL_ACTION_ON_SHUTDOWN_COREDUMP_DESTROY = 5,
    LIBXL_ACTION_ON_SHUTDOWN_COREDUMP_RESTART = 6,
} libxl_action_on_shutdown;
char *libxl_action_on_shutdown_to_json(libxl_ctx *ctx, libxl_action_on_shutdown p);
int libxl_action_on_shutdown_from_json(libxl_ctx *ctx, libxl_action_on_shutdown *p, const char *s);
const char *libxl_action_on_shutdown_to_string(libxl_action_on_shutdown p);
int libxl_action_on_shutdown_from_string(const char *s, libxl_action_on_shutdown *e);
extern libxl_enum_string_table libxl_action_on_shutdown_string_table[];

typedef enum libxl_trigger {
    LIBXL_TRIGGER_UNKNOWN = 0,
    LIBXL_TRIGGER_POWER = 1,
    LIBXL_TRIGGER_SLEEP = 2,
    LIBXL_TRIGGER_NMI = 3,
    LIBXL_TRIGGER_INIT = 4,
    LIBXL_TRIGGER_RESET = 5,
    LIBXL_TRIGGER_S3RESUME = 6,
} libxl_trigger;
char *libxl_trigger_to_json(libxl_ctx *ctx, libxl_trigger p);
int libxl_trigger_from_json(libxl_ctx *ctx, libxl_trigger *p, const char *s);
const char *libxl_trigger_to_string(libxl_trigger p);
int libxl_trigger_from_string(const char *s, libxl_trigger *e);
extern libxl_enum_string_table libxl_trigger_string_table[];

typedef enum libxl_tsc_mode {
    LIBXL_TSC_MODE_DEFAULT = 0,
    LIBXL_TSC_MODE_ALWAYS_EMULATE = 1,
    LIBXL_TSC_MODE_NATIVE = 2,
    LIBXL_TSC_MODE_NATIVE_PARAVIRT = 3,
} libxl_tsc_mode;
char *libxl_tsc_mode_to_json(libxl_ctx *ctx, libxl_tsc_mode p);
int libxl_tsc_mode_from_json(libxl_ctx *ctx, libxl_tsc_mode *p, const char *s);
const char *libxl_tsc_mode_to_string(libxl_tsc_mode p);
int libxl_tsc_mode_from_string(const char *s, libxl_tsc_mode *e);
extern libxl_enum_string_table libxl_tsc_mode_string_table[];

typedef enum libxl_timer_mode {
    LIBXL_TIMER_MODE_UNKNOWN = -1,
    LIBXL_TIMER_MODE_DELAY_FOR_MISSED_TICKS = 0,
    LIBXL_TIMER_MODE_NO_DELAY_FOR_MISSED_TICKS = 1,
    LIBXL_TIMER_MODE_NO_MISSED_TICKS_PENDING = 2,
    LIBXL_TIMER_MODE_ONE_MISSED_TICK_PENDING = 3,
} libxl_timer_mode;
char *libxl_timer_mode_to_json(libxl_ctx *ctx, libxl_timer_mode p);
int libxl_timer_mode_from_json(libxl_ctx *ctx, libxl_timer_mode *p, const char *s);
const char *libxl_timer_mode_to_string(libxl_timer_mode p);
int libxl_timer_mode_from_string(const char *s, libxl_timer_mode *e);
extern libxl_enum_string_table libxl_timer_mode_string_table[];

typedef enum libxl_bios_type {
    LIBXL_BIOS_TYPE_UNKNOWN = 0,
    LIBXL_BIOS_TYPE_ROMBIOS = 1,
    LIBXL_BIOS_TYPE_SEABIOS = 2,
    LIBXL_BIOS_TYPE_OVMF = 3,
} libxl_bios_type;
char *libxl_bios_type_to_json(libxl_ctx *ctx, libxl_bios_type p);
int libxl_bios_type_from_json(libxl_ctx *ctx, libxl_bios_type *p, const char *s);
const char *libxl_bios_type_to_string(libxl_bios_type p);
int libxl_bios_type_from_string(const char *s, libxl_bios_type *e);
extern libxl_enum_string_table libxl_bios_type_string_table[];

typedef enum libxl_scheduler {
    LIBXL_SCHEDULER_UNKNOWN = 0,
    LIBXL_SCHEDULER_SEDF = 4,
    LIBXL_SCHEDULER_CREDIT = 5,
    LIBXL_SCHEDULER_CREDIT2 = 6,
    LIBXL_SCHEDULER_ARINC653 = 7,
    LIBXL_SCHEDULER_RTDS = 8,
} libxl_scheduler;
char *libxl_scheduler_to_json(libxl_ctx *ctx, libxl_scheduler p);
int libxl_scheduler_from_json(libxl_ctx *ctx, libxl_scheduler *p, const char *s);
const char *libxl_scheduler_to_string(libxl_scheduler p);
int libxl_scheduler_from_string(const char *s, libxl_scheduler *e);
extern libxl_enum_string_table libxl_scheduler_string_table[];

typedef enum libxl_shutdown_reason {
    LIBXL_SHUTDOWN_REASON_UNKNOWN = -1,
    LIBXL_SHUTDOWN_REASON_POWEROFF = 0,
    LIBXL_SHUTDOWN_REASON_REBOOT = 1,
    LIBXL_SHUTDOWN_REASON_SUSPEND = 2,
    LIBXL_SHUTDOWN_REASON_CRASH = 3,
    LIBXL_SHUTDOWN_REASON_WATCHDOG = 4,
} libxl_shutdown_reason;
char *libxl_shutdown_reason_to_json(libxl_ctx *ctx, libxl_shutdown_reason p);
int libxl_shutdown_reason_from_json(libxl_ctx *ctx, libxl_shutdown_reason *p, const char *s);
const char *libxl_shutdown_reason_to_string(libxl_shutdown_reason p);
int libxl_shutdown_reason_from_string(const char *s, libxl_shutdown_reason *e);
extern libxl_enum_string_table libxl_shutdown_reason_string_table[];

typedef enum libxl_vga_interface_type {
    LIBXL_VGA_INTERFACE_TYPE_CIRRUS = 1,
    LIBXL_VGA_INTERFACE_TYPE_STD = 2,
    LIBXL_VGA_INTERFACE_TYPE_NONE = 3,
} libxl_vga_interface_type;
char *libxl_vga_interface_type_to_json(libxl_ctx *ctx, libxl_vga_interface_type p);
int libxl_vga_interface_type_from_json(libxl_ctx *ctx, libxl_vga_interface_type *p, const char *s);
const char *libxl_vga_interface_type_to_string(libxl_vga_interface_type p);
int libxl_vga_interface_type_from_string(const char *s, libxl_vga_interface_type *e);
extern libxl_enum_string_table libxl_vga_interface_type_string_table[];

typedef enum libxl_vendor_device {
    LIBXL_VENDOR_DEVICE_NONE = 0,
    LIBXL_VENDOR_DEVICE_XENSERVER = 1,
} libxl_vendor_device;
char *libxl_vendor_device_to_json(libxl_ctx *ctx, libxl_vendor_device p);
int libxl_vendor_device_from_json(libxl_ctx *ctx, libxl_vendor_device *p, const char *s);
const char *libxl_vendor_device_to_string(libxl_vendor_device p);
int libxl_vendor_device_from_string(const char *s, libxl_vendor_device *e);
extern libxl_enum_string_table libxl_vendor_device_string_table[];

typedef enum libxl_viridian_enlightenment {
    LIBXL_VIRIDIAN_ENLIGHTENMENT_BASE = 0,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_FREQ = 1,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_TIME_REF_COUNT = 2,
} libxl_viridian_enlightenment;
char *libxl_viridian_enlightenment_to_json(libxl_ctx *ctx, libxl_viridian_enlightenment p);
int libxl_viridian_enlightenment_from_json(libxl_ctx *ctx, libxl_viridian_enlightenment *p, const char *s);
const char *libxl_viridian_enlightenment_to_string(libxl_viridian_enlightenment p);
int libxl_viridian_enlightenment_from_string(const char *s, libxl_viridian_enlightenment *e);
extern libxl_enum_string_table libxl_viridian_enlightenment_string_table[];

typedef struct libxl_ioport_range {
    uint32_t first;
    uint32_t number;
} libxl_ioport_range;
void libxl_ioport_range_dispose(libxl_ioport_range *p);
void libxl_ioport_range_copy(libxl_ctx *ctx, libxl_ioport_range *dst, libxl_ioport_range *src);
void libxl_ioport_range_init(libxl_ioport_range *p);
char *libxl_ioport_range_to_json(libxl_ctx *ctx, libxl_ioport_range *p);
int libxl_ioport_range_from_json(libxl_ctx *ctx, libxl_ioport_range *p, const char *s);

typedef struct libxl_iomem_range {
    uint64_t start;
    uint64_t number;
    uint64_t gfn;
} libxl_iomem_range;
void libxl_iomem_range_dispose(libxl_iomem_range *p);
void libxl_iomem_range_copy(libxl_ctx *ctx, libxl_iomem_range *dst, libxl_iomem_range *src);
void libxl_iomem_range_init(libxl_iomem_range *p);
char *libxl_iomem_range_to_json(libxl_ctx *ctx, libxl_iomem_range *p);
int libxl_iomem_range_from_json(libxl_ctx *ctx, libxl_iomem_range *p, const char *s);

typedef struct libxl_vga_interface_info {
    libxl_vga_interface_type kind;
} libxl_vga_interface_info;
void libxl_vga_interface_info_dispose(libxl_vga_interface_info *p);
void libxl_vga_interface_info_copy(libxl_ctx *ctx, libxl_vga_interface_info *dst, libxl_vga_interface_info *src);
void libxl_vga_interface_info_init(libxl_vga_interface_info *p);
char *libxl_vga_interface_info_to_json(libxl_ctx *ctx, libxl_vga_interface_info *p);
int libxl_vga_interface_info_from_json(libxl_ctx *ctx, libxl_vga_interface_info *p, const char *s);

typedef struct libxl_vnc_info {
    libxl_defbool enable;
    char * listen;
    char * passwd;
    int display;
    libxl_defbool findunused;
} libxl_vnc_info;
void libxl_vnc_info_dispose(libxl_vnc_info *p);
void libxl_vnc_info_copy(libxl_ctx *ctx, libxl_vnc_info *dst, libxl_vnc_info *src);
void libxl_vnc_info_init(libxl_vnc_info *p);
char *libxl_vnc_info_to_json(libxl_ctx *ctx, libxl_vnc_info *p);
int libxl_vnc_info_from_json(libxl_ctx *ctx, libxl_vnc_info *p, const char *s);

typedef struct libxl_spice_info {
    libxl_defbool enable;
    int port;
    int tls_port;
    char * host;
    libxl_defbool disable_ticketing;
    char * passwd;
    libxl_defbool agent_mouse;
    libxl_defbool vdagent;
    libxl_defbool clipboard_sharing;
    int usbredirection;
} libxl_spice_info;
void libxl_spice_info_dispose(libxl_spice_info *p);
void libxl_spice_info_copy(libxl_ctx *ctx, libxl_spice_info *dst, libxl_spice_info *src);
void libxl_spice_info_init(libxl_spice_info *p);
char *libxl_spice_info_to_json(libxl_ctx *ctx, libxl_spice_info *p);
int libxl_spice_info_from_json(libxl_ctx *ctx, libxl_spice_info *p, const char *s);

typedef struct libxl_sdl_info {
    libxl_defbool enable;
    libxl_defbool opengl;
    char * display;
    char * xauthority;
} libxl_sdl_info;
void libxl_sdl_info_dispose(libxl_sdl_info *p);
void libxl_sdl_info_copy(libxl_ctx *ctx, libxl_sdl_info *dst, libxl_sdl_info *src);
void libxl_sdl_info_init(libxl_sdl_info *p);
char *libxl_sdl_info_to_json(libxl_ctx *ctx, libxl_sdl_info *p);
int libxl_sdl_info_from_json(libxl_ctx *ctx, libxl_sdl_info *p, const char *s);

typedef struct libxl_dominfo {
    libxl_uuid uuid;
    libxl_domid domid;
    uint32_t ssidref;
    char * ssid_label;
    bool running;
    bool blocked;
    bool paused;
    bool shutdown;
    bool dying;
    libxl_shutdown_reason shutdown_reason;
    uint64_t outstanding_memkb;
    uint64_t current_memkb;
    uint64_t shared_memkb;
    uint64_t paged_memkb;
    uint64_t max_memkb;
    uint64_t cpu_time;
    uint32_t vcpu_max_id;
    uint32_t vcpu_online;
    uint32_t cpupool;
    libxl_domain_type domain_type;
} libxl_dominfo;
void libxl_dominfo_dispose(libxl_dominfo *p);
void libxl_dominfo_copy(libxl_ctx *ctx, libxl_dominfo *dst, libxl_dominfo *src);
void libxl_dominfo_init(libxl_dominfo *p);
char *libxl_dominfo_to_json(libxl_ctx *ctx, libxl_dominfo *p);
int libxl_dominfo_from_json(libxl_ctx *ctx, libxl_dominfo *p, const char *s);

typedef struct libxl_cpupoolinfo {
    uint32_t poolid;
    char * pool_name;
    libxl_scheduler sched;
    uint32_t n_dom;
    libxl_bitmap cpumap;
} libxl_cpupoolinfo;
void libxl_cpupoolinfo_dispose(libxl_cpupoolinfo *p);
void libxl_cpupoolinfo_copy(libxl_ctx *ctx, libxl_cpupoolinfo *dst, libxl_cpupoolinfo *src);
void libxl_cpupoolinfo_init(libxl_cpupoolinfo *p);
char *libxl_cpupoolinfo_to_json(libxl_ctx *ctx, libxl_cpupoolinfo *p);
int libxl_cpupoolinfo_from_json(libxl_ctx *ctx, libxl_cpupoolinfo *p, const char *s);

typedef struct libxl_channelinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref;
    libxl_channel_connection connection;
    union {
        struct {
            char * path;
        } pty;
    } u;
} libxl_channelinfo;
void libxl_channelinfo_dispose(libxl_channelinfo *p);
void libxl_channelinfo_copy(libxl_ctx *ctx, libxl_channelinfo *dst, libxl_channelinfo *src);
void libxl_channelinfo_init(libxl_channelinfo *p);
void libxl_channelinfo_init_connection(libxl_channelinfo *p, libxl_channel_connection connection);
char *libxl_channelinfo_to_json(libxl_ctx *ctx, libxl_channelinfo *p);
int libxl_channelinfo_from_json(libxl_ctx *ctx, libxl_channelinfo *p, const char *s);

typedef struct libxl_vminfo {
    libxl_uuid uuid;
    libxl_domid domid;
} libxl_vminfo;
void libxl_vminfo_dispose(libxl_vminfo *p);
void libxl_vminfo_copy(libxl_ctx *ctx, libxl_vminfo *dst, libxl_vminfo *src);
void libxl_vminfo_init(libxl_vminfo *p);
char *libxl_vminfo_to_json(libxl_ctx *ctx, libxl_vminfo *p);
int libxl_vminfo_from_json(libxl_ctx *ctx, libxl_vminfo *p, const char *s);

typedef struct libxl_version_info {
    int xen_version_major;
    int xen_version_minor;
    char * xen_version_extra;
    char * compiler;
    char * compile_by;
    char * compile_domain;
    char * compile_date;
    char * capabilities;
    char * changeset;
    uint64_t virt_start;
    int pagesize;
    char * commandline;
} libxl_version_info;
void libxl_version_info_dispose(libxl_version_info *p);
void libxl_version_info_copy(libxl_ctx *ctx, libxl_version_info *dst, libxl_version_info *src);
void libxl_version_info_init(libxl_version_info *p);
char *libxl_version_info_to_json(libxl_ctx *ctx, libxl_version_info *p);
int libxl_version_info_from_json(libxl_ctx *ctx, libxl_version_info *p, const char *s);

typedef struct libxl_domain_create_info {
    libxl_domain_type type;
    libxl_defbool hap;
    libxl_defbool oos;
    uint32_t ssidref;
    char * ssid_label;
    char * name;
    libxl_uuid uuid;
    libxl_key_value_list xsdata;
    libxl_key_value_list platformdata;
    uint32_t poolid;
    char * pool_name;
    libxl_defbool run_hotplug_scripts;
    libxl_defbool pvh;
    libxl_defbool driver_domain;
} libxl_domain_create_info;
void libxl_domain_create_info_dispose(libxl_domain_create_info *p);
void libxl_domain_create_info_copy(libxl_ctx *ctx, libxl_domain_create_info *dst, libxl_domain_create_info *src);
void libxl_domain_create_info_init(libxl_domain_create_info *p);
char *libxl_domain_create_info_to_json(libxl_ctx *ctx, libxl_domain_create_info *p);
int libxl_domain_create_info_from_json(libxl_ctx *ctx, libxl_domain_create_info *p, const char *s);

typedef struct libxl_domain_restore_params {
    int checkpointed_stream;
} libxl_domain_restore_params;
void libxl_domain_restore_params_dispose(libxl_domain_restore_params *p);
void libxl_domain_restore_params_copy(libxl_ctx *ctx, libxl_domain_restore_params *dst, libxl_domain_restore_params *src);
void libxl_domain_restore_params_init(libxl_domain_restore_params *p);
char *libxl_domain_restore_params_to_json(libxl_ctx *ctx, libxl_domain_restore_params *p);
int libxl_domain_restore_params_from_json(libxl_ctx *ctx, libxl_domain_restore_params *p, const char *s);

typedef struct libxl_domain_sched_params {
    libxl_scheduler sched;
    int weight;
    int cap;
    int period;
    int slice;
    int latency;
    int extratime;
    int budget;
} libxl_domain_sched_params;
void libxl_domain_sched_params_dispose(libxl_domain_sched_params *p);
void libxl_domain_sched_params_copy(libxl_ctx *ctx, libxl_domain_sched_params *dst, libxl_domain_sched_params *src);
void libxl_domain_sched_params_init(libxl_domain_sched_params *p);
char *libxl_domain_sched_params_to_json(libxl_ctx *ctx, libxl_domain_sched_params *p);
int libxl_domain_sched_params_from_json(libxl_ctx *ctx, libxl_domain_sched_params *p, const char *s);

typedef struct libxl_domain_build_info {
    int max_vcpus;
    libxl_bitmap avail_vcpus;
    libxl_bitmap cpumap;
    libxl_bitmap nodemap;
    int num_vcpu_hard_affinity;
    libxl_bitmap * vcpu_hard_affinity;
    int num_vcpu_soft_affinity;
    libxl_bitmap * vcpu_soft_affinity;
    libxl_defbool numa_placement;
    libxl_tsc_mode tsc_mode;
    uint64_t max_memkb;
    uint64_t target_memkb;
    uint64_t video_memkb;
    uint64_t shadow_memkb;
    uint32_t rtc_timeoffset;
    uint32_t exec_ssidref;
    char * exec_ssid_label;
    libxl_defbool localtime;
    libxl_defbool disable_migrate;
    libxl_cpuid_policy_list cpuid;
    char * blkdev_start;
    libxl_device_model_version device_model_version;
    libxl_defbool device_model_stubdomain;
    char * device_model;
    uint32_t device_model_ssidref;
    char * device_model_ssid_label;
    libxl_string_list extra;
    libxl_string_list extra_pv;
    libxl_string_list extra_hvm;
    libxl_domain_sched_params sched_params;
    int num_ioports;
    libxl_ioport_range * ioports;
    int num_irqs;
    uint32_t * irqs;
    int num_iomem;
    libxl_iomem_range * iomem;
    libxl_defbool claim_mode;
    uint32_t event_channels;
    char * kernel;
    char * cmdline;
    char * ramdisk;
    libxl_domain_type type;
    union {
        struct {
            char * firmware;
            libxl_bios_type bios;
            libxl_defbool pae;
            libxl_defbool apic;
            libxl_defbool acpi;
            libxl_defbool acpi_s3;
            libxl_defbool acpi_s4;
            libxl_defbool nx;
            libxl_defbool viridian;
            libxl_bitmap viridian_enable;
            libxl_bitmap viridian_disable;
            char * timeoffset;
            libxl_defbool hpet;
            libxl_defbool vpt_align;
            uint64_t mmio_hole_memkb;
            libxl_timer_mode timer_mode;
            libxl_defbool nested_hvm;
            char * smbios_firmware;
            char * acpi_firmware;
            libxl_defbool nographic;
            libxl_vga_interface_info vga;
            libxl_vnc_info vnc;
            char * keymap;
            libxl_sdl_info sdl;
            libxl_spice_info spice;
            libxl_defbool gfx_passthru;
            char * serial;
            char * boot;
            libxl_defbool usb;
            int usbversion;
            char * usbdevice;
            char * soundhw;
            libxl_defbool xen_platform_pci;
            libxl_string_list usbdevice_list;
            libxl_vendor_device vendor_device;
            libxl_ms_vm_genid ms_vm_genid;
            libxl_string_list serial_list;
        } hvm;
        struct {
            char * kernel;
            uint64_t slack_memkb;
            char * bootloader;
            libxl_string_list bootloader_args;
            char * cmdline;
            char * ramdisk;
            const char * features;
            libxl_defbool e820_host;
        } pv;
    } u;
} libxl_domain_build_info;
void libxl_domain_build_info_dispose(libxl_domain_build_info *p);
void libxl_domain_build_info_copy(libxl_ctx *ctx, libxl_domain_build_info *dst, libxl_domain_build_info *src);
void libxl_domain_build_info_init(libxl_domain_build_info *p);
void libxl_domain_build_info_init_type(libxl_domain_build_info *p, libxl_domain_type type);
char *libxl_domain_build_info_to_json(libxl_ctx *ctx, libxl_domain_build_info *p);
int libxl_domain_build_info_from_json(libxl_ctx *ctx, libxl_domain_build_info *p, const char *s);

typedef struct libxl_device_vfb {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    libxl_vnc_info vnc;
    libxl_sdl_info sdl;
    char * keymap;
} libxl_device_vfb;
void libxl_device_vfb_dispose(libxl_device_vfb *p);
void libxl_device_vfb_copy(libxl_ctx *ctx, libxl_device_vfb *dst, libxl_device_vfb *src);
void libxl_device_vfb_init(libxl_device_vfb *p);
char *libxl_device_vfb_to_json(libxl_ctx *ctx, libxl_device_vfb *p);
int libxl_device_vfb_from_json(libxl_ctx *ctx, libxl_device_vfb *p, const char *s);

typedef struct libxl_device_vkb {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
} libxl_device_vkb;
void libxl_device_vkb_dispose(libxl_device_vkb *p);
void libxl_device_vkb_copy(libxl_ctx *ctx, libxl_device_vkb *dst, libxl_device_vkb *src);
void libxl_device_vkb_init(libxl_device_vkb *p);
char *libxl_device_vkb_to_json(libxl_ctx *ctx, libxl_device_vkb *p);
int libxl_device_vkb_from_json(libxl_ctx *ctx, libxl_device_vkb *p, const char *s);

typedef struct libxl_device_disk {
    libxl_domid backend_domid;
    char * backend_domname;
    char * pdev_path;
    char * vdev;
    libxl_disk_backend backend;
    libxl_disk_format format;
    char * script;
    int removable;
    int readwrite;
    int is_cdrom;
    bool direct_io_safe;
    libxl_defbool discard_enable;
} libxl_device_disk;
void libxl_device_disk_dispose(libxl_device_disk *p);
void libxl_device_disk_copy(libxl_ctx *ctx, libxl_device_disk *dst, libxl_device_disk *src);
void libxl_device_disk_init(libxl_device_disk *p);
char *libxl_device_disk_to_json(libxl_ctx *ctx, libxl_device_disk *p);
int libxl_device_disk_from_json(libxl_ctx *ctx, libxl_device_disk *p, const char *s);

typedef struct libxl_device_nic {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    int mtu;
    char * model;
    libxl_mac mac;
    char * ip;
    char * bridge;
    char * ifname;
    char * script;
    libxl_nic_type nictype;
    uint64_t rate_bytes_per_interval;
    uint32_t rate_interval_usecs;
    char * gatewaydev;
} libxl_device_nic;
void libxl_device_nic_dispose(libxl_device_nic *p);
void libxl_device_nic_copy(libxl_ctx *ctx, libxl_device_nic *dst, libxl_device_nic *src);
void libxl_device_nic_init(libxl_device_nic *p);
char *libxl_device_nic_to_json(libxl_ctx *ctx, libxl_device_nic *p);
int libxl_device_nic_from_json(libxl_ctx *ctx, libxl_device_nic *p, const char *s);

typedef struct libxl_device_pci {
    uint8_t func;
    uint8_t dev;
    uint8_t bus;
    int domain;
    uint32_t vdevfn;
    uint32_t vfunc_mask;
    bool msitranslate;
    bool power_mgmt;
    bool permissive;
    bool seize;
} libxl_device_pci;
void libxl_device_pci_dispose(libxl_device_pci *p);
void libxl_device_pci_copy(libxl_ctx *ctx, libxl_device_pci *dst, libxl_device_pci *src);
void libxl_device_pci_init(libxl_device_pci *p);
char *libxl_device_pci_to_json(libxl_ctx *ctx, libxl_device_pci *p);
int libxl_device_pci_from_json(libxl_ctx *ctx, libxl_device_pci *p, const char *s);

typedef struct libxl_device_vtpm {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    libxl_uuid uuid;
} libxl_device_vtpm;
void libxl_device_vtpm_dispose(libxl_device_vtpm *p);
void libxl_device_vtpm_copy(libxl_ctx *ctx, libxl_device_vtpm *dst, libxl_device_vtpm *src);
void libxl_device_vtpm_init(libxl_device_vtpm *p);
char *libxl_device_vtpm_to_json(libxl_ctx *ctx, libxl_device_vtpm *p);
int libxl_device_vtpm_from_json(libxl_ctx *ctx, libxl_device_vtpm *p, const char *s);

typedef struct libxl_device_channel {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    char * name;
    libxl_channel_connection connection;
    union {
        struct {
            char * path;
        } socket;
    } u;
} libxl_device_channel;
void libxl_device_channel_dispose(libxl_device_channel *p);
void libxl_device_channel_copy(libxl_ctx *ctx, libxl_device_channel *dst, libxl_device_channel *src);
void libxl_device_channel_init(libxl_device_channel *p);
void libxl_device_channel_init_connection(libxl_device_channel *p, libxl_channel_connection connection);
char *libxl_device_channel_to_json(libxl_ctx *ctx, libxl_device_channel *p);
int libxl_device_channel_from_json(libxl_ctx *ctx, libxl_device_channel *p, const char *s);

typedef struct libxl_domain_config {
    libxl_domain_create_info c_info;
    libxl_domain_build_info b_info;
    int num_disks;
    libxl_device_disk * disks;
    int num_nics;
    libxl_device_nic * nics;
    int num_pcidevs;
    libxl_device_pci * pcidevs;
    int num_vfbs;
    libxl_device_vfb * vfbs;
    int num_vkbs;
    libxl_device_vkb * vkbs;
    int num_vtpms;
    libxl_device_vtpm * vtpms;
    int num_channels;
    libxl_device_channel * channels;
    libxl_action_on_shutdown on_poweroff;
    libxl_action_on_shutdown on_reboot;
    libxl_action_on_shutdown on_watchdog;
    libxl_action_on_shutdown on_crash;
} libxl_domain_config;
void libxl_domain_config_dispose(libxl_domain_config *p);
void libxl_domain_config_copy(libxl_ctx *ctx, libxl_domain_config *dst, libxl_domain_config *src);
void libxl_domain_config_init(libxl_domain_config *p);
char *libxl_domain_config_to_json(libxl_ctx *ctx, libxl_domain_config *p);
int libxl_domain_config_from_json(libxl_ctx *ctx, libxl_domain_config *p, const char *s);

typedef struct libxl_diskinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref;
} libxl_diskinfo;
void libxl_diskinfo_dispose(libxl_diskinfo *p);
void libxl_diskinfo_copy(libxl_ctx *ctx, libxl_diskinfo *dst, libxl_diskinfo *src);
void libxl_diskinfo_init(libxl_diskinfo *p);
char *libxl_diskinfo_to_json(libxl_ctx *ctx, libxl_diskinfo *p);
int libxl_diskinfo_from_json(libxl_ctx *ctx, libxl_diskinfo *p, const char *s);

typedef struct libxl_nicinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref_tx;
    int rref_rx;
} libxl_nicinfo;
void libxl_nicinfo_dispose(libxl_nicinfo *p);
void libxl_nicinfo_copy(libxl_ctx *ctx, libxl_nicinfo *dst, libxl_nicinfo *src);
void libxl_nicinfo_init(libxl_nicinfo *p);
char *libxl_nicinfo_to_json(libxl_ctx *ctx, libxl_nicinfo *p);
int libxl_nicinfo_from_json(libxl_ctx *ctx, libxl_nicinfo *p, const char *s);

typedef struct libxl_vtpminfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref;
    libxl_uuid uuid;
} libxl_vtpminfo;
void libxl_vtpminfo_dispose(libxl_vtpminfo *p);
void libxl_vtpminfo_copy(libxl_ctx *ctx, libxl_vtpminfo *dst, libxl_vtpminfo *src);
void libxl_vtpminfo_init(libxl_vtpminfo *p);
char *libxl_vtpminfo_to_json(libxl_ctx *ctx, libxl_vtpminfo *p);
int libxl_vtpminfo_from_json(libxl_ctx *ctx, libxl_vtpminfo *p, const char *s);

typedef struct libxl_vcpuinfo {
    uint32_t vcpuid;
    uint32_t cpu;
    bool online;
    bool blocked;
    bool running;
    uint64_t vcpu_time;
    libxl_bitmap cpumap;
    libxl_bitmap cpumap_soft;
} libxl_vcpuinfo;
void libxl_vcpuinfo_dispose(libxl_vcpuinfo *p);
void libxl_vcpuinfo_copy(libxl_ctx *ctx, libxl_vcpuinfo *dst, libxl_vcpuinfo *src);
void libxl_vcpuinfo_init(libxl_vcpuinfo *p);
char *libxl_vcpuinfo_to_json(libxl_ctx *ctx, libxl_vcpuinfo *p);
int libxl_vcpuinfo_from_json(libxl_ctx *ctx, libxl_vcpuinfo *p, const char *s);

typedef struct libxl_physinfo {
    uint32_t threads_per_core;
    uint32_t cores_per_socket;
    uint32_t max_cpu_id;
    uint32_t nr_cpus;
    uint32_t cpu_khz;
    uint64_t total_pages;
    uint64_t free_pages;
    uint64_t scrub_pages;
    uint64_t outstanding_pages;
    uint64_t sharing_freed_pages;
    uint64_t sharing_used_frames;
    uint32_t nr_nodes;
    libxl_hwcap hw_cap;
    bool cap_hvm;
    bool cap_hvm_directio;
} libxl_physinfo;
void libxl_physinfo_dispose(libxl_physinfo *p);
void libxl_physinfo_copy(libxl_ctx *ctx, libxl_physinfo *dst, libxl_physinfo *src);
void libxl_physinfo_init(libxl_physinfo *p);
char *libxl_physinfo_to_json(libxl_ctx *ctx, libxl_physinfo *p);
int libxl_physinfo_from_json(libxl_ctx *ctx, libxl_physinfo *p, const char *s);

typedef struct libxl_numainfo {
    uint64_t size;
    uint64_t free;
    int num_dists;
    uint32_t * dists;
} libxl_numainfo;
void libxl_numainfo_dispose(libxl_numainfo *p);
void libxl_numainfo_copy(libxl_ctx *ctx, libxl_numainfo *dst, libxl_numainfo *src);
void libxl_numainfo_init(libxl_numainfo *p);
char *libxl_numainfo_to_json(libxl_ctx *ctx, libxl_numainfo *p);
int libxl_numainfo_from_json(libxl_ctx *ctx, libxl_numainfo *p, const char *s);

typedef struct libxl_cputopology {
    uint32_t core;
    uint32_t socket;
    uint32_t node;
} libxl_cputopology;
void libxl_cputopology_dispose(libxl_cputopology *p);
void libxl_cputopology_copy(libxl_ctx *ctx, libxl_cputopology *dst, libxl_cputopology *src);
void libxl_cputopology_init(libxl_cputopology *p);
char *libxl_cputopology_to_json(libxl_ctx *ctx, libxl_cputopology *p);
int libxl_cputopology_from_json(libxl_ctx *ctx, libxl_cputopology *p, const char *s);

typedef struct libxl_sched_credit_params {
    int tslice_ms;
    int ratelimit_us;
} libxl_sched_credit_params;
void libxl_sched_credit_params_copy(libxl_ctx *ctx, libxl_sched_credit_params *dst, libxl_sched_credit_params *src);
void libxl_sched_credit_params_init(libxl_sched_credit_params *p);
char *libxl_sched_credit_params_to_json(libxl_ctx *ctx, libxl_sched_credit_params *p);
int libxl_sched_credit_params_from_json(libxl_ctx *ctx, libxl_sched_credit_params *p, const char *s);

typedef struct libxl_domain_remus_info {
    int interval;
    libxl_defbool allow_unsafe;
    libxl_defbool blackhole;
    libxl_defbool compression;
    libxl_defbool netbuf;
    char * netbufscript;
    libxl_defbool diskbuf;
} libxl_domain_remus_info;
void libxl_domain_remus_info_dispose(libxl_domain_remus_info *p);
void libxl_domain_remus_info_copy(libxl_ctx *ctx, libxl_domain_remus_info *dst, libxl_domain_remus_info *src);
void libxl_domain_remus_info_init(libxl_domain_remus_info *p);
char *libxl_domain_remus_info_to_json(libxl_ctx *ctx, libxl_domain_remus_info *p);
int libxl_domain_remus_info_from_json(libxl_ctx *ctx, libxl_domain_remus_info *p, const char *s);

typedef enum libxl_event_type {
    LIBXL_EVENT_TYPE_DOMAIN_SHUTDOWN = 1,
    LIBXL_EVENT_TYPE_DOMAIN_DEATH = 2,
    LIBXL_EVENT_TYPE_DISK_EJECT = 3,
    LIBXL_EVENT_TYPE_OPERATION_COMPLETE = 4,
    LIBXL_EVENT_TYPE_DOMAIN_CREATE_CONSOLE_AVAILABLE = 5,
} libxl_event_type;
char *libxl_event_type_to_json(libxl_ctx *ctx, libxl_event_type p);
int libxl_event_type_from_json(libxl_ctx *ctx, libxl_event_type *p, const char *s);
const char *libxl_event_type_to_string(libxl_event_type p);
int libxl_event_type_from_string(const char *s, libxl_event_type *e);
extern libxl_enum_string_table libxl_event_type_string_table[];

typedef struct libxl_event {
    libxl_ev_link link;
    libxl_domid domid;
    libxl_uuid domuuid;
    uint64_t for_user;
    libxl_event_type type;
    union {
        struct {
            uint8_t shutdown_reason;
        } domain_shutdown;
        struct {
            char * vdev;
            libxl_device_disk disk;
        } disk_eject;
        struct {
            int rc;
        } operation_complete;
    } u;
} libxl_event;
void libxl_event_dispose(libxl_event *p);
void libxl_event_copy(libxl_ctx *ctx, libxl_event *dst, libxl_event *src);
void libxl_event_init(libxl_event *p);
void libxl_event_init_type(libxl_event *p, libxl_event_type type);
char *libxl_event_to_json(libxl_ctx *ctx, libxl_event *p);
int libxl_event_from_json(libxl_ctx *ctx, libxl_event *p, const char *s);

typedef enum libxl_psr_cmt_type {
    LIBXL_PSR_CMT_TYPE_CACHE_OCCUPANCY = 1,
} libxl_psr_cmt_type;
char *libxl_psr_cmt_type_to_json(libxl_ctx *ctx, libxl_psr_cmt_type p);
int libxl_psr_cmt_type_from_json(libxl_ctx *ctx, libxl_psr_cmt_type *p, const char *s);
const char *libxl_psr_cmt_type_to_string(libxl_psr_cmt_type p);
int libxl_psr_cmt_type_from_string(const char *s, libxl_psr_cmt_type *e);
extern libxl_enum_string_table libxl_psr_cmt_type_string_table[];

#endif /* __LIBXL_TYPES_H */
