/* THIS FILE IS AUTOGENERATED FROM AnimationEffectReadOnly.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_AnimationEffectReadOnlyBinding_h
#define mozilla_dom_AnimationEffectReadOnlyBinding_h

#include "AnimationEffectReadOnlyBinding.h"
#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class AnimationEffectReadOnly;
struct AnimationEffectReadOnlyAtoms;
struct AnimationEffectTimingPropertiesAtoms;
struct ComputedTimingPropertiesAtoms;
struct NativePropertyHooks;
class OwningUnrestrictedDoubleOrString;
class ProtoAndIfaceCache;
class UnrestrictedDoubleOrString;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class FillMode : uint32_t {
  None,
  Forwards,
  Backwards,
  Both,
  Auto,
  EndGuard_
};

namespace FillModeValues {
extern const EnumEntry strings[6];
} // namespace FillModeValues

bool
ToJSValue(JSContext* aCx, FillMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class PlaybackDirection : uint32_t {
  Normal,
  Reverse,
  Alternate,
  Alternate_reverse,
  EndGuard_
};

namespace PlaybackDirectionValues {
extern const EnumEntry strings[5];
} // namespace PlaybackDirectionValues

bool
ToJSValue(JSContext* aCx, PlaybackDirection aArgument, JS::MutableHandle<JS::Value> aValue);


class UnrestrictedDoubleOrString
{
  friend class UnrestrictedDoubleOrStringArgument;
  enum Type
  {
    eUninitialized,
    eUnrestrictedDouble,
    eString
  };

  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<binding_detail::FakeString > mString;

  };

  Type mType;
  Value mValue;

  UnrestrictedDoubleOrString(const UnrestrictedDoubleOrString&) = delete;
  void operator=(const UnrestrictedDoubleOrString) = delete;
public:
  explicit inline UnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  inline ~UnrestrictedDoubleOrString()
  {
    Uninit();
  }

  inline double&
  RawSetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline double&
  SetAsUnrestrictedDouble()
  {
    if (mType == eUnrestrictedDouble) {
      return mValue.mUnrestrictedDouble.Value();
    }
    Uninit();
    mType = eUnrestrictedDouble;
    return mValue.mUnrestrictedDouble.SetValue();
  }

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double
  GetAsUnrestrictedDouble() const
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline binding_detail::FakeString&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUnrestrictedDouble: {
        DestroyUnrestrictedDouble();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    mValue.mUnrestrictedDouble.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningUnrestrictedDoubleOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningUnrestrictedDoubleOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eUnrestrictedDouble,
    eString
  };

  union Value
  {
    UnionMember<double > mUnrestrictedDouble;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningUnrestrictedDoubleOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningUnrestrictedDoubleOrString(const OwningUnrestrictedDoubleOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUnrestrictedDoubleOrString()
  {
    Uninit();
  }

  double&
  RawSetAsUnrestrictedDouble();

  double&
  SetAsUnrestrictedDouble();

  bool
  TrySetToUnrestrictedDouble(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsUnrestrictedDouble() const
  {
    return mType == eUnrestrictedDouble;
  }

  inline double&
  GetAsUnrestrictedDouble()
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  inline double const &
  GetAsUnrestrictedDouble() const
  {
    MOZ_ASSERT(IsUnrestrictedDouble(), "Wrong type!");
    return mValue.mUnrestrictedDouble.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsString().Assign(aData, aLength);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningUnrestrictedDoubleOrString& aOther);

private:
  void
  DestroyUnrestrictedDouble();

  void
  DestroyString();
};


struct AnimationEffectTimingProperties : public DictionaryBase
{
  double mDelay;
  PlaybackDirection mDirection;
  OwningUnrestrictedDoubleOrString mDuration;
  nsString mEasing;
  double mEndDelay;
  FillMode mFill;
  double mIterationStart;
  double mIterations;

  AnimationEffectTimingProperties();

  explicit inline AnimationEffectTimingProperties(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline AnimationEffectTimingProperties(const AnimationEffectTimingProperties& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const AnimationEffectTimingProperties& aOther);

private:
  static bool
  InitIds(JSContext* cx, AnimationEffectTimingPropertiesAtoms* atomsCache);
};

namespace binding_detail {
struct FastAnimationEffectTimingProperties : public AnimationEffectTimingProperties
{
  inline FastAnimationEffectTimingProperties()
    : AnimationEffectTimingProperties(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ComputedTimingProperties : public AnimationEffectTimingProperties
{
  double mActiveDuration;
  Nullable<double> mCurrentIteration;
  double mEndTime;
  Nullable<double> mLocalTime;
  Nullable<double> mProgress;

  ComputedTimingProperties();

  explicit inline ComputedTimingProperties(const FastDictionaryInitializer& )
    : AnimationEffectTimingProperties(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  explicit inline ComputedTimingProperties(const ComputedTimingProperties& aOther)
  {
    *this = aOther;
  }

  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(const nsAString& aJSON);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  bool
  ToJSON(nsAString& aJSON) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ComputedTimingProperties& aOther);

private:
  static bool
  InitIds(JSContext* cx, ComputedTimingPropertiesAtoms* atomsCache);
};

namespace binding_detail {
struct FastComputedTimingProperties : public ComputedTimingProperties
{
  inline FastComputedTimingProperties()
    : ComputedTimingProperties(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace AnimationEffectReadOnlyBinding {

  typedef mozilla::dom::AnimationEffectReadOnly NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JSObject*
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace AnimationEffectReadOnlyBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_AnimationEffectReadOnlyBinding_h
