/* THIS FILE IS AUTOGENERATED FROM EventHandler.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_EventHandlerBinding_h
#define mozilla_dom_EventHandlerBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Event;
class EventHandlerNonNull;
class EventOrString;
struct NativePropertyHooks;
class OnBeforeUnloadEventHandlerNonNull;
class OnErrorEventHandlerNonNull;
class OwningEventOrString;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningEventOrString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningEventOrString& aUnion);


class EventOrString
{
  friend class EventOrStringArgument;
  enum Type
  {
    eUninitialized,
    eEvent,
    eString
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::Event> > mEvent;
    UnionMember<binding_detail::FakeString > mString;

  };

  Type mType;
  Value mValue;

  EventOrString(const EventOrString&) = delete;
  void operator=(const EventOrString) = delete;
public:
  explicit inline EventOrString()
    : mType(eUninitialized)
  {
  }

  inline ~EventOrString()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Event>&
  RawSetAsEvent()
  {
    if (mType == eEvent) {
      return mValue.mEvent.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eEvent;
    return mValue.mEvent.SetValue();
  }

  inline NonNull<mozilla::dom::Event>&
  SetAsEvent()
  {
    if (mType == eEvent) {
      return mValue.mEvent.Value();
    }
    Uninit();
    mType = eEvent;
    return mValue.mEvent.SetValue();
  }

  inline bool
  IsEvent() const
  {
    return mType == eEvent;
  }

  inline NonNull<mozilla::dom::Event>&
  GetAsEvent()
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline mozilla::dom::Event&
  GetAsEvent() const
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline binding_detail::FakeString&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eEvent: {
        DestroyEvent();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyEvent()
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    mValue.mEvent.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningEventOrString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningEventOrString& aUnion);
  enum Type
  {
    eUninitialized,
    eEvent,
    eString
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Event> > mEvent;
    UnionMember<nsString > mString;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningEventOrString()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningEventOrString(const OwningEventOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningEventOrString()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Event>&
  RawSetAsEvent();

  OwningNonNull<mozilla::dom::Event>&
  SetAsEvent();

  bool
  TrySetToEvent(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsEvent() const
  {
    return mType == eEvent;
  }

  inline OwningNonNull<mozilla::dom::Event>&
  GetAsEvent()
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  inline OwningNonNull<mozilla::dom::Event> const &
  GetAsEvent() const
  {
    MOZ_ASSERT(IsEvent(), "Wrong type!");
    return mValue.mEvent.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsString().Assign(aData, aLength);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningEventOrString& aOther);

private:
  void
  DestroyEvent();

  void
  DestroyString();
};


class EventHandlerNonNull : public CallbackFunction
{
public:
  explicit inline EventHandlerNonNull(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline EventHandlerNonNull(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, Event& event, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "EventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, event, aRetVal, aRv);
  }

  inline void
  Call(Event& event, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "EventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, event, aRetVal, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, Event& event, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, event, aRetVal, rv, aExecutionReason);
  }

  inline void
  Call(Event& event, JS::MutableHandle<JS::Value> aRetVal, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(event, aRetVal, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const EventHandlerNonNull& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, Event& event, JS::MutableHandle<JS::Value> aRetVal, ErrorResult& aRv);
};


class OnBeforeUnloadEventHandlerNonNull : public CallbackFunction
{
public:
  explicit inline OnBeforeUnloadEventHandlerNonNull(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline OnBeforeUnloadEventHandlerNonNull(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, Event& event, nsString& aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "OnBeforeUnloadEventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, event, aRetVal, aRv);
  }

  inline void
  Call(Event& event, nsString& aRetVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "OnBeforeUnloadEventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, event, aRetVal, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, Event& event, nsString& aRetVal, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, event, aRetVal, rv, aExecutionReason);
  }

  inline void
  Call(Event& event, nsString& aRetVal, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(event, aRetVal, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const OnBeforeUnloadEventHandlerNonNull& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, Event& event, nsString& aRetVal, ErrorResult& aRv);
};


class OnErrorEventHandlerNonNull : public CallbackFunction
{
public:
  explicit inline OnErrorEventHandlerNonNull(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline OnErrorEventHandlerNonNull(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline bool
  Call(const T& thisVal, const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "OnErrorEventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return bool(0);
    }
    return Call(s.GetContext(), thisValJS, event, source, lineno, column, error, aRv);
  }

  inline bool
  Call(const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "OnErrorEventHandlerNonNull";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, event, source, lineno, column, error, aRv);
  }

  template <typename T>
  inline bool
  Call(const T& thisVal, const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, event, source, lineno, column, error, rv, aExecutionReason);
  }

  inline bool
  Call(const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(event, source, lineno, column, error, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const OnErrorEventHandlerNonNull& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  bool Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, const EventOrString& event, const Optional<nsAString>& source, const Optional<uint32_t>& lineno, const Optional<uint32_t>& column, const Optional<JS::Handle<JS::Value>>& error, ErrorResult& aRv);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_EventHandlerBinding_h
