//@line 2 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
XPCOMUtils.defineLazyModuleGetter(this, "Services", "resource://gre/modules/Services.jsm");

this.EXPORTED_SYMBOLS = ["AppConstants"];

// Immutable for export.
this.AppConstants = Object.freeze({
  // See this wiki page for more details about channel specific build
  // defines: https://wiki.mozilla.org/Platform/Channel-specific_build_defines
  NIGHTLY_BUILD:
//@line 21 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 23 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  RELEASE_BUILD:
//@line 26 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 30 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  ACCESSIBILITY:
//@line 33 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 37 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  // Official corresponds, roughly, to whether this build is performed
  // on Mozilla's continuous integration infrastructure. You should
  // disable developer-only functionality when this flag is set.
  MOZILLA_OFFICIAL:
//@line 45 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 47 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_OFFICIAL_BRANDING:
//@line 52 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 54 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_HEALTHREPORT:
//@line 57 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 61 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_DATA_REPORTING:
//@line 64 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 68 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_DEVICES:
//@line 73 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 75 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SAFE_BROWSING:
//@line 80 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 82 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SANDBOX:
//@line 87 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 89 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_REPORTING:
//@line 94 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 96 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_TELEMETRY_ON_BY_DEFAULT:
//@line 101 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 103 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SERVICES_CLOUDSYNC:
//@line 108 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 110 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_UPDATER:
//@line 115 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 117 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_SWITCHBOARD:
//@line 122 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 124 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_WEBRTC:
//@line 129 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 131 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

//@line 133 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  MOZ_B2G:
//@line 137 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 139 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

//@line 142 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  platform:
//@line 144 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  "linux",
//@line 160 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  isPlatformAndVersionAtLeast(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) >= 0;
  },

  isPlatformAndVersionAtMost(platform, version) {
    let platformVersion = Services.sysinfo.getProperty("version");
    return platform == this.platform &&
           Services.vc.compare(platformVersion, version) <= 0;
  },

  MOZ_CRASHREPORTER:
//@line 177 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 179 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_VERIFY_MAR_SIGNATURE:
//@line 184 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 186 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_MAINTENANCE_SERVICE:
//@line 191 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 193 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  E10S_TESTING_ONLY:
//@line 198 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 200 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  DEBUG:
//@line 205 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 207 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_B2G_RIL:
//@line 212 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 214 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_B2GDROID:
//@line 219 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 221 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_GRAPHENE:
//@line 226 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 228 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_PLACES:
//@line 231 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  true,
//@line 235 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  MOZ_ANDROID_HISTORY:
//@line 240 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  false,
//@line 242 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"

  DLL_PREFIX: "lib",
  DLL_SUFFIX: ".so",

  MOZ_APP_NAME: "xulrunner",
  MOZ_APP_VERSION: "45.9.0",
  MOZ_APP_VERSION_DISPLAY: "45.9.0",
  MOZ_BUILD_APP: "xulrunner",
  MOZ_MACBUNDLE_NAME: "XULRunner.app",
  MOZ_UPDATE_CHANNEL: "default",
  INSTALL_LOCALE: "en-US",
  MOZ_WIDGET_TOOLKIT: "gtk2",
  ANDROID_PACKAGE_NAME: "",
  MOZ_B2G_VERSION: "1.0.0",
  MOZ_B2G_OS_NAME: "",

  MOZ_ANDROID_APZ:
//@line 262 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
    false,
//@line 264 "/usr/pkgsrc/devel/xulrunner45/work/firefox-45.9.0esr/toolkit/modules/AppConstants.jsm"
  DEBUG_JS_MODULES: "",

  // URL to the hg revision this was built from (e.g.
  // "https://hg.mozilla.org/mozilla-central/rev/6256ec9113c1")
  // On unofficial builds, this is an empty string.
  SOURCE_REVISION_URL: ""
});
