/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;

public final class probe_file {
    public static final Primitive PROBE_FILE = new pf_probe_file();
    public static final Primitive TRUENAME = new pf_truename();
    public static final Primitive PROBE_DIRECTORY = new pf_probe_directory();
    public static final Primitive FILE_DIRECTORY_P = new pf_file_directory_p();

    @DocString(name="file-directory-p", args="pathspec &key (wild-error-p t)", returns="generalized-boolean")
    private static final class pf_file_directory_p
    extends Primitive {
        pf_file_directory_p() {
            super("file-directory-p", Lisp.PACKAGE_EXT, true);
        }

        private LispObject isDirectory(Pathname p) {
            File file = p.getFile();
            return file.isDirectory() ? Lisp.T : Lisp.NIL;
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
            }
            return this.isDirectory(pathname);
        }

        @Override
        public LispObject execute(LispObject arg, LispObject wildErrorPKeyword, LispObject wildErrorP) {
            if (!wildErrorPKeyword.equals(Keyword.WILD_ERROR_P)) {
                Lisp.type_error(wildErrorPKeyword, Keyword.WILD_ERROR_P);
            }
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (wildErrorP != Lisp.NIL && pathname.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
            }
            return this.isDirectory(pathname);
        }
    }

    @DocString(name="probe-directory", args="pathspec", returns="truename")
    private static final class pf_probe_directory
    extends Primitive {
        pf_probe_directory() {
            super("probe-directory", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname defaultedPathname;
            File file;
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname.isWild()) {
                Lisp.error(new FileError("Bad place for a wild pathname.", pathname));
            }
            return (file = (defaultedPathname = (Pathname)Pathname.MERGE_PATHNAMES.execute(pathname)).getFile()).isDirectory() ? Pathname.getDirectoryPathname(file) : Lisp.NIL;
        }
    }

    @DocString(name="truename", args="pathspec", returns="pathname")
    private static class pf_truename
    extends Primitive {
        pf_truename() {
            super("truename", "filespec");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return Pathname.truename(arg, true);
        }
    }

    @DocString(name="probe-file", args="pathspec", returns="truename")
    private static final class pf_probe_file
    extends Primitive {
        pf_probe_file() {
            super("probe-file", "pathspec");
        }

        @Override
        public LispObject execute(LispObject arg) {
            return Pathname.truename(arg, false);
        }
    }
}

