/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptRoot;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;

public class EElvis
extends AExpression {
    private AExpression lhs;
    private AExpression rhs;

    public EElvis(Location location, AExpression lhs, AExpression rhs) {
        super(location);
        this.lhs = Objects.requireNonNull(lhs);
        this.rhs = Objects.requireNonNull(rhs);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.lhs.extractVariables(variables);
        this.rhs.extractVariables(variables);
    }

    @Override
    void analyze(ScriptRoot scriptRoot, Locals locals) {
        if (this.expected != null && this.expected.isPrimitive()) {
            throw this.createError(new IllegalArgumentException("Elvis operator cannot return primitives"));
        }
        this.lhs.expected = this.expected;
        this.lhs.explicit = this.explicit;
        this.lhs.internal = this.internal;
        this.rhs.expected = this.expected;
        this.rhs.explicit = this.explicit;
        this.rhs.internal = this.internal;
        this.actual = this.expected;
        this.lhs.analyze(scriptRoot, locals);
        this.rhs.analyze(scriptRoot, locals);
        if (this.lhs.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous elvis operator. LHS is null."));
        }
        if (this.lhs.constant != null) {
            throw this.createError(new IllegalArgumentException("Extraneous elvis operator. LHS is a constant."));
        }
        if (this.lhs.actual.isPrimitive()) {
            throw this.createError(new IllegalArgumentException("Extraneous elvis operator. LHS is a primitive."));
        }
        if (this.rhs.isNull) {
            throw this.createError(new IllegalArgumentException("Extraneous elvis operator. RHS is null."));
        }
        if (this.expected == null) {
            Class<?> promote = AnalyzerCaster.promoteConditional(this.lhs.actual, this.rhs.actual, this.lhs.constant, this.rhs.constant);
            this.lhs.expected = promote;
            this.rhs.expected = promote;
            this.actual = promote;
        }
        this.lhs = this.lhs.cast(scriptRoot, locals);
        this.rhs = this.rhs.cast(scriptRoot, locals);
    }

    @Override
    void write(ClassWriter classWriter, MethodWriter methodWriter, Globals globals) {
        methodWriter.writeDebugInfo(this.location);
        Label end = new Label();
        this.lhs.write(classWriter, methodWriter, globals);
        methodWriter.dup();
        methodWriter.ifNonNull(end);
        methodWriter.pop();
        this.rhs.write(classWriter, methodWriter, globals);
        methodWriter.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.lhs, this.rhs);
    }
}

