/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dtbook;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.HandlerUtil;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.util.URISchemes;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;

public class DTBookHandler
implements XMLHandler {
    private final XMLParser parser;
    private final String path;
    private final XRefChecker xrefChecker;
    private boolean checkedUnsupportedXmlVersion = false;

    DTBookHandler(XMLParser parser, String path, XRefChecker xrefChecker) {
        this.parser = parser;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    @Override
    public void characters(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    @Override
    public void startElement() {
        if (!this.checkedUnsupportedXmlVersion) {
            HandlerUtil.checkXMLVersion(this.parser);
            this.checkedUnsupportedXmlVersion = true;
        }
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        String id = e.getAttribute("id");
        if (ns.equals("http://www.daisy.org/z3986/2005/dtbook/")) {
            String href = null;
            if (name.equals("a")) {
                href = e.getAttribute("href");
                String external = e.getAttribute("external");
                if (href != null && external.equals("true")) {
                    URI uri = this.checkURI(href);
                    if (uri != null && URISchemes.contains(uri.getScheme())) {
                        href = null;
                    } else if (uri.getScheme() != null) {
                        this.parser.getReport().message(MessageId.OPF_021, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), href);
                        href = null;
                    }
                }
            } else if (name.equals("link")) {
                href = e.getAttribute("href");
            } else if (name.equals("img")) {
                href = e.getAttribute("src");
            }
            if (href != null) {
                href = PathUtil.resolveRelativeReference(this.path, href);
                this.xrefChecker.registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), href, name.equals("img") ? XRefChecker.Type.IMAGE : XRefChecker.Type.HYPERLINK);
                URI uri = this.checkURI(href);
                if (uri != null && "http".equals(uri.getScheme())) {
                    this.parser.getReport().info(this.path, FeatureEnum.REFERENCE, href);
                }
            }
            if (id != null) {
                this.xrefChecker.registerAnchor(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), id, XRefChecker.Type.HYPERLINK);
            }
        }
    }

    @Override
    public void endElement() {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) {
    }

    private URI checkURI(String uri) {
        try {
            return new URI(((String)Preconditions.checkNotNull((Object)uri)).trim());
        }
        catch (URISyntaxException e) {
            this.parser.getReport().message(MessageId.RSC_020, this.parser.getLocation(), uri);
            return null;
        }
    }
}

