/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import groovy.lang.Closure;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.dsl.ComponentModuleMetadataHandler;
import org.gradle.api.artifacts.dsl.DependencyConstraintHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.artifacts.transform.VariantTransform;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DynamicAddDependencyMethods;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.query.ArtifactResolutionQueryFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.component.external.model.ProjectTestFixtures;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.metaobject.MethodAccess;
import org.gradle.internal.metaobject.MethodMixIn;
import org.gradle.util.ConfigureUtil;

public abstract class DefaultDependencyHandler
implements DependencyHandler,
MethodMixIn {
    private final ConfigurationContainer configurationContainer;
    private final DependencyFactory dependencyFactory;
    private final ProjectFinder projectFinder;
    private final DependencyConstraintHandler dependencyConstraintHandler;
    private final ComponentMetadataHandler componentMetadataHandler;
    private final ComponentModuleMetadataHandler componentModuleMetadataHandler;
    private final ArtifactResolutionQueryFactory resolutionQueryFactory;
    private final AttributesSchema attributesSchema;
    private final VariantTransformRegistry transforms;
    private final Factory<ArtifactTypeContainer> artifactTypeContainer;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private final PlatformSupport platformSupport;
    private final DynamicAddDependencyMethods dynamicMethods;

    public DefaultDependencyHandler(ConfigurationContainer configurationContainer, DependencyFactory dependencyFactory, ProjectFinder projectFinder, DependencyConstraintHandler dependencyConstraintHandler, ComponentMetadataHandler componentMetadataHandler, ComponentModuleMetadataHandler componentModuleMetadataHandler, ArtifactResolutionQueryFactory resolutionQueryFactory, AttributesSchema attributesSchema, VariantTransformRegistry transforms, Factory<ArtifactTypeContainer> artifactTypeContainer, NamedObjectInstantiator namedObjectInstantiator, PlatformSupport platformSupport) {
        this.configurationContainer = configurationContainer;
        this.dependencyFactory = dependencyFactory;
        this.projectFinder = projectFinder;
        this.dependencyConstraintHandler = dependencyConstraintHandler;
        this.componentMetadataHandler = componentMetadataHandler;
        this.componentModuleMetadataHandler = componentModuleMetadataHandler;
        this.resolutionQueryFactory = resolutionQueryFactory;
        this.attributesSchema = attributesSchema;
        this.transforms = transforms;
        this.artifactTypeContainer = artifactTypeContainer;
        this.namedObjectInstantiator = namedObjectInstantiator;
        this.platformSupport = platformSupport;
        this.configureSchema();
        this.dynamicMethods = new DynamicAddDependencyMethods(configurationContainer, new DirectDependencyAdder());
    }

    public Dependency add(String configurationName, Object dependencyNotation) {
        return this.add(configurationName, dependencyNotation, null);
    }

    public Dependency add(String configurationName, Object dependencyNotation, @Nullable Closure configureClosure) {
        return this.doAdd(this.configurationContainer.getByName(configurationName), dependencyNotation, configureClosure);
    }

    public Dependency create(Object dependencyNotation) {
        return this.create(dependencyNotation, null);
    }

    public Dependency create(Object dependencyNotation, @Nullable Closure configureClosure) {
        Dependency dependency = this.dependencyFactory.createDependency(dependencyNotation);
        return (Dependency)ConfigureUtil.configure((Closure)configureClosure, (Object)dependency);
    }

    private Dependency doAdd(Configuration configuration, Object dependencyNotation, @Nullable Closure configureClosure) {
        if (dependencyNotation instanceof Configuration) {
            return this.doAddConfiguration(configuration, (Configuration)dependencyNotation);
        }
        if (dependencyNotation instanceof Provider) {
            return this.doAddProvider(configuration, (Provider)dependencyNotation, configureClosure);
        }
        return this.doAddRegularDependency(configuration, dependencyNotation, configureClosure);
    }

    private Dependency doAddRegularDependency(Configuration configuration, Object dependencyNotation, Closure<?> configureClosure) {
        Dependency dependency = this.create(dependencyNotation, configureClosure);
        configuration.getDependencies().add((Object)dependency);
        return dependency;
    }

    private Dependency doAddProvider(Configuration configuration, Provider<?> dependencyNotation, Closure<?> configureClosure) {
        Provider lazyDependency = dependencyNotation.map(lazyNotation -> this.create(lazyNotation, configureClosure));
        configuration.getDependencies().addLater(lazyDependency);
        return null;
    }

    private Dependency doAddConfiguration(Configuration configuration, Configuration dependencyNotation) {
        Configuration other = dependencyNotation;
        if (!this.configurationContainer.contains((Object)other)) {
            throw new UnsupportedOperationException("Currently you can only declare dependencies on configurations from the same project.");
        }
        configuration.extendsFrom(new Configuration[]{other});
        return null;
    }

    public Dependency module(Object notation) {
        return this.module(notation, null);
    }

    public Dependency project(Map<String, ?> notation) {
        return this.dependencyFactory.createProjectDependencyFromMap(this.projectFinder, notation);
    }

    public Dependency module(Object notation, @Nullable Closure configureClosure) {
        return this.dependencyFactory.createModule(notation, configureClosure);
    }

    public Dependency gradleApi() {
        return this.dependencyFactory.createDependency((Object)DependencyFactory.ClassPathNotation.GRADLE_API);
    }

    public Dependency gradleTestKit() {
        return this.dependencyFactory.createDependency((Object)DependencyFactory.ClassPathNotation.GRADLE_TEST_KIT);
    }

    public Dependency localGroovy() {
        return this.dependencyFactory.createDependency((Object)DependencyFactory.ClassPathNotation.LOCAL_GROOVY);
    }

    public MethodAccess getAdditionalMethods() {
        return this.dynamicMethods;
    }

    public void constraints(Action<? super DependencyConstraintHandler> configureAction) {
        configureAction.execute((Object)this.dependencyConstraintHandler);
    }

    public DependencyConstraintHandler getConstraints() {
        return this.dependencyConstraintHandler;
    }

    public void components(Action<? super ComponentMetadataHandler> configureAction) {
        configureAction.execute((Object)this.getComponents());
    }

    public ComponentMetadataHandler getComponents() {
        return this.componentMetadataHandler;
    }

    public void modules(Action<? super ComponentModuleMetadataHandler> configureAction) {
        configureAction.execute((Object)this.getModules());
    }

    public ComponentModuleMetadataHandler getModules() {
        return this.componentModuleMetadataHandler;
    }

    public ArtifactResolutionQuery createArtifactResolutionQuery() {
        return this.resolutionQueryFactory.createArtifactResolutionQuery();
    }

    public AttributesSchema attributesSchema(Action<? super AttributesSchema> configureAction) {
        configureAction.execute((Object)this.attributesSchema);
        return this.attributesSchema;
    }

    public AttributesSchema getAttributesSchema() {
        return this.attributesSchema;
    }

    private void configureSchema() {
        this.attributesSchema.attribute(ArtifactAttributes.ARTIFACT_FORMAT);
    }

    public ArtifactTypeContainer getArtifactTypes() {
        return (ArtifactTypeContainer)this.artifactTypeContainer.create();
    }

    public void artifactTypes(Action<? super ArtifactTypeContainer> configureAction) {
        configureAction.execute((Object)this.getArtifactTypes());
    }

    public void registerTransform(Action<? super VariantTransform> registrationAction) {
        this.transforms.registerTransform(registrationAction);
    }

    public <T extends TransformParameters> void registerTransform(Class<? extends TransformAction<T>> actionType, Action<? super TransformSpec<T>> registrationAction) {
        this.transforms.registerTransform(actionType, registrationAction);
    }

    public Dependency platform(Object notation) {
        Dependency dependency = this.create(notation);
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            moduleDependency.endorseStrictVersions();
            this.platformSupport.addPlatformAttribute(moduleDependency, this.toCategory("platform"));
        } else if (dependency instanceof HasConfigurableAttributes) {
            this.platformSupport.addPlatformAttribute((HasConfigurableAttributes)dependency, this.toCategory("platform"));
        }
        return dependency;
    }

    public Dependency platform(Object notation, Action<? super Dependency> configureAction) {
        Dependency dep = this.platform(notation);
        configureAction.execute((Object)dep);
        return dep;
    }

    public Dependency enforcedPlatform(Object notation) {
        Dependency platformDependency = this.create(notation);
        if (platformDependency instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)platformDependency;
            DeprecationLogger.whileDisabled(() -> externalModuleDependency.setForce(true));
            this.platformSupport.addPlatformAttribute(externalModuleDependency, this.toCategory("enforced-platform"));
        } else if (platformDependency instanceof HasConfigurableAttributes) {
            this.platformSupport.addPlatformAttribute((HasConfigurableAttributes)platformDependency, this.toCategory("enforced-platform"));
        }
        return platformDependency;
    }

    public Dependency enforcedPlatform(Object notation, Action<? super Dependency> configureAction) {
        Dependency dep = this.enforcedPlatform(notation);
        configureAction.execute((Object)dep);
        return dep;
    }

    public Dependency testFixtures(Object notation) {
        Dependency testFixturesDependency = this.create(notation);
        if (testFixturesDependency instanceof ProjectDependency) {
            ProjectDependency projectDependency = (ProjectDependency)testFixturesDependency;
            projectDependency.capabilities((Action)new ProjectTestFixtures(projectDependency.getDependencyProject()));
        } else if (testFixturesDependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)testFixturesDependency;
            moduleDependency.capabilities(capabilities -> capabilities.requireCapability((Object)new ImmutableCapability(moduleDependency.getGroup(), moduleDependency.getName() + "-test-fixtures", null)));
        }
        return testFixturesDependency;
    }

    public Dependency testFixtures(Object notation, Action<? super Dependency> configureAction) {
        Dependency testFixturesDependency = this.testFixtures(notation);
        configureAction.execute((Object)testFixturesDependency);
        return testFixturesDependency;
    }

    private Category toCategory(String category) {
        return (Category)this.namedObjectInstantiator.named(Category.class, category);
    }

    private class DirectDependencyAdder
    implements DynamicAddDependencyMethods.DependencyAdder<Dependency> {
        private DirectDependencyAdder() {
        }

        @Override
        public Dependency add(Configuration configuration, Object dependencyNotation, @Nullable Closure configureAction) {
            return DefaultDependencyHandler.this.doAdd(configuration, dependencyNotation, configureAction);
        }
    }
}

