/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.RealizeTaskBuildOperationType;
import org.gradle.api.internal.tasks.RegisterTaskBuildOperationType;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalPluginIdentifier;
import org.gradle.tooling.internal.provider.runner.PluginApplicationTracker;

class TaskOriginTracker
implements BuildOperationListener {
    private final Map<Long, InternalPluginIdentifier> origins = new ConcurrentHashMap<Long, InternalPluginIdentifier>();
    private final PluginApplicationTracker pluginApplicationTracker;

    TaskOriginTracker(PluginApplicationTracker pluginApplicationTracker) {
        this.pluginApplicationTracker = pluginApplicationTracker;
    }

    @Nullable
    InternalPluginIdentifier getOriginPlugin(TaskIdentity<?> taskIdentity) {
        return this.origins.get(taskIdentity.uniqueId);
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (buildOperation.getDetails() instanceof RealizeTaskBuildOperationType.Details) {
            RealizeTaskBuildOperationType.Details details = (RealizeTaskBuildOperationType.Details)buildOperation.getDetails();
            this.storeOrigin(buildOperation, details.getTaskId());
        } else if (buildOperation.getDetails() instanceof RegisterTaskBuildOperationType.Details) {
            RegisterTaskBuildOperationType.Details details = (RegisterTaskBuildOperationType.Details)buildOperation.getDetails();
            this.storeOrigin(buildOperation, details.getTaskId());
        }
    }

    private void storeOrigin(BuildOperationDescriptor buildOperation, long taskId) {
        this.origins.computeIfAbsent(taskId, key -> {
            PluginApplicationTracker.PluginApplication pluginApplication = this.pluginApplicationTracker.findRunningPluginApplication(buildOperation.getParentId());
            return pluginApplication == null ? null : pluginApplication.getPlugin();
        });
    }

    public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
    }
}

