/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorTable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.lazy.IrLazyDeclarationBase;
import org.jetbrains.kotlin.ir.util.UniqId;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\fJ\u0015\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\fH\u0014\u00f8\u0001\u0000J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0015\u001a\u00020\u0012*\u00020\fH\u0002J\u0015\u0010\u0016\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0012H\u0082\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "", "descriptorTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorTable;", "globalDeclarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;", "startIndex", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorTable;Lorg/jetbrains/kotlin/backend/common/serialization/GlobalDeclarationTable;J)V", "localIndex", "table", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/util/UniqId;", "computeUniqIdByDeclaration", "declaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)J", "isExportedDeclaration", "", "tryComputeBackendSpecificUniqId", "uniqIdByDeclaration", "isLocalDeclaration", "isMetadataDeclaration", "isTypeParameter", "ir.serialization.common"})
public class DeclarationTable {
    private final Map<IrDeclaration, UniqId> table;
    private long localIndex;
    private final DescriptorTable descriptorTable;
    private final GlobalDeclarationTable globalDeclarationTable;

    private final boolean isLocalDeclaration(@NotNull IrDeclaration $this$isLocalDeclaration) {
        return Intrinsics.areEqual((Object)$this$isLocalDeclaration.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) || !this.isExportedDeclaration($this$isLocalDeclaration) || $this$isLocalDeclaration instanceof IrValueDeclaration || $this$isLocalDeclaration instanceof IrAnonymousInitializer || $this$isLocalDeclaration instanceof IrLocalDelegatedProperty;
    }

    public final boolean isExportedDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.globalDeclarationTable.isExportedDeclaration(declaration2);
    }

    @Nullable
    protected UniqId tryComputeBackendSpecificUniqId(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return null;
    }

    private final long computeUniqIdByDeclaration(IrDeclaration declaration2) {
        long l;
        UniqId uniqId = this.tryComputeBackendSpecificUniqId(declaration2);
        if (uniqId != null) {
            UniqId uniqId2 = uniqId;
            boolean bl = false;
            boolean bl2 = false;
            long it = uniqId2.unbox-impl();
            boolean bl3 = false;
            return it;
        }
        if (this.isLocalDeclaration(declaration2)) {
            UniqId uniqId3;
            Map<IrDeclaration, UniqId> $this$getOrPut$iv = this.table;
            boolean $i$f$getOrPut = false;
            UniqId value$iv = $this$getOrPut$iv.get(declaration2);
            if (value$iv == null) {
                boolean bl = false;
                long l2 = this.localIndex;
                this.localIndex = l2 + 1L;
                UniqId answer$iv = UniqId.box-impl(UniqId.constructor-impl(l2));
                $this$getOrPut$iv.put(declaration2, answer$iv);
                uniqId3 = answer$iv;
            } else {
                uniqId3 = value$iv;
            }
            l = uniqId3.unbox-impl();
        } else {
            l = this.globalDeclarationTable.computeUniqIdByDeclaration(declaration2);
        }
        return l;
    }

    public final long uniqIdByDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        long uniqId = this.computeUniqIdByDeclaration(declaration2);
        if (this.isMetadataDeclaration(declaration2, false)) {
            this.descriptorTable.put-Q-Dmd8I(declaration2.getDescriptor(), uniqId);
        }
        return uniqId;
    }

    private final boolean isMetadataDeclaration(@NotNull IrDeclaration $this$isMetadataDeclaration, boolean isTypeParameter) {
        while (!($this$isMetadataDeclaration instanceof IrValueDeclaration) && !($this$isMetadataDeclaration instanceof IrField)) {
            if (Intrinsics.areEqual((Object)$this$isMetadataDeclaration.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) || Intrinsics.areEqual((Object)$this$isMetadataDeclaration.getOrigin(), (Object)IrDeclarationOrigin.ENUM_CLASS_SPECIAL_MEMBER.INSTANCE)) {
                return false;
            }
            if (!isTypeParameter && $this$isMetadataDeclaration instanceof IrSimpleFunction && ((IrSimpleFunction)$this$isMetadataDeclaration).getCorrespondingPropertySymbol() != null) {
                return false;
            }
            if ($this$isMetadataDeclaration instanceof IrDeclarationWithVisibility && Intrinsics.areEqual((Object)((IrDeclarationWithVisibility)$this$isMetadataDeclaration).getVisibility(), (Object)Visibilities.LOCAL)) {
                return false;
            }
            if ($this$isMetadataDeclaration instanceof IrLazyDeclarationBase) {
                return false;
            }
            if ($this$isMetadataDeclaration.getParent() instanceof IrPackageFragment) {
                return true;
            }
            IrDeclarationParent irDeclarationParent = $this$isMetadataDeclaration.getParent();
            if (irDeclarationParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            }
            isTypeParameter = $this$isMetadataDeclaration instanceof IrTypeParameter || isTypeParameter;
            $this$isMetadataDeclaration = (IrDeclaration)((Object)irDeclarationParent);
        }
        return false;
    }

    public DeclarationTable(@NotNull DescriptorTable descriptorTable, @NotNull GlobalDeclarationTable globalDeclarationTable, long startIndex) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)descriptorTable, (String)"descriptorTable");
        Intrinsics.checkParameterIsNotNull((Object)globalDeclarationTable, (String)"globalDeclarationTable");
        this.descriptorTable = descriptorTable;
        this.globalDeclarationTable = globalDeclarationTable;
        DeclarationTable declarationTable = this;
        boolean bl = false;
        declarationTable.table = map2 = (Map)new LinkedHashMap();
        this.localIndex = startIndex;
    }
}

