/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.buildinit.plugins.internal.ConditionalTemplateOperation;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.internal.Factory;

public class TemplateFactory {
    private final FileCollectionFactory fileCollectionFactory;
    private final TemplateOperationFactory templateOperationFactory;
    private final InitSettings initSettings;
    private final Language language;

    public TemplateFactory(InitSettings initSettings, Language language, FileCollectionFactory fileCollectionFactory, TemplateOperationFactory templateOperationFactory) {
        this.initSettings = initSettings;
        this.language = language;
        this.fileCollectionFactory = fileCollectionFactory;
        this.templateOperationFactory = templateOperationFactory;
    }

    public TemplateOperation whenNoSourcesAvailable(TemplateOperation ... operations) {
        return new ConditionalTemplateOperation((Factory<Boolean>)((Factory)() -> {
            FileTreeInternal mainFiles = this.fileCollectionFactory.resolving("main files", (Object)("src/main/" + this.language.getName())).getAsFileTree();
            FileTreeInternal testFiles = this.fileCollectionFactory.resolving("test files", (Object)("src/test/" + this.language.getName())).getAsFileTree();
            return mainFiles.isEmpty() || testFiles.isEmpty();
        }), operations);
    }

    public TemplateOperation fromSourceTemplate(String clazzTemplate, String sourceSetName) {
        return this.fromSourceTemplate(clazzTemplate, sourceSetName, this.language);
    }

    public TemplateOperation fromSourceTemplate(String clazzTemplate, String sourceSetName, Language language) {
        return this.fromSourceTemplate(clazzTemplate, (Action<? super SourceFileTemplate>)((Action)t -> {
            t.sourceSet(sourceSetName);
            t.language(language);
        }));
    }

    public TemplateOperation fromSourceTemplate(String sourceTemplate, Action<? super SourceFileTemplate> config) {
        String className;
        String targetFileName = sourceTemplate.substring(sourceTemplate.lastIndexOf("/") + 1).replace(".template", "");
        TemplateDetails details = new TemplateDetails(this.language, targetFileName);
        config.execute((Object)details);
        String packageDecl = "";
        String string = className = details.className == null ? "" : details.className;
        if (this.initSettings != null && !this.initSettings.getPackageName().isEmpty()) {
            packageDecl = "package " + this.initSettings.getPackageName();
            targetFileName = this.initSettings.getPackageName().replace(".", "/") + "/" + details.getTargetFileName();
        } else {
            targetFileName = details.getTargetFileName();
        }
        TemplateOperationFactory.TemplateOperationBuilder operationBuilder = this.templateOperationFactory.newTemplateOperation().withTemplate(sourceTemplate).withTarget("src/" + details.sourceSet + "/" + details.language.getName() + "/" + targetFileName).withBinding("packageDecl", packageDecl).withBinding("className", className);
        for (Map.Entry<String, String> entry : details.bindings.entrySet()) {
            operationBuilder.withBinding(entry.getKey(), entry.getValue());
        }
        return operationBuilder.create();
    }

    protected static interface SourceFileTemplate {
        public void sourceSet(String var1);

        public void language(Language var1);

        public void className(String var1);

        public void binding(String var1, String var2);
    }

    private static class TemplateDetails
    implements SourceFileTemplate {
        final Map<String, String> bindings = new HashMap<String, String>();
        String sourceSet = "main";
        Language language;
        String fileName;
        @Nullable
        String className;

        TemplateDetails(Language language, String fileName) {
            this.language = language;
            this.fileName = fileName;
        }

        @Override
        public void sourceSet(String name) {
            this.sourceSet = name;
        }

        @Override
        public void language(Language language) {
            this.language = language;
        }

        @Override
        public void className(String name) {
            this.className = name;
        }

        @Override
        public void binding(String name, String value) {
            this.bindings.put(name, value);
        }

        public String getTargetFileName() {
            if (this.className != null) {
                return this.className + "." + this.language.getExtension();
            }
            return this.fileName;
        }
    }
}

