Media.EventDisplayColumnConfig;Media.Event;Media.MediaEventColumnKeys={Timestamp:'displayTimestamp',Event:'event',Value:'value'};Media.EventNode=class extends DataGrid.SortableDataGridNode{constructor(event){super(event,false);}
createCell(columnId){const cell=this.createTD(columnId);const cellData=(this.data[columnId]);if(columnId===Media.MediaEventColumnKeys.Value){const area=new SourceFrame.JSONView(new SourceFrame.ParsedJSON(cellData,'',''),true);area.markAsRoot();area.show(cell);}else{cell.classList.add('event-display-table-basic-text-table-entry');cell.createTextChild(cellData);}
return cell;}
nodeSelfHeight(){return 20;}};Media.PlayerEventsView=class extends UI.VBox{constructor(){super();this.registerRequiredCSS('media/eventDisplayTable.css');this.contentElement.classList.add('event-display-table-contents-table-container');this._dataGrid=this._createDataGrid([{id:Media.MediaEventColumnKeys.Timestamp,title:ls`Timestamp`,weight:1,sortable:true,sortingFunction:DataGrid.SortableDataGrid.NumericComparator.bind(null,Media.MediaEventColumnKeys.Timestamp)},{id:Media.MediaEventColumnKeys.Event,title:ls`Event Name`,weight:2,sortable:false},{id:Media.MediaEventColumnKeys.Value,title:ls`Value`,weight:7,sortable:false}],Media.MediaEventColumnKeys.Timestamp);this._firstEventTime=0;this._dataGrid.setStriped(true);this._dataGrid.asWidget().show(this.contentElement);}
_createDataGrid(headers,default_sort){const gridColumnDescs=[];const sortFunctionMap=new Map();for(const headerDesc of headers){gridColumnDescs.push(Media.PlayerEventsView._convertToGridDescriptor(headerDesc));if(headerDesc.sortable){sortFunctionMap.set(headerDesc.id,headerDesc.sortingFunction);if(!default_sort){default_sort=headerDesc.id;}}}
const datagrid=new DataGrid.SortableDataGrid({displayName:ls`Event Display`,columns:gridColumnDescs});if(default_sort){datagrid.sortNodes(sortFunctionMap.get(default_sort),!datagrid.isSortOrderAscending());function sortGrid(){const comparator=sortFunctionMap.get(datagrid.sortColumnId());datagrid.sortNodes(comparator,!datagrid.isSortOrderAscending());}
datagrid.addEventListener(DataGrid.DataGrid.Events.SortingChanged,sortGrid);}
datagrid.asWidget().contentElement.classList.add('no-border-top-datagrid');return datagrid;}
renderChanges(playerID,changes,change_type){if(this._firstEventTime===0&&changes.length>0){this._firstEventTime=changes[0].timestamp;}
for(const event of changes){this.addEvent(this._subtractFirstEventTime(event));}}
addEvent(event){if(event.type==='triggeredEvent'){const stringified=(event.value);const json=JSON.parse(stringified);event.event=json.event;delete json['event'];event.value=json;const node=new Media.EventNode(event);this._dataGrid.rootNode().insertChildOrdered(node);}
if(event.type==='systemEvent'){event.event=event.name;const node=new Media.EventNode(event);this._dataGrid.rootNode().insertChildOrdered(node);}}
_subtractFirstEventTime(event){event.displayTimestamp=(event.timestamp-this._firstEventTime).toFixed(3);return event;}
static _convertToGridDescriptor(columnConfig){return({id:columnConfig.id,title:columnConfig.title,sortable:columnConfig.sortable,weight:columnConfig.weight||0,sort:DataGrid.DataGrid.Order.Ascending});}};;Media.MainView=class extends UI.PanelWithSidebar{constructor(){super('Media');this.registerRequiredCSS('media/mediaView.css');this._detailPanels=new Map();this._deletedPlayers=new Set();this._sidebar=new Media.PlayerListView(this);this._sidebar.show(this.panelSidebarElement());self.SDK.targetManager.observeModels(Media.MediaModel,this);}
renderChanges(playerID,changes,changeType){if(this._deletedPlayers.has(playerID)){return;}
if(!this._detailPanels.has(playerID)){return;}
this._sidebar.renderChanges(playerID,changes,changeType);this._detailPanels.get(playerID).renderChanges(playerID,changes,changeType);}
renderMainPanel(playerID){if(!this._detailPanels.has(playerID)){return;}
this.splitWidget().mainWidget().detachChildWidgets();this._detailPanels.get(playerID).show(this.mainElement());}
_onPlayerCreated(playerID){this._sidebar.addMediaElementItem(playerID);this._detailPanels.set(playerID,new Media.PlayerDetailView());}
wasShown(){super.wasShown();for(const model of self.SDK.targetManager.models(Media.MediaModel)){this._addEventListeners(model);}}
willHide(){for(const model of self.SDK.targetManager.models(Media.MediaModel)){this._removeEventListeners(model);}}
modelAdded(mediaModel){if(this.isShowing()){this._addEventListeners(mediaModel);}}
modelRemoved(mediaModel){this._removeEventListeners(mediaModel);}
_addEventListeners(mediaModel){mediaModel.ensureEnabled();mediaModel.addEventListener(Media.MediaModel.Events.PlayerPropertiesChanged,this._propertiesChanged,this);mediaModel.addEventListener(Media.MediaModel.Events.PlayerEventsAdded,this._eventsAdded,this);mediaModel.addEventListener(Media.MediaModel.Events.PlayersCreated,this._playersCreated,this);}
_removeEventListeners(mediaModel){mediaModel.removeEventListener(Media.MediaModel.Events.PlayerPropertiesChanged,this._propertiesChanged,this);mediaModel.removeEventListener(Media.MediaModel.Events.PlayerEventsAdded,this._eventsAdded,this);mediaModel.removeEventListener(Media.MediaModel.Events.PlayersCreated,this._playersCreated,this);}
_propertiesChanged(event){this.renderChanges(event.data.playerId,event.data.properties,Media.MediaModel.MediaChangeTypeKeys.Property);}
_eventsAdded(event){this.renderChanges(event.data.playerId,event.data.events,Media.MediaModel.MediaChangeTypeKeys.Event);}
_playersCreated(event){const playerlist=(event.data);for(const playerID of playerlist){this._onPlayerCreated(playerID);}}};;Media.PlayerDetailView=class extends UI.TabbedPane{constructor(){super();const eventView=new Media.PlayerEventsView();const propertyView=new Media.PlayerPropertiesView();this._panels=new Map([[Media.MediaModel.MediaChangeTypeKeys.Property,[propertyView]],[Media.MediaModel.MediaChangeTypeKeys.Event,[eventView]]]);this.appendTab(Media.PlayerDetailView.Tabs.Properties,Common.UIString('Properties'),propertyView,Common.UIString('Player properties'));this.appendTab(Media.PlayerDetailView.Tabs.Events,Common.UIString('Events'),eventView,Common.UIString('Player events'));}
renderChanges(playerID,changes,changeType){for(const panel of this._panels.get(changeType)){panel.renderChanges(playerID,changes,changeType);}}};Media.PlayerDetailView.Tabs={Events:'events',Properties:'properties',};;Media.PlayerStatus;Media.PlayerStatusMapElement;Media.PlayerEntryTreeElement=class extends UI.TreeElement{constructor(playerStatus,displayContainer){super(playerStatus.playerTitle,false);this.titleFromUrl=true;this._playerStatus=playerStatus;this._displayContainer=displayContainer;this.setLeadingIcons([UI.Icon.create('smallicon-videoplayer-playing','media-player')]);}
onselect(selectedByUser){this._displayContainer.renderMainPanel(this._playerStatus.playerID);return true;}};Media.PlayerListView=class extends UI.VBox{constructor(mainContainer){super(true);this._playerStatuses=new Map();this._mainContainer=mainContainer;this._sidebarTree=new UI.TreeOutlineInShadow();this.contentElement.appendChild(this._sidebarTree.element);this._sidebarTree.registerRequiredCSS('media/playerListView.css');this._audioDevices=this._addListSection(Common.UIString('Audio I/O'));this._videoDevices=this._addListSection(Common.UIString('Video Capture Devices'));this._playerList=this._addListSection(Common.UIString('Players'));}
_addListSection(title){const treeElement=new UI.TreeElement(title,true);treeElement.listItemElement.classList.add('storage-group-list-item');treeElement.setCollapsible(false);treeElement.selectable=false;this._sidebarTree.appendChild(treeElement);return treeElement;}
addMediaElementItem(playerID){const playerStatus={playerTitle:playerID,playerID:playerID,exists:true,playing:false,titleEdited:false};const playerElement=new Media.PlayerEntryTreeElement(playerStatus,this._mainContainer);this._playerStatuses.set(playerID,playerElement);this._playerList.appendChild(playerElement);}
setMediaElementPlayerTitle(playerID,newTitle,isTitleExtractedFromUrl){if(this._playerStatuses.has(playerID)){const sidebarEntry=this._playerStatuses.get(playerID);if(!isTitleExtractedFromUrl||sidebarEntry.titleFromUrl){sidebarEntry.title=newTitle;sidebarEntry.titleFromUrl=isTitleExtractedFromUrl;}}}
setMediaElementPlayerIcon(playerID,iconName){if(this._playerStatuses.has(playerID)){const sidebarEntry=this._playerStatuses.get(playerID);sidebarEntry.setLeadingIcons([UI.Icon.create('smallicon-videoplayer-'+iconName,'media-player')]);}}
renderChanges(playerID,changes,changeType){if(changeType===Media.MediaModel.MediaChangeTypeKeys.Property){for(const change of changes){if(change.name==='frame_title'&&change.value){this.setMediaElementPlayerTitle(playerID,(change.value),false);}
if(change.name==='frame_url'){const url_path_component=change.value.substring(change.value.lastIndexOf('/')+1);this.setMediaElementPlayerTitle(playerID,url_path_component,true);}}}
if(changeType===Media.MediaModel.MediaChangeTypeKeys.Event){let change_to=null;for(const change of changes){if(change.name==='Event'){if(change.value==='PLAY'){change_to='playing';}else if(change.value==='PAUSE'){change_to='paused';}else if(change.value==='WEBMEDIAPLAYER_DESTROYED'){change_to='destroyed';}}}
if(change_to){this.setMediaElementPlayerIcon(playerID,change_to);}}}};;Media.PropertyRenderer=class extends UI.VBox{constructor(title){super();this.contentElement.classList.add('media-property-renderer');this._title=this.contentElement.createChild('span','media-property-renderer-title');this._contents=this.contentElement.createChild('span','media-property-renderer-contents');this._title.createTextChild(title);this._title=title;this._value=null;this._pseudo_color_protection_element=null;this.contentElement.classList.add('media-property-renderer-hidden');}
updateData(propname,propvalue){if(propvalue===''||propvalue===null){return this._updateData(propname,null);}
try{propvalue=JSON.parse(propvalue);}catch(err){}
return this._updateData(propname,propvalue);}
_updateData(propname,propvalue){if(propvalue===null){this.changeContents(null);}else if(this._value===propvalue){return;}else{this._value=propvalue;this.changeContents(propvalue);}}
changeContents(value){if(value===null){this.contentElement.classList.add('media-property-renderer-hidden');if(this._pseudo_color_protection_element===null){this._pseudo_color_protection_element=createElementWithClass('div','media-property-renderer');this._pseudo_color_protection_element.classList.add('media-property-renderer-hidden');this.contentElement.parentNode.insertBefore(this._pseudo_color_protection_element,this.contentElement);}}else{if(this._pseudo_color_protection_element!==null){this._pseudo_color_protection_element.remove();this._pseudo_color_protection_element=null;}
this.contentElement.classList.remove('media-property-renderer-hidden');this._contents.removeChildren();const spanElement=createElement('span');spanElement.textContent=value;this._contents.appendChild(spanElement);}}};Media.FormattedPropertyRenderer=class extends Media.PropertyRenderer{constructor(title,formatfunction){super(Common.UIString(title));this._formatfunction=formatfunction;}
_updateData(propname,propvalue){if(propvalue===null){this.changeContents(null);}else{this.changeContents(this._formatfunction(propvalue));}}};Media.DefaultPropertyRenderer=class extends Media.PropertyRenderer{constructor(title,default_text){super(Common.UIString(title));this.changeContents(default_text);}};Media.DimensionPropertyRenderer=class extends Media.PropertyRenderer{constructor(title){super(Common.UIString(title));this._width=0;this._height=0;}
_updateData(propname,propvalue){let needsUpdate=false;if(propname==='width'&&propvalue!==this._width){this._width=propvalue;needsUpdate=true;}
if(propname==='height'&&propvalue!==this._height){this._height=propvalue;needsUpdate=true;}
if(this._width===0||this._height===0){this.changeContents(null);}else if(needsUpdate){this.changeContents(`${this._width}\xD7${this._height}`);}}};Media.AttributesView=class extends UI.VBox{constructor(elements){super();this.contentElement.classList.add('media-attributes-view');for(const element of elements){element.show(this.contentElement);}}};Media.TrackManager=class{constructor(propertiesView,type){this._type=type;this._view=propertiesView;this._previousTabs=[];}
updateData(name,value){const tabs=this._view.GetTabs(this._type);tabs.RemoveTabs(this._previousTabs);const newTabs=(JSON.parse(value));let enumerate=1;for(const tabData of newTabs){this.addNewTab(tabs,tabData,enumerate);enumerate++;}}
addNewTab(tabs,data,index){}};Media.VideoTrackManager=class extends Media.TrackManager{constructor(propertiesView){super(propertiesView,'video');}
addNewTab(tabs,tabData,tabNumber){const tabElements=[];for(const[name,data]of Object.entries(tabData)){tabElements.push(new Media.DefaultPropertyRenderer(name,data));}
const newTab=new Media.AttributesView(tabElements);tabs.CreateAndAddDropdownButton('tab_'+tabNumber,{title:UI.html`Track #${tabNumber}`,element:newTab});}};Media.AudioTrackManager=class extends Media.TrackManager{constructor(propertiesView){super(propertiesView,'audio');}
addNewTab(tabs,tabData,tabNumber){const tabElements=[];for(const[name,data]of Object.entries(tabData)){tabElements.push(new Media.DefaultPropertyRenderer(name,data));}
const newtab=new Media.AttributesView(tabElements);tabs.CreateAndAddDropdownButton('tab_'+tabNumber,{title:UI.html`Track #${tabNumber}`,element:newtab});}};Media.PlayerPropertiesView=class extends UI.VBox{constructor(){super();this.contentElement.classList.add('media-properties-frame');this.registerRequiredCSS('media/playerPropertiesView.css');this.populateAttributesAndElements();this._videoProperties=new Media.AttributesView(this._mediaElements);this._videoDecoderProperties=new Media.AttributesView(this._videoDecoderElements);this._audioDecoderProperties=new Media.AttributesView(this._audioDecoderElements);const video=new Media.ChevronTabbedPanel({tab:{title:UI.html`Media`,element:this._videoProperties}});video.contentElement.classList.add('media-properties-view');video.show(this.contentElement);this._videoDecoderTab=new Media.ChevronTabbedPanel({tab:{title:UI.html`Video Decoder`,element:this._videoDecoderProperties}});this._videoDecoderTab.contentElement.classList.add('media-properties-view');this._videoDecoderTab.show(this.contentElement);this._audioDecoderTab=new Media.ChevronTabbedPanel({tab:{title:UI.html`Audio Decoder`,element:this._audioDecoderProperties}});this._audioDecoderTab.contentElement.classList.add('media-properties-view');this._audioDecoderTab.show(this.contentElement);}
GetTabs(type){if(type==='audio'){return this._audioDecoderTab;}
if(type==='video'){return this._videoDecoderTab;}
throw new Error('Unreachable');}
renderChanges(playerID,changes,changeType){for(const change of changes){const renderer=this._attributeMap.get(change.name);if(renderer){renderer.updateData(change.name,change.value);}else{throw new Error(`PlayerProperty ${change.name} not supported.`);}}}
formatKbps(bitsPerSecond){if(bitsPerSecond===''){return'0 kbps';}
const kbps=Math.floor(bitsPerSecond/1000);return`${kbps} kbps`;}
formatTime(seconds){if(seconds===''){return'0:00';}
const date=new Date(null);date.setSeconds(seconds);return date.toISOString().substr(11,8);}
formatFileSize(bytes){if(bytes===''){return'0 bytes';}
const power=Math.floor(Math.log(bytes)/Math.log(1024));const suffix=['bytes','kB','MB','GB','TB'][power];const bytesDecimal=(bytes/Math.pow(1000,power)).toFixed(2);return`${bytesDecimal} ${suffix}`;}
populateAttributesAndElements(){this._mediaElements=[];this._videoDecoderElements=[];this._audioDecoderElements=[];this._attributeMap=new Map();const resolution=new Media.PropertyRenderer(ls`Resolution`);this._mediaElements.push(resolution);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kResolution,resolution);const fileSize=new Media.FormattedPropertyRenderer(ls`File Size`,this.formatFileSize);this._mediaElements.push(fileSize);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kTotalBytes,fileSize);const bitrate=new Media.FormattedPropertyRenderer(ls`Bitrate`,this.formatKbps);this._mediaElements.push(bitrate);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kBitrate,bitrate);const duration=new Media.FormattedPropertyRenderer(ls`Duration`,this.formatTime);this._mediaElements.push(duration);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kMaxDuration,duration);const startTime=new Media.PropertyRenderer(ls`Start Time`);this._mediaElements.push(startTime);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kStartTime,startTime);const streaming=new Media.PropertyRenderer(ls`Streaming`);this._mediaElements.push(streaming);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kIsStreaming,streaming);const frameUrl=new Media.PropertyRenderer(ls`Playback Frame URL`);this._mediaElements.push(frameUrl);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kFrameUrl,frameUrl);const frameTitle=new Media.PropertyRenderer(ls`Playback Frame Title`);this._mediaElements.push(frameTitle);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kFrameTitle,frameTitle);const singleOrigin=new Media.PropertyRenderer(ls`Is Single Origin Playback`);this._mediaElements.push(singleOrigin);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kIsSingleOrigin,singleOrigin);const rangeHeaders=new Media.PropertyRenderer(ls`Range Header Support`);this._mediaElements.push(rangeHeaders);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kIsRangeHeaderSupported,rangeHeaders);const decoderName=new Media.DefaultPropertyRenderer(ls`Decoder Name`,ls`No Decoder`);this._videoDecoderElements.push(decoderName);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kVideoDecoderName,decoderName);const videoPlatformDecoder=new Media.PropertyRenderer(ls`Hardware Decoder`);this._videoDecoderElements.push(videoPlatformDecoder);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kIsPlatformVideoDecoder,videoPlatformDecoder);const videoDDS=new Media.PropertyRenderer(ls`Decrypting Demuxer`);this._videoDecoderElements.push(videoDDS);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kIsVideoDecryptingDemuxerStream,videoDDS);const videoTrackManager=new Media.VideoTrackManager(this);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kVideoTracks,videoTrackManager);const audioDecoder=new Media.DefaultPropertyRenderer(ls`Decoder Name`,ls`No Decoder`);this._audioDecoderElements.push(audioDecoder);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kAudioDecoderName,audioDecoder);const audioPlatformDecoder=new Media.PropertyRenderer(ls`Hardware Decoder`);this._audioDecoderElements.push(audioPlatformDecoder);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kIsPlatformAudioDecoder,audioPlatformDecoder);const audioDDS=new Media.PropertyRenderer(ls`Decrypting Demuxer`);this._audioDecoderElements.push(audioDDS);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kIsAudioDecryptingDemuxerStream,audioDDS);const audioTrackManager=new Media.AudioTrackManager(this);this._attributeMap.set(Media.PlayerPropertiesView.PlayerProperties.kAudioTracks,audioTrackManager);}};Media.PlayerPropertiesView.PlayerProperties={kResolution:'kResolution',kTotalBytes:'kTotalBytes',kBitrate:'kBitrate',kMaxDuration:'kMaxDuration',kStartTime:'kStartTime',kIsVideoEncrypted:'kIsVideoEncrypted',kIsStreaming:'kIsStreaming',kFrameUrl:'kFrameUrl',kFrameTitle:'kFrameTitle',kIsSingleOrigin:'kIsSingleOrigin',kIsRangeHeaderSupported:'kIsRangeHeaderSupported',kVideoDecoderName:'kVideoDecoderName',kAudioDecoderName:'kAudioDecoderName',kIsPlatformVideoDecoder:'kIsPlatformVideoDecoder',kIsPlatformAudioDecoder:'kIsPlatformAudioDecoder',kIsVideoDecryptingDemuxerStream:'kIsVideoDecryptingDemuxerStream',kIsAudioDecryptingDemuxerStream:'kIsAudioDecryptingDemuxerStream',kAudioTracks:'kAudioTracks',kVideoTracks:'kVideoTracks',};;Media.MediaModel=class extends SDK.SDKModel{constructor(target){super(target);this._enabled=false;this._agent=target.mediaAgent();target.registerMediaDispatcher(this);}
resumeModel(){if(!this._enabled){return Promise.resolve();}
return this._agent.enable();}
ensureEnabled(){this._agent.enable();this._enabled=true;}
playerPropertiesChanged(playerId,properties){this.dispatchEventToListeners(Media.MediaModel.Events.PlayerPropertiesChanged,{playerId:playerId,properties:properties});}
playerEventsAdded(playerId,events){this.dispatchEventToListeners(Media.MediaModel.Events.PlayerEventsAdded,{playerId:playerId,events:events});}
playersCreated(playerIds){this.dispatchEventToListeners(Media.MediaModel.Events.PlayersCreated,playerIds);}};SDK.SDKModel.register(Media.MediaModel,SDK.Target.Capability.DOM,false);Media.MediaModel.Events={PlayerPropertiesChanged:Symbol('PlayerPropertiesChanged'),PlayerEventsAdded:Symbol('PlayerEventsAdded'),PlayersCreated:Symbol('PlayersCreated')};Media.MediaModel.MediaChangeTypeKeys={Event:'Events',Property:'Properties'};;Media.ChevronTab;Media.ChevronTabbedPanel=class extends UI.VBox{constructor(tab_definitions){super();this.registerRequiredCSS('media/chevronTabbedPanel.css');this._chevronButtons=new Map();this._header_panel=this.contentElement.createChild('div','chevron-tabbed-panel-title');this._content_panel=this.contentElement.createChild('div','chevron-tabbed-panel-content');this._header_panel_button_container=this._header_panel.createChild('div','chevron-tabbed-panel-title-buttons');for(const accessor_id in tab_definitions){this.CreateAndAddDropdownButton(accessor_id,tab_definitions[accessor_id]);}}
CreateAndAddDropdownButton(identifier,tab){const button=this._header_panel_button_container.createChild('div','chevron-tabbed-panel-buttons-item');button.appendChild(tab.title);this._chevronButtons.set(identifier,{content:tab.element,button:button});if(this._chevronButtons.size===1){this._DisplayContentSection(tab.element);button.classList.add('selected');}
button.addEventListener('click',event=>{if(event.currentTarget.classList.contains('selected')){return;}
for(const elements of this._chevronButtons.values()){elements.button.classList.remove('selected');}
event.currentTarget.classList.add('selected');this._DisplayContentSection(tab.element);},false);}
RemoveTab(identifier,remove_all=false){const button=this._chevronButtons.get(identifier);this._chevronButtons.delete(identifier);if(!remove_all&&button.classList.contains('selected')){if(this._chevronButtons.size!==0){const new_selected=this._chevronButtons.values().next().value;new_selected.classList.add('selected');}}
this._header_panel_button_container.removeChild(button.button);}
RemoveTabs(identifiers){for(const identifier of identifiers){this.RemoveTab(identifier,true);}}
_DisplayContentSection(content_element){this._content_panel.innerHTML='';content_element.show(this._content_panel);}
GetListOfButtons(){return this._chevronButtons.keys();}
GetContentPanelByName(name){if(!this._chevronButtons.has(name)){return null;}
return this._chevronButtons.get(name).content;}
GetButtonByName(name){return this._chevronButtons.get(name).button;}};;Root.Runtime.cachedResources["media/eventDisplayTable.css"]="/*\n * Copyright 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.no-border-top-datagrid>.data-grid {\n  /* make sure there is no top border, it ruins the menu view */\n  border-top: 0px;\n}\n\n.event-display-table-contents-table-container>.widget>.data-grid {\n  height: 100%;\n}\n\n.media-event-node-json-renderer {\n  background: none;\n  overflow: hidden;\n  width: 100%;\n  height: 100%;\n  border: none;\n  color: var(--selection-fg-color);\n  font-size: 12px;\n}\n\n.data-grid .event-display-table-basic-text-table-entry {\n  line-height: 26px;\n}\n\n/*# sourceURL=media/eventDisplayTable.css */";Root.Runtime.cachedResources["media/mediaView.css"]="/*\n * Copyright (c) 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n\n.playerlist-sidebar {\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n}\n\n.playerlist-sidebar-header {\n  font-size: 22px;\n  padding: 8px 20px;\n  border-bottom:1px solid var(--divider-color);\n}\n\n.playerlist-entry-title>pre {\n  margin: 0px;\n}\n\n.playerlist-entry-title {\n  float: left;\n}\n/*# sourceURL=media/mediaView.css */";Root.Runtime.cachedResources["media/playerListView.css"]="/*\n * Copyright 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline {\n    padding-left: 0;\n    color: rgb(90, 90, 90);\n}\n\nli.storage-group-list-item {\n    padding: 10px 8px 6px 8px;\n}\n\nli.storage-group-list-item:not(:first-child) {\n    border-top: 1px solid rgb(230, 230, 230);\n}\n\nli.storage-group-list-item::before {\n    display: none;\n}\n/*# sourceURL=media/playerListView.css */";Root.Runtime.cachedResources["media/playerPropertiesView.css"]="/*\n * Copyright 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n.media-attributes-view {\n  border-bottom: 1px solid var(--divider-color);\n}\n.media-property-renderer {\n  line-height: 20px;\n  height: 28px;\n  padding: 4px 10px;\n}\n.media-property-renderer-hidden {\n  display: none;\n}\n.media-property-renderer-title {\n  font-size: 14px;\n}\n.media-property-renderer-contents {\n  position: absolute;\n  left: 200px;\n}\n.media-property-renderer:nth-child(even) {\n  background: hsl(214, 70%, 97%);\n}\n.-theme-with-dark-background .media-property-renderer:nth-child(even) {\n  background: rgb(41, 41, 41);\n}\n.media-property-renderer:hover .media-property-renderer-contents {\n  text-decoration: underline;\n}\n.media-properties-frame {\n  display: block;\n}\n\n/*# sourceURL=media/playerPropertiesView.css */";Root.Runtime.cachedResources["media/chevronTabbedPanel.css"]="/*\n * Copyright 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n.chevron-tabbed-panel-title {\n  position: relative;\n  background-color: var(--toolbar-bg-color);\n  border-bottom: 1px solid var(--divider-color);\n  height: 42px;\n  left: 0;\n  right: 0;\n}\n.chevron-tabbed-panel-content {\n  position: relative;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n.chevron-tabbed-panel-title-text {\n  font-size: 22px;\n  margin: 8px 0 0 17px;\n}\n.chevron-tabbed-panel-title-buttons {\n  flex: auto;\n  display: flex;\n  flex-direction: row;\n  margin-left: 0;\n  position: relative;\n}\n.chevron-tabbed-panel-buttons-item {\n  padding: 4px;\n  margin: 10px 4px;\n}\n.chevron-tabbed-panel-buttons-item:hover {\n  text-decoration: underline;\n  cursor: pointer;\n}\n.chevron-tabbed-panel-buttons-item::before,\n.chevron-tabbed-panel-buttons-item::after {\n  content: \"\";\n  top: 4px;\n  border: solid transparent;\n  height: 0;\n  width: 0;\n  position: relative;\n  pointer-events: none;\n  left: 50%;\n  border-width: 10px;\n  margin-left: -10px;\n}\n.chevron-tabbed-panel-buttons-item.selected::before {\n  border-color: transparent;\n  border-bottom-color: var(--divider-color);\n}\n.chevron-tabbed-panel-buttons-item.selected::after {\n  top: 5px;\n  border-bottom-color: #fff;\n  left: calc(-50% + 10px);\n}\n\n/*# sourceURL=media/chevronTabbedPanel.css */";