/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ug extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_BD = "\u0628\u06d0\u0646\u06af\u0627\u0644";
        final String metaValue_CY = "\u0633\u0649\u067e\u0631\u06c7\u0633";
        final String metaValue_bo = "\u062a\u0649\u0628\u06d5\u062a\u0686\u06d5";
        final String metaValue_el = "\u06af\u0649\u0631\u06d0\u0643\u0686\u06d5";
        final String metaValue_gu = "\u06af\u06c7\u062c\u0627\u0631\u0627\u062a\u0686\u06d5";
        final String metaValue_ja = "\u064a\u0627\u067e\u0648\u0646\u0686\u06d5";
        final String metaValue_jv = "\u064a\u0627\u06cb\u0627\u0686\u06d5";
        final String metaValue_kn = "\u0643\u0627\u0646\u0646\u0627\u062f\u0627\u0686\u06d5";
        final String metaValue_ko = "\u0643\u0648\u0631\u06d0\u064a\u06d5\u0686\u06d5";
        final String metaValue_la = "\u0644\u0627\u062a\u0649\u0646\u0686\u06d5";
        final String metaValue_lo = "\u0644\u0627\u0626\u0648\u0633\u0686\u06d5";
        final String metaValue_mn = "\u0645\u0648\u06ad\u063a\u06c7\u0644\u0686\u06d5";
        final String metaValue_my = "\u0628\u0649\u0631\u0645\u0627\u0686\u06d5";
        final String metaValue_su = "\u0633\u06c7\u0646\u062f\u0627\u0686\u06d5";
        final String metaValue_ta = "\u062a\u0627\u0645\u0649\u0644\u0686\u06d5";
        final String metaValue_te = "\u062a\u06d0\u0644\u06c7\u06af\u06c7\u0686\u06d5";
        final String metaValue_th = "\u062a\u0627\u064a\u0644\u0627\u0646\u062f\u0686\u06d5";
        final String metaValue_tl = "\u062a\u0627\u06af\u0627\u0644\u0648\u06af\u0686\u06d5";
        final String metaValue_got = "\u06af\u0648\u062a\u0686\u06d5";
        final String metaValue_hmn = "\u0645\u06c6\u06ad\u0686\u06d5";
        final String metaValue_men = "\u0645\u06d0\u0646\u062f\u06d0\u0686\u06d5";
        final String metaValue_nqo = "\u0646\u0649\u0643\u0648\u0686\u06d5";
        final String metaValue_peo = "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u067e\u0627\u0631\u0649\u0633\u0686\u06d5";
        final String metaValue_ssy = "\u0633\u0627\u062e\u0648\u0686\u06d5";
        final String metaValue_uga = "\u0626\u06c7\u06af\u0627\u0631\u0649\u062a\u0649\u0643\u0686\u06d5";
        final String metaValue_vai = "\u06cb\u0627\u064a\u0686\u06d5";
        final String metaValue_zbl = "\u0628\u0649\u0644\u0649\u0633 \u0628\u06d5\u0644\u06af\u0649\u0644\u0649\u0631\u0649";
        final String metaValue_Hans = "\u0626\u0627\u062f\u062f\u0649\u064a \u062e\u06d5\u0646\u0686\u06d5";
        final String metaValue_Hant = "\u0645\u06c7\u0631\u06d5\u0643\u0643\u06d5\u067e \u062e\u06d5\u0646\u0686\u06d5";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0643\u0648\u0644\u0649\u0634\u0686\u06d5" },
            { "Ogam", "\u0626\u0648\u06af\u06d5\u0645\u0686\u06d5" },
            { "mwl", "\u0645\u0649\u0631\u0627\u0646\u062f\u06d0\u0633\u0686\u06d5" },
            { "Zsym", "\u0628\u06d5\u0644\u06af\u06d5" },
            { "cch", "\u0626\u0627\u062a\u0633\u0627\u0645\u0686\u06d5" },
            { "mwr", "\u0645\u0627\u0631\u06cb\u0627\u0631\u0649\u0686\u06d5" },
            { "type.nu.lanatham", "\u062a\u0627\u064a \u062a\u0627\u0645\u0686\u06d5 \u062a\u0627\u0645 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Tagb", "\u062a\u0627\u06af\u0628\u0627\u0646\u06cb\u0627\u0686\u06d5" },
            { "%%NJIVA", "\u06af\u0649\u0646\u0649\u06cb\u0627/\u0646\u0649\u062c\u0649\u06cb\u0627 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "egy", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0645\u0649\u0633\u0649\u0631\u0686\u06d5" },
            { "raj", "\u0631\u0627\u062c\u0627\u0633\u062a\u0627\u0646\u0686\u06d5" },
            { "Phag", "\u067e\u0627\u0633\u067e\u0627\u0686\u06d5" },
            { "tem", "\u062a\u06d0\u0645\u0646\u06d0\u0686\u06d5" },
            { "teo", "\u062a\u06d0\u0633\u0648\u0686\u06d5" },
            { "rap", "\u0631\u0627\u067e\u0627\u0646\u0649\u064a\u0686\u06d5" },
            { "ter", "\u062a\u06d0\u0631\u06d0\u0646\u0627\u0686\u06d5" },
            { "AC", "\u0626\u0627\u0633\u0633\u06d0\u0646\u0633\u0649\u064a\u0648\u0646 \u0626\u0627\u0631\u0649\u0644\u0649" },
            { "tet", "\u062a\u06d0\u062a\u06c7\u0645\u0686\u06d5" },
            { "AD", "\u0626\u0627\u0646\u062f\u0648\u0631\u0631\u0627" },
            { "AE", "\u0626\u06d5\u0631\u06d5\u0628 \u0628\u0649\u0631\u0644\u06d5\u0634\u0645\u06d5 \u062e\u06d5\u0644\u0649\u067e\u0649\u0644\u0649\u0643\u0649" },
            { "AF", "\u0626\u0627\u0641\u063a\u0627\u0646\u0649\u0633\u062a\u0627\u0646" },
            { "AG", "\u0626\u0627\u0646\u062a\u0649\u06af\u06c7\u0626\u0627 \u06cb\u06d5 \u0628\u0627\u0631\u0628\u06c7\u062f\u0627" },
            { "type.ca.ethiopic", "\u0626\u06d0\u0641\u0649\u064a\u0648\u067e\u0649\u064a\u06d5 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "AI", "\u0626\u0627\u0646\u06af\u06cb\u0649\u0644\u0644\u0627" },
            { "AL", "\u0626\u0627\u0644\u0628\u0627\u0646\u0649\u064a\u06d5" },
            { "AM", "\u0626\u06d5\u0631\u0645\u06d0\u0646\u0649\u064a\u06d5" },
            { "Teng", "\u062a\u06d0\u06ad\u06cb\u0627\u0631\u0686\u06d5" },
            { "AO", "\u0626\u0627\u0646\u06af\u0648\u0644\u0627" },
            { "AQ", "\u0626\u0627\u0646\u062a\u0627\u0631\u0643\u062a\u0649\u0643\u0627" },
            { "AR", "\u0626\u0627\u0631\u06af\u06d0\u0646\u062a\u0649\u0646\u0627" },
            { "Prti", "\u067e\u0627\u0631\u062a\u0649\u0626\u0627\u0646\u0686\u06d5 \u0626\u0648\u064a\u0645\u0627 \u062e\u06d5\u062a" },
            { "AS", "\u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u0633\u0627\u0645\u0648\u0626\u0627" },
            { "AT", "\u0626\u0627\u06cb\u0649\u0633\u062a\u0649\u0631\u0649\u064a\u06d5" },
            { "AU", "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5" },
            { "AW", "\u0626\u0627\u0631\u06c7\u0628\u0627" },
            { "en_US", "\u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "AX", "\u0626\u0627\u0644\u0627\u0646\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "mye", "\u0645\u064a\u06d0\u0646\u06d0\u0686\u06d5" },
            { "AZ", "\u0626\u06d5\u0632\u06d5\u0631\u0628\u06d5\u064a\u062c\u0627\u0646" },
            { "%%AREVELA", "\u0634\u06d5\u0631\u0642\u0649\u064a \u0626\u06d5\u0631\u0645\u06d5\u0646\u0686\u06d5" },
            { "BA", "\u0628\u0648\u0633\u0649\u0646\u0649\u064a\u06d5 \u06cb\u06d5 \u06af\u06d0\u0631\u062a\u0633\u06d0\u06af\u0648\u06cb\u0649\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "ceb", "\u0633\u06d0\u0628\u06c7\u0686\u06d5" },
            { "BD", metaValue_BD },
            { "kum", "\u0642\u06c7\u0645\u06c7\u0642\u0686\u06d5" },
            { "BE", "\u0628\u06d0\u0644\u06af\u0649\u064a\u06d5" },
            { "gmh", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u06d5\u0633\u0649\u0631 \u0626\u06d0\u06af\u0649\u0632\u0644\u0649\u0643 \u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5" },
            { "BF", "\u0628\u06c7\u0631\u0643\u0649\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u06c7\u0644\u063a\u0627\u0631\u0649\u064a\u06d5" },
            { "BH", "\u0628\u06d5\u06be\u0631\u06d5\u064a\u0646" },
            { "BI", "\u0628\u06c7\u0631\u06c7\u0646\u062f\u0649" },
            { "BJ", "\u0628\u06d0\u0646\u0649\u0646" },
            { "BL", "\u0633\u0627\u064a\u0646\u062a \u0628\u0627\u0631\u062a\u06d0\u0644\u06d0\u0645\u0649" },
            { "BM", "\u0628\u06d0\u0631\u0645\u06c7\u062f\u0627" },
            { "kut", "\u0643\u06c7\u062a\u06d5\u0646\u0627\u064a\u0686\u06d5" },
            { "myv", "\u0626\u06d0\u0631\u0632\u0627\u0686\u06d5" },
            { "BN", "\u0628\u0649\u0631\u06c7\u0646\u06d0\u064a" },
            { "BO", "\u0628\u0648\u0644\u0649\u06cb\u0649\u064a\u06d5" },
            { "BQ", "\u0643\u0627\u0631\u0649\u0628 \u062f\u06d0\u06ad\u0649\u0632\u0649 \u06af\u0648\u0644\u0644\u0627\u0646\u062f\u0649\u064a\u06d5" },
            { "BR", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5" },
            { "BS", "\u0628\u0627\u06be\u0627\u0645\u0627" },
            { "xog", "\u0633\u0648\u06af\u0627\u0686\u06d5" },
            { "BT", "\u0628\u06c7\u062a\u0627\u0646" },
            { "BV", "\u0628\u0648\u06cb\u06d0\u062a \u0626\u0627\u0631\u0649\u0644\u0649" },
            { "BW", "\u0628\u0648\u062a\u0633\u06cb\u0627\u0646\u0627" },
            { "BY", "\u0628\u06d0\u0644\u0627\u0631\u06c7\u0633\u0649\u064a\u06d5" },
            { "BZ", "\u0628\u06d0\u0644\u0649\u0632" },
            { "Visp", "\u0643\u06c6\u0631\u06c8\u0646\u06c8\u0634\u0686\u0627\u0646 \u062a\u0627\u06cb\u06c7\u0634" },
            { "type.ca.persian", "\u067e\u0627\u0631\u0649\u0633 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "type.nu.hebr", "\u0626\u0649\u0628\u0631\u0627\u0646\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "CA", "\u0643\u0627\u0646\u0627\u062f\u0627" },
            { "CC", "\u0643\u0648\u0643\u0648\u0633 (\u0643\u0649\u0644\u0649\u06ad) \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "CD", "\u0643\u0648\u0646\u06af\u0648 - \u0643\u0649\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u062c\u06c7\u0645\u06be\u06c7\u0631\u0649\u064a\u0649\u062a\u0649" },
            { "CG", "\u0643\u0648\u0646\u06af\u0648 - \u0628\u0649\u0631\u0627\u0632\u0632\u0627\u06cb\u0649\u0644" },
            { "CH", "\u0634\u0649\u06cb\u06d0\u062a\u0633\u0627\u0631\u0649\u064a\u06d5" },
            { "CI", "\u0643\u0648\u062a\u06d0 \u062f\u06d0 \u0626\u0649\u06cb\u0648\u0626\u0649\u0631" },
            { "CK", "\u0643\u06c7\u0643 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "CL", "\u0686\u0649\u0644\u0649" },
            { "Kthi", "\u0643\u0627\u064a\u0627\u062a\u0649\u0686\u06d5" },
            { "CM", "\u0643\u0627\u0645\u06d0\u0631\u0648\u0646" },
            { "CN", "\u062c\u06c7\u06ad\u06af\u0648" },
            { "CO", "\u0643\u0648\u0644\u0648\u0645\u0628\u0649\u064a\u06d5" },
            { "CP", "\u0643\u0649\u0644\u0649\u067e\u067e\u06d0\u0631\u062a\u0648\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "CR", "\u0643\u0648\u0633\u062a\u0627\u0631\u0649\u0643\u0627" },
            { "CU", "\u0643\u06c7\u0628\u0627" },
            { "CV", "\u064a\u06d0\u0634\u0649\u0644 \u062a\u06c7\u0645\u0634\u06c7\u0642" },
            { "CW", "\u0643\u06c7\u0631\u0627\u0686\u0627\u06cb" },
            { "CX", "\u0645\u0649\u0644\u0627\u062f \u0626\u0627\u0631\u0649\u0644\u0649" },
            { "CY", metaValue_CY },
            { "type.nu.bali", "\u0628\u0627\u0644\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "CZ", "\u0686\u06d0\u062e \u062c\u06c7\u0645\u06be\u06c7\u0631\u0649\u064a\u0649\u062a\u0649" },
            { "eka", "\u0626\u06d0\u0643\u0627\u062c\u06c7\u0643\u0686\u06d5" },
            { "%%RIGIK", "\u0626\u06d5\u0646\u0626\u06d5\u0646\u0649\u06cb\u0649 \u06cb\u0648\u0644\u0627\u067e\u06c7\u0643\u0686\u06d5" },
            { "DE", "\u06af\u06d0\u0631\u0645\u0627\u0646\u0649\u064a\u06d5" },
            { "goh", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0626\u06d0\u06af\u0649\u0632\u0644\u0649\u0643 \u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5" },
            { "ace", "\u0626\u0627\u062a\u062c\u06d0\u0686\u06d5" },
            { "cgg", "\u0686\u0649\u06af\u0627\u0686\u06d5" },
            { "DG", "\u062f\u06d0\u06af\u0648-\u06af\u0627\u0631\u0634\u0649\u064a\u0627" },
            { "type.nu.deva", "\u062f\u06d0\u06cb\u0627\u0646\u0627\u06af\u0627\u0631\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "DJ", "\u062c\u0649\u0628\u06c7\u062a\u0649" },
            { "DK", "\u062f\u0627\u0646\u0649\u064a\u06d5" },
            { "ach", "\u0626\u0627\u0686\u0648\u0644\u0649\u0686\u06d5" },
            { "gon", "\u06af\u0648\u0646\u062f\u0649\u0686\u06d5" },
            { "Brai", "\u0628\u0631\u0627\u0626\u0649\u0644 \u0626\u06d5\u0645\u0627\u0644\u0627\u0631 \u064a\u06d0\u0632\u0649\u0642\u0649" },
            { "Brah", "\u0628\u0631\u0627\u062e\u0645\u0649" },
            { "DM", "\u062f\u0648\u0645\u0649\u0646\u0649\u0643\u0627" },
            { "type.nu.armnlow", "\u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631 (\u0643\u0649\u0686\u0649\u0643 \u06be\u06d5\u0631\u067e)" },
            { "DO", "\u062f\u0648\u0645\u0649\u0646\u0649\u0643\u0627 \u062c\u06c7\u0645\u06be\u06c7\u0631\u0649\u064a\u0649\u062a\u0649" },
            { "gor", "\u06af\u0648\u0631\u0648\u0646\u062a\u0627\u0644\u0648\u0686\u06d5" },
            { "got", metaValue_got },
            { "Mtei", "\u0645\u0627\u0646\u0649\u067e\u06c7\u0631\u0649\u0686\u06d5" },
            { "zun", "\u0632\u06c7\u0646\u0649\u0686\u06d5" },
            { "tig", "\u062a\u0649\u06af\u0631\u06d0\u0686\u06d5" },
            { "Takr", "\u062a\u0627\u0643\u0631\u0649\u0686\u06d5" },
            { "DZ", "\u0626\u0627\u0644\u062c\u0649\u0631\u0649\u064a\u06d5" },
            { "pag", "\u067e\u0627\u0646\u06af\u0627\u0633\u0649\u0646\u0627\u0646\u0686\u06d5" },
            { "pal", "\u067e\u06d5\u06be\u0644\u06d5\u06cb\u0649\u0686\u06d5" },
            { "EA", "\u0633\u06d0\u064a\u062a\u0627 \u06cb\u06d5 \u0645\u06d0\u0644\u0649\u0644\u0627" },
            { "chb", "\u0686\u0649\u0628\u0686\u0627\u0686\u06d5" },
            { "pam", "\u067e\u0627\u0645\u067e\u0627\u0646\u06af\u0627\u0686\u06d5" },
            { "EC", "\u0626\u06d0\u0643\u06cb\u0627\u062a\u0648\u0631" },
            { "pap", "\u067e\u0627\u067e\u0649\u064a\u0627\u0645\u06d0\u0646\u062a\u0648\u0686\u06d5" },
            { "ada", "\u0626\u0627\u062f\u0627\u06ad\u0645\u06d0\u0686\u06d5" },
            { "EE", "\u0626\u06d0\u0633\u062a\u0648\u0646\u0649\u064a\u06d5" },
            { "tiv", "\u062a\u0649\u06cb\u0686\u06d5" },
            { "EG", "\u0645\u0649\u0633\u0649\u0631" },
            { "EH", "\u063a\u06d5\u0631\u0628\u0649\u064a \u0633\u0627\u062e\u0627\u0631\u0627" },
            { "chg", "\u0686\u0627\u063a\u0627\u062a\u0627\u064a\u0686\u06d5" },
            { "pau", "\u067e\u0627\u0644\u0627\u06cb\u0686\u06d5" },
            { "chk", "\u0686\u06c7\u0643\u0686\u06d5" },
            { "chn", "\u0686\u0649\u0646\u06c7\u0643-\u0698\u0627\u0631\u06af\u0648\u0646\u0686\u06d5" },
            { "chm", "\u0645\u0627\u0631\u0649\u0686\u06d5" },
            { "chp", "\u0686\u0649\u067e\u06d0\u06cb\u064a\u0627\u0646\u0686\u06d5" },
            { "cho", "\u0686\u0648\u0643\u062a\u0627\u06cb\u0686\u06d5" },
            { "chr", "\u0686\u06d0\u0631\u0648\u0643\u0649\u0686\u06d5" },
            { "ER", "\u0626\u06d0\u0631\u0649\u062a\u0631\u0649\u064a\u06d5" },
            { "ES", "\u0626\u0649\u0633\u067e\u0627\u0646\u0649\u064a\u06d5" },
            { "ET", "\u0626\u06d0\u0641\u0649\u064a\u0648\u067e\u0649\u064a\u06d5" },
            { "EU", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u0626\u0649\u062a\u062a\u0649\u067e\u0627\u0642\u0649" },
            { "elx", "\u0626\u06d0\u0644\u0627\u0645\u0649\u062a\u0686\u06d5" },
            { "type.ca.gregorian", "\u0645\u0649\u0644\u0627\u062f\u0649\u064a\u06d5 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "chy", "\u0686\u06d0\u064a\u06d0\u0646\u0686\u06d5" },
            { "type.nu.gujr", "\u06af\u06c7\u062c\u0627\u0631\u0627\u062a\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Inds", "\u0626\u0649\u0646\u062f\u06c7\u0633\u0686\u06d5" },
            { "ady", "\u0626\u0627\u062f\u0649\u06af\u06d0\u064a\u0686\u06d5" },
            { "FI", "\u0641\u0649\u0646\u0644\u0627\u0646\u062f\u0649\u064a\u06d5" },
            { "FJ", "\u0641\u0649\u062c\u0649" },
            { "FK", "\u0641\u0627\u0644\u0643\u0644\u0627\u0646\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "FM", "\u0645\u0649\u0643\u0631\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5" },
            { "FO", "\u0641\u0627\u0631\u0648 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "Taml", metaValue_ta },
            { "FR", "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5" },
            { "Kpel", "\u0643\u067e\u06d0\u0644\u0644\u06d0\u0686\u06d5" },
            { "tkl", "\u062a\u0648\u0643\u06d0\u0644\u0627\u06cb\u0686\u06d5" },
            { "grb", "\u06af\u0631\u06d0\u0628\u0648\u0686\u06d5" },
            { "root", "\u063a\u0648\u0644 \u062a\u0649\u0644" },
            { "%%DAJNKO", "\u062f\u0627\u0698\u0649\u0646\u0643\u0648 \u0626\u06d0\u0644\u0649\u067e\u0628\u06d5\u0633\u0649" },
            { "type.ca.indian", "\u06be\u0649\u0646\u062f\u0649\u0633\u062a\u0627\u0646 \u062f\u06c6\u0644\u06d5\u062a \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "grc", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u06af\u0649\u0631\u06d0\u0643\u0686\u06d5" },
            { "GA", "\u06af\u0627\u0628\u0648\u0646" },
            { "vot", "\u06cb\u0648\u062a\u06d0\u0686\u06d5" },
            { "GB", "\u0628\u0649\u0631\u0644\u06d5\u0634\u0645\u06d5 \u067e\u0627\u062f\u0649\u0634\u0627\u06be\u0644\u0649\u0642" },
            { "GD", "\u06af\u0649\u0631\u06d0\u0646\u0627\u062f\u0627" },
            { "GE", "\u06af\u0649\u0631\u06c7\u0632\u0649\u064a\u06d5" },
            { "GF", "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u06af\u0649\u06cb\u0649\u064a\u0627\u0646\u0627" },
            { "GG", "\u06af\u06c7\u0631\u0646\u0633\u06d0\u064a" },
            { "GH", "\u06af\u0627\u0646\u0627" },
            { "Tale", "\u062a\u0627\u064a-\u0644\u06d5\u0686\u06d5" },
            { "GI", "\u062c\u06d5\u0628\u0649\u0644\u062a\u0627\u0631\u0649\u0642" },
            { "afh", "\u0626\u0627\u0641\u0631\u0649\u062e\u0649\u0644\u0649\u0686\u06d5" },
            { "GL", "\u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f\u0649\u064a\u06d5" },
            { "enm", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u06d5\u0633\u0649\u0631 \u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "GM", "\u06af\u0627\u0645\u0628\u0649\u064a\u06d5" },
            { "GN", "\u06af\u0649\u06cb\u0649\u0646\u0649\u064a\u06d5" },
            { "GP", "\u06af\u0649\u06cb\u0627\u062f\u06d0\u0644\u06c7\u067e" },
            { "GQ", "\u0626\u06d0\u0643\u06cb\u0627\u062a\u0648\u0631 \u06af\u0649\u06cb\u0649\u0646\u0649\u064a\u06d5\u0633\u0649" },
            { "GR", "\u06af\u0649\u0631\u06d0\u062a\u0633\u0649\u064a\u06d5" },
            { "GS", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u062c\u0648\u0631\u062c\u0649\u064a\u06d5 \u06cb\u06d5 \u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0633\u0627\u0646\u062f\u06cb\u0649\u0686 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "GT", "\u06af\u0649\u06cb\u0627\u062a\u06d0\u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u06c7\u0626\u0627\u0645" },
            { "GW", "\u06af\u0649\u06cb\u0649\u0646\u0649\u064a\u06d5 \u0628\u0649\u0633\u0633\u0627\u0626\u06c7" },
            { "tli", "\u062a\u0649\u0644\u0649\u0646\u06af\u0649\u062a\u0686\u06d5" },
            { "tlh", "\u0643\u0649\u0644\u0649\u0646\u06af\u0648\u0646\u0686\u06d5" },
            { "Talu", "\u064a\u06d0\u06ad\u0649 \u062a\u0627\u064a-\u0644\u06d5\u0686\u06d5" },
            { "GY", "\u06af\u0649\u06cb\u0649\u064a\u0627\u0646\u0627" },
            { "ckb", "\u0645\u06d5\u0631\u0643\u0649\u0632\u0649\u064a \u0643\u06c7\u0631\u062f\u0686\u06d5" },
            { "zxx", "\u062a\u0649\u0644 \u0645\u06d5\u0632\u0645\u06c7\u0646\u0649 \u064a\u0648\u0642" },
            { "Jurc", "\u062c\u06c7\u0631\u0686\u06d0\u0646\u0686\u06d5" },
            { "de_AT", "\u0626\u0627\u06cb\u0633\u062a\u0649\u0631\u0649\u064a\u06d5 \u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0634\u064a\u0627\u06ad\u06af\u0627\u06ad \u0626\u0627\u0644\u0627\u06be\u0649\u062f\u06d5 \u0645\u06d5\u0645\u06c7\u0631\u0649\u064a \u0631\u0627\u064a\u0648\u0646\u0649 (\u062c\u06c7\u06ad\u06af\u0648)" },
            { "HM", "\u06be\u06d0\u0631\u062f \u0626\u0627\u0631\u0649\u0644\u0649 \u06cb\u06d5 \u0645\u0627\u0643\u062f\u0648\u0646\u0627\u0644\u062f \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "HN", "\u06be\u0648\u0646\u062f\u06c7\u0631\u0627\u0633" },
            { "HR", "\u0643\u0649\u0631\u0648\u062f\u0649\u064a\u06d5" },
            { "agq", "\u0626\u0627\u06af\u06d5\u0645\u0686\u06d5" },
            { "gsw", "\u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5 \u0634\u0649\u06cb\u0649\u062a\u0633\u0627\u0631\u0649\u064a\u06d5" },
            { "type.ca.islamic-umalqura", "\u0626\u0649\u0633\u0644\u0627\u0645 \u06be\u0649\u062c\u0631\u0649\u064a\u06d5 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649 (\u0626\u06c7\u0645 \u0626\u06d5\u0644\u0642\u06c7\u0631\u0627)" },
            { "HT", "\u06be\u0627\u064a\u062a\u0649" },
            { "HU", "\u06cb\u06d0\u0646\u06af\u0649\u0631\u0649\u064a\u06d5" },
            { "tmh", "\u062a\u0627\u0645\u0627\u0634\u06d0\u0643\u0686\u06d5" },
            { "IC", "\u0643\u0627\u0646\u0627\u0631\u0649 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "peo", metaValue_peo },
            { "ID", "\u06be\u0649\u0646\u062f\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5" },
            { "type.nu.kali", "\u0643\u0627\u064a\u0627\u06be\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "IE", "\u0626\u0649\u0631\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5" },
            { "nap", "\u0646\u0627\u067e\u0648\u0644\u0649\u0686\u06d5" },
            { "%%NDYUKA", "\u0646\u0649\u062f\u064a\u06c7\u0643\u0627 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "naq", "\u0646\u0627\u0645\u0627\u0686\u06d5" },
            { "type.nu.sora", "\u0633\u0648\u0631\u0627 \u0633\u0648\u0645\u067e\u06d0\u06ad \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "zza", "\u0632\u0627\u0632\u0627\u0686\u06d5" },
            { "Tang", "\u062a\u0627\u06ad\u063a\u06c7\u062a\u0686\u06d5" },
            { "IL", "\u0626\u0649\u0633\u0631\u0627\u0626\u0649\u0644\u0649\u064a\u06d5" },
            { "Nbat", "\u0626\u0627\u0646\u0628\u0627\u062a\u0686\u06d5" },
            { "IM", "\u0645\u0627\u0646 \u0626\u0627\u0631\u0649\u0644\u0649" },
            { "IN", "\u06be\u0649\u0646\u062f\u0649\u0633\u062a\u0627\u0646" },
            { "type.co.eor", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u062a\u06d5\u0631\u062a\u0649\u067e\u0644\u06d5\u0634 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "IO", "\u0626\u06d5\u0646\u06af\u0644\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u06be\u0649\u0646\u062f\u0649 \u0626\u0648\u0643\u064a\u0627\u0646 \u062a\u06d0\u0631\u0631\u0649\u062a\u0648\u0631\u0649\u064a\u06d5\u0633\u0649" },
            { "IQ", "\u0626\u0649\u0631\u0627\u0642" },
            { "IR", "\u0626\u0649\u0631\u0627\u0646" },
            { "IS", "\u0626\u0649\u0633\u0644\u0627\u0646\u062f\u0649\u064a\u06d5" },
            { "IT", "\u0626\u0649\u062a\u0627\u0644\u0649\u064a\u06d5" },
            { "Zmth", "\u0645\u0627\u062a\u06d0\u0645\u0627\u062a\u0649\u0643\u0649\u0644\u0649\u0642 \u0628\u06d5\u0644\u06af\u06d5" },
            { "type.nu.thai", "\u062a\u0627\u064a\u0644\u0627\u0646\u062f\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "%%POSIX", "\u0643\u0648\u0645\u067e\u064a\u06c7\u062a\u06d0\u0631" },
            { "type.nu.beng", "\u0628\u06d0\u0646\u06af\u0627\u0644\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "JE", "\u062c\u06d0\u0631\u0633\u06d0\u064a" },
            { "type.ca.islamic", "\u0626\u0649\u0633\u0644\u0627\u0645 \u06be\u0649\u062c\u0631\u0649\u064a\u06d5 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "Beng", metaValue_BD },
            { "JM", "\u064a\u0627\u0645\u0627\u064a\u0643\u0627" },
            { "JO", "\u0626\u0649\u064a\u0648\u0631\u062f\u0627\u0646\u0649\u064a\u06d5" },
            { "JP", "\u064a\u0627\u067e\u0648\u0646\u0649\u064a\u06d5" },
            { "%%1606NICT", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u0627\u062e\u0649\u0631\u0642\u0649 \u062f\u06d5\u06cb\u0631\u062f\u0649\u0643\u0649 \u0641\u0649\u0631\u0627\u0646\u0633\u06c7\u0632\u0686\u06d5 1606" },
            { "ain", "\u0626\u0627\u064a\u0646\u06c7\u0686\u06d5" },
            { "Mend", metaValue_men },
            { "guz", "\u06af\u06c7\u0633\u0649\u0686\u06d5" },
            { "tog", "\u0646\u064a\u0627\u0633\u0627 \u062a\u0648\u06ad\u0627\u0646\u0686\u06d5" },
            { "type.nu.knda", "\u0643\u0627\u0646\u0646\u0627\u062f\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Kali", "\u0643\u0627\u064a\u0627\u06be\u0686\u06d5" },
            { "de_CH", "\u0634\u0649\u06cb\u0649\u062a\u0633\u0627\u0631\u0649\u064a\u06d5 \u0626\u06d0\u06af\u0649\u0632\u0644\u0649\u0643 \u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5" },
            { "type.ca.buddhist", "\u0628\u06c7\u062f\u062f\u0627 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "KE", "\u0643\u06d0\u0646\u0649\u064a\u06d5" },
            { "419", "\u0644\u0627\u062a\u0649\u0646 \u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627" },
            { "KG", "\u0642\u0649\u0631\u063a\u0649\u0632\u0649\u0633\u062a\u0627\u0646" },
            { "KH", "\u0643\u0627\u0645\u0628\u0648\u062f\u0698\u0627" },
            { "KI", "\u0643\u0649\u0631\u0649\u0628\u0627\u062a\u0649" },
            { "KM", "\u0643\u0648\u0645\u0648\u0631\u0648" },
            { "Knda", metaValue_kn },
            { "KN", "\u0633\u0627\u064a\u0646\u062a \u0643\u0649\u062a\u0649\u0633 \u06cb\u06d5 \u0646\u06d0\u06cb\u0649\u0633" },
            { "Zinh", "\u0626\u0649\u0631\u0633\u0649\u064a\u06d5\u062a \u0626\u0627\u062a\u0627\u0644\u063a\u06c7" },
            { "fr_CA", "\u0643\u0627\u0646\u0627\u062f\u0627 \u0641\u0649\u0631\u0627\u0646\u0633\u06c7\u0632\u0686\u06d5" },
            { "KP", "\u0686\u0627\u06cb\u0634\u064a\u06d5\u0646" },
            { "KR", "\u0643\u0648\u0631\u06d0\u064a\u06d5" },
            { "Plrd", "\u067e\u0648\u0644\u0644\u0627\u0631\u062f \u062a\u0627\u06cb\u06c7\u0634\u0644\u0649\u0631\u0649" },
            { "fr_CH", "\u0634\u0649\u06cb\u0649\u062a\u0633\u0627\u0631\u0649\u064a\u06d5 \u0641\u0649\u0631\u0627\u0646\u0633\u06c7\u0632\u0686\u06d5" },
            { "KW", "\u0643\u06c7\u06cb\u06d5\u064a\u062a" },
            { "tpi", "\u062a\u0648\u0643-\u067e\u0649\u0633\u0649\u0646\u0686\u06d5" },
            { "KY", "\u0643\u0627\u064a\u0645\u0627\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "KZ", "\u0642\u0627\u0632\u0627\u0642\u0649\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0643\u0649\u0631\u0649\u0644" },
            { "LA", "\u0644\u0627\u0626\u0648\u0633" },
            { "LB", "\u0644\u0649\u06cb\u0627\u0646" },
            { "LC", "\u0633\u0627\u064a\u0646\u062a \u0644\u06c7\u0633\u0649\u064a\u06d5" },
            { "phn", "\u0641\u0649\u0646\u0649\u0643\u0649\u064a\u06d5\u0686\u06d5" },
            { "Cyrs", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0686\u0649\u0631\u0643\u0627\u06cb \u0633\u0649\u0644\u0627\u06cb\u064a\u0627\u0646\u0686\u06d5 \u0643\u0649\u0631\u0649\u0644" },
            { "gwi", "\u06af\u0649\u06cb\u0649\u0686\u0649\u0646\u0686\u06d5" },
            { "nds", "\u062a\u06c6\u06cb\u06d5\u0646 \u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5" },
            { "LI", "\u0644\u0649\u0643\u062a\u06d0\u0646\u0633\u062a\u06d0\u064a\u0646" },
            { "LK", "\u0633\u0649\u0631\u0649\u0644\u0627\u0646\u0643\u0627" },
            { "akk", "\u0626\u0627\u0643\u0643\u0627\u062f\u0686\u06d5" },
            { "cop", "\u0643\u0648\u067e\u062a\u0649\u0643\u0686\u06d5" },
            { "LR", "\u0644\u0649\u0628\u06d0\u0631\u0649\u064a\u06d5" },
            { "LS", "\u0644\u06d0\u0633\u0648\u062a\u0648" },
            { "Phlv", "\u067e\u06d5\u06be\u0644\u0649\u06cb\u0649\u0686\u06d5 \u0643\u0649\u062a\u0627\u0628\u0649 \u062a\u0649\u0644" },
            { "LT", "\u0644\u0649\u062a\u06cb\u0627\u0646\u0649\u064a\u06d5" },
            { "LU", "\u0644\u0649\u064a\u06c7\u0643\u0633\u06d0\u0645\u0628\u06c7\u0631\u06af" },
            { "LV", "\u0644\u0627\u062a\u06cb\u0649\u064a\u06d5" },
            { "Kana", "\u0643\u0627\u062a\u0627\u0643\u0627\u0646\u0627" },
            { "Sora", "\u0633\u0648\u0631\u0627 \u0633\u0627\u0645\u067e\u0649\u06ad" },
            { "LY", "\u0644\u0649\u06cb\u0649\u064a\u06d5" },
            { "lad", "\u0644\u0627\u062f\u0649\u0646\u0648\u0686\u06d5" },
            { "vun", "\u06cb\u06c7\u0646\u062c\u0648\u0686\u06d5" },
            { "lah", "\u0644\u0627\u0646\u062f\u0627\u0686\u06d5" },
            { "lag", "\u0644\u0627\u0646\u06af\u0649\u0686\u06d5" },
            { "Thaa", "\u062a\u0627\u0646\u0627\u0686\u06d5" },
            { "MA", "\u0645\u0627\u0631\u0627\u0643\u06d5\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u0643\u0648" },
            { "MD", "\u0645\u0648\u0644\u062f\u0648\u06cb\u0627" },
            { "Nshu", "\u0646\u06c8\u0634\u06c7\u0686\u06d5" },
            { "ME", "\u0642\u0627\u0631\u0627 \u062a\u0627\u063a" },
            { "MF", "\u0633\u0627\u064a\u0646\u062a \u0645\u0627\u0631\u062a\u0649\u0646" },
            { "lam", "\u0644\u0627\u0645\u0628\u0627\u0686\u06d5" },
            { "MG", "\u0645\u0627\u062f\u0627\u063a\u0627\u0633\u0642\u0627\u0631" },
            { "Thai", metaValue_th },
            { "MH", "\u0645\u0627\u0631\u0634\u0627\u0644 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "ale", "\u0626\u0627\u0644\u06d0\u064a\u06c7\u062a\u0686\u06d5" },
            { "type.nu.vaii", "\u06cb\u0627\u064a\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "MK", "\u0645\u0627\u0643\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5" },
            { "ML", "\u0645\u0627\u0644\u0649" },
            { "MM", "\u0628\u0649\u0631\u0645\u0627" },
            { "MN", "\u0645\u0648\u06ad\u063a\u06c7\u0644\u0649\u064a\u06d5" },
            { "new", "\u0646\u06d0\u06cb\u0627\u0631\u0649\u0686\u06d5" },
            { "MO", "\u0626\u0627\u06cb\u0645\u06d0\u0646 \u0626\u0627\u0644\u0627\u06be\u0649\u062f\u06d5 \u0645\u06d5\u0645\u06c7\u0631\u0649\u064a \u0631\u0627\u064a\u0648\u0646\u0649" },
            { "MP", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0645\u0627\u0631\u0649\u064a\u0627\u0646\u0627 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "MQ", "\u0645\u0627\u0631\u062a\u0649\u0646\u0649\u0643\u0627" },
            { "MR", "\u0645\u0627\u06cb\u0631\u0649\u062a\u0627\u0646\u0649\u064a\u06d5" },
            { "MS", "\u0645\u0648\u0646\u062a\u0633\u06d0\u0631\u0631\u0627\u062a" },
            { "MT", "\u0645\u0627\u0644\u062a\u0627" },
            { "MU", "\u0645\u0627\u06cb\u0631\u0649\u062a\u0649\u064a\u06c7\u0633" },
            { "alt", "\u062c\u06d5\u0646\u06c7\u0628\u0649 \u0626\u0627\u0644\u062a\u0627\u064a \u062a\u0649\u0644\u0644\u0649\u0631\u0649" },
            { "MV", "\u0645\u0627\u0644\u062f\u0649\u06cb\u06d0" },
            { "MW", "\u0645\u0627\u0644\u0627\u06cb\u0649" },
            { "MX", "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627" },
            { "type.ca.japanese", "\u064a\u0627\u067e\u0648\u0646\u0649\u064a\u06d5 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "MY", "\u0645\u0627\u0644\u0627\u064a\u0633\u0649\u064a\u0627" },
            { "MZ", "\u0645\u0648\u0632\u0627\u0645\u0628\u0649\u0643" },
            { "Phli", "\u067e\u06d5\u06be\u0644\u0649\u06cb\u0649\u0686\u06d5 \u0626\u0648\u064a\u0645\u0627 \u062e\u06d5\u062a" },
            { "NA", "\u0646\u0627\u0645\u0649\u0628\u0649\u064a\u06d5" },
            { "type.ca.hebrew", "\u064a\u06d5\u06be\u06c7\u062f\u0649 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "type.co.dictionary", "\u0644\u06c7\u063a\u06d5\u062a \u062a\u0649\u0632\u0649\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "NC", "\u064a\u06d0\u06ad\u0649 \u0643\u0627\u0644\u06d0\u062f\u0648\u0646\u0649\u064a\u06d5" },
            { "%%WADEGILE", "\u06cb\u06d0\u064a \u0626\u0627\u0626\u0649\u0644\u0649\u0633\u0649 \u067e\u0649\u0646\u064a\u0649\u0646 \u0644\u0627\u062a\u0649\u0646\u0644\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634" },
            { "%%UCRCOR", "\u0628\u0649\u0631\u0644\u0649\u0643\u0643\u06d5 \u0643\u06d5\u0644\u06af\u06d5\u0646 \u062a\u06c8\u0632\u0649\u062a\u0649\u0644\u06af\u06d5\u0646 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "NE", "\u0646\u0649\u06af\u06d0\u0631" },
            { "NF", "\u0646\u0648\u0631\u0641\u0648\u0644\u0643 \u0626\u0627\u0631\u0649\u0644\u0649" },
            { "NG", "\u0646\u0649\u06af\u06d0\u0631\u0649\u064a\u06d5" },
            { "trv", "\u062a\u0648\u0631\u0648\u0643\u0648\u0686\u06d5" },
            { "Phlp", "\u067e\u06d5\u06be\u0644\u0649\u06cb\u0649\u0686\u06d5 \u0634\u06d0\u0626\u0649\u0631\u0649\u064a \u062a\u0649\u0644" },
            { "NI", "\u0646\u0649\u0643\u0627\u0631\u0627\u06af\u06c7\u0626\u0627" },
            { "Hmng", metaValue_hmn },
            { "NL", "\u06af\u0648\u0644\u0644\u0627\u0646\u062f\u0649\u064a\u06d5" },
            { "NO", "\u0646\u0648\u0631\u06cb\u06d0\u06af\u0649\u064a\u06d5" },
            { "NP", "\u0646\u06d0\u067e\u0627\u0644" },
            { "NR", "\u0646\u0627\u06cb\u0631\u06c7" },
            { "NU", "\u0646\u064a\u06c7\u0626\u06d0" },
            { "Phnx", "\u0641\u0649\u0646\u0649\u0643\u0686\u06d5" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648\u0686\u06d5" },
            { "tsi", "\u0633\u0649\u0645\u0634\u064a\u0627\u0646\u0686\u06d5" },
            { "NZ", "\u064a\u06d0\u06ad\u0649 \u0632\u06d0\u0644\u0627\u0646\u062f\u0649\u064a\u06d5" },
            { "Merc", "\u0645\u06d0\u062a\u0631\u0648\u0626\u0649\u062a \u064a\u0627\u0632\u0645\u0649\u0686\u06d5" },
            { "rom", "\u0633\u0649\u06af\u0627\u0646\u0686\u06d5" },
            { "Mero", "\u0645\u06d0\u062a\u0631\u0648\u0626\u0649\u062a" },
            { "crh", "\u0642\u0649\u0631\u0649\u0645 \u062a\u06c8\u0631\u0643\u0686\u06d5" },
            { "ang", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "OM", "\u0626\u0648\u0645\u0627\u0646" },
            { "anp", "\u0626\u0627\u0646\u06af\u0649\u0643\u0627\u0686\u06d5" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "type.ca.islamic-civil", "\u0626\u0649\u0633\u0644\u0627\u0645 \u06be\u0649\u062c\u0631\u0649\u064a\u06d5 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649 (\u0645\u06d5\u062f\u0649\u0646\u06d5)" },
            { "csb", "\u0643\u0627\u0633\u0632\u06c7\u0628\u0649\u0686\u06d5" },
            { "en_GB", "\u0626\u06d5\u0646\u06af\u0644\u0649\u064a\u06d5 \u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "PE", "\u067e\u06d0\u0631\u06c7" },
            { "PF", "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5\u06af\u06d5 \u0642\u0627\u0631\u0627\u0634\u0644\u0649\u0642 \u067e\u0648\u0644\u0649\u0646\u06d0\u0632\u0649\u064a\u06d5" },
            { "PG", "\u067e\u0627\u067e\u06c7\u0626\u0627 \u064a\u06d0\u06ad\u0649 \u06af\u0649\u06cb\u0649\u0646\u0649\u064a\u06d5\u0633\u0649" },
            { "PH", "\u0641\u0649\u0644\u0649\u067e\u067e\u0649\u0646" },
            { "PK", "\u067e\u0627\u0643\u0649\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u0634\u0627" },
            { "ewo", "\u0626\u06d0\u06cb\u0648\u0646\u062f\u0648\u0686\u06d5" },
            { "PM", "\u0633\u0627\u064a\u0646\u062a \u067e\u0649\u064a\u06d0\u0631 \u06cb\u06d5 \u0645\u0649\u0643\u06d0\u0644\u0648\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "PN", "\u067e\u0649\u062a\u0643\u0627\u064a\u0631\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "PR", "\u067e\u06c7\u0626\u06d0\u0631\u062a\u0648 \u0631\u0649\u0643\u0648" },
            { "PS", "\u067e\u06d5\u0644\u06d5\u0633\u062a\u0649\u0646 \u0632\u06d0\u0645\u0649\u0646\u0649" },
            { "Bali", "\u0628\u0627\u0644\u0649" },
            { "PT", "\u067e\u0648\u0631\u062a\u06c7\u06af\u0627\u0644\u0649\u064a\u06d5" },
            { "PW", "\u067e\u0627\u0644\u0627\u0626\u06c7" },
            { "nia", "\u0646\u0649\u0626\u0627\u0633\u0686\u06d5" },
            { "type.nu.greklow", "\u06af\u0649\u0631\u06d0\u0643\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631 (\u0643\u0649\u0686\u0649\u0643 \u06be\u06d5\u0631\u067e)" },
            { "PY", "\u067e\u0627\u0631\u0627\u06af\u06cb\u0627\u064a" },
            { "tum", "\u062a\u06c7\u0645\u0628\u06c7\u0643\u0627\u0686\u06d5" },
            { "Hebr", "\u0626\u0649\u0628\u0631\u0627\u0646\u0649\u0686\u06d5" },
            { "QA", "\u0642\u0627\u062a\u0627\u0631" },
            { "%%SCOTLAND", "\u0634\u0648\u062a\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "niu", "\u0646\u064a\u06c7\u0626\u06d0\u0686\u06d5" },
            { "QO", "\u0626\u0648\u0643\u064a\u0627\u0646\u0649\u064a\u06d5 \u0626\u06d5\u062a\u0631\u0627\u067e\u0649\u062f\u0649\u0643\u0649 \u0626\u0627\u0631\u0627\u0644\u0644\u0627\u0631" },
            { "lez", "\u0644\u06d0\u0632\u06af\u0649\u0646\u0686\u06d5" },
            { "%%FONUPA", "UPA \u062a\u0627\u06cb\u06c7\u0634\u0644\u0649\u0631\u0649" },
            { "type.nu.takr", "\u062a\u0627\u0643\u0631\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "tvl", "\u062a\u06c7\u06cb\u0627\u0644\u06c7\u0686\u06d5" },
            { "Tavt", "\u062a\u0627\u064a\u0644\u0627\u0646\u062f\u0686\u06d5-\u06cb\u0649\u064a\u06d0\u062a\u0646\u0627\u0645\u0686\u06d5" },
            { "001", "\u062f\u06c7\u0646\u064a\u0627" },
            { "002", "\u0626\u0627\u0641\u0631\u0649\u0642\u0627" },
            { "003", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627" },
            { "RE", "\u0631\u06d0\u064a\u06c7\u0646\u0649\u064a\u0648\u0646" },
            { "005", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627" },
            { "jbo", "\u0644\u0648\u062c\u0628\u0627\u0646\u0686\u06d5" },
            { "Rjng", "\u0631\u06d0\u062c\u0627\u06ad\u0686\u06d5" },
            { "009", "\u0626\u0648\u0643\u064a\u0627\u0646\u0649\u064a\u06d5" },
            { "RO", "\u0631\u0648\u0645\u0649\u0646\u0649\u064a\u06d5" },
            { "RS", "\u0633\u06d0\u0631\u0628\u0649\u064a\u06d5" },
            { "Mroo", "\u0645\u0631\u0648\u0686\u06d5" },
            { "RU", "\u0631\u06c7\u0633\u0649\u064a\u06d5" },
            { "RW", "\u0631\u0649\u06cb\u0627\u0646\u062f\u0627" },
            { "type.nu.talu", "\u064a\u06d0\u06ad\u0649 \u062a\u0627\u064a-\u0644\u06d5\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "%%METELKO", "\u0645\u06d0\u062a\u06d0\u0644\u0643\u0648 \u0626\u06d0\u0644\u0649\u067e\u0628\u06d5\u0633\u0649" },
            { "Ugar", metaValue_uga },
            { "Mani", "\u0645\u0627\u0646\u06d5\u0643\u06d0\u0632\u06d5\u0645\u0686\u06d5" },
            { "Khar", "\u0643\u0627\u0631\u0648\u0634\u062a\u0649\u0686\u06d5" },
            { "SA", "\u0633\u06d5\u0626\u06c7\u062f\u0649\u064a \u0626\u06d5\u0631\u06d5\u0628\u0649\u0633\u062a\u0627\u0646" },
            { "pon", "\u067e\u0648\u0646\u0627\u067e\u06d0\u0626\u0627\u0646\u0686\u06d5" },
            { "Mand", "\u0645\u0627\u0646\u062f\u0627\u0626\u0649\u0643\u0686\u06d5" },
            { "SB", "\u0633\u0648\u0644\u0648\u0645\u0648\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "twq", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0633\u0648\u06ad\u062e\u0627\u064a\u0686\u06d5" },
            { "011", "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627" },
            { "SC", "\u0633\u06d0\u064a\u0634\u06d0\u0644" },
            { "SD", "\u0633\u06c7\u062f\u0627\u0646" },
            { "013", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627" },
            { "SE", "\u0634\u0649\u06cb\u06d0\u062a\u0633\u0649\u064a\u06d5" },
            { "014", "\u0634\u06d5\u0631\u0642\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627" },
            { "arc", "\u0626\u0627\u0631\u0627\u0645\u06c7\u0686\u06d5" },
            { "Loma", "\u0644\u0648\u0645\u0627\u0686\u06d5" },
            { "015", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627" },
            { "SG", "\u0633\u0649\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "SH", "\u0633\u0627\u064a\u0646\u0649\u062a \u06be\u06d0\u0644\u06d0\u0646\u0627" },
            { "017", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u0627\u0641\u0631\u0649\u0642\u0627" },
            { "SI", "\u0633\u0649\u0644\u0648\u06cb\u06d0\u0646\u0649\u064a\u06d5" },
            { "018", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627 \u0631\u0627\u064a\u0648\u0646\u0649" },
            { "SJ", "\u0633\u0649\u06cb\u0627\u0644\u0628\u0627\u0631\u062f \u06cb\u06d5 \u064a\u0627\u0646 \u0645\u0627\u064a\u06d0\u0646" },
            { "019", "\u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627" },
            { "SK", "\u0633\u0649\u0644\u0648\u06cb\u0627\u0643\u0649\u064a\u06d5" },
            { "Bamu", "\u0628\u0627\u0645\u06c7\u0645" },
            { "Wole", "\u06cb\u0648\u0644\u0649\u0626\u0627\u064a" },
            { "SL", "\u0633\u06d0\u0631\u0631\u0627\u0644\u06d0\u0626\u0648\u0646" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u0649\u0646\u0648" },
            { "SN", "\u0633\u06d0\u0646\u06d0\u06af\u0627\u0644" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u0649" },
            { "arn", "\u0645\u0627\u067e\u06c7\u062f\u06c7\u0646\u06af\u06c7\u0646\u0686\u06d5" },
            { "arp", "\u0626\u0627\u0631\u0627\u067e\u0627\u062e\u0648\u0686\u06d5" },
            { "type.nu.taml", "\u0626\u06d5\u0646\u0626\u06d5\u0646\u0649\u06cb\u0649 \u062a\u0627\u0645\u0649\u0644\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "SR", "\u0633\u06c7\u0631\u0649\u0646\u0627\u0645" },
            { "SS", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0633\u06c7\u062f\u0627\u0646" },
            { "ST", "\u0633\u0627\u0646 \u062a\u0648\u0645\u06d0 \u06cb\u06d5 \u067e\u0631\u0649\u0646\u0633\u0649\u067e\u06d0" },
            { "SV", "\u0633\u0627\u0644\u06cb\u0627\u062f\u0648\u0631" },
            { "SX", "\u0633\u0649\u0646\u062a \u0645\u0627\u0631\u062a\u06d0\u0646" },
            { "SY", "\u0633\u06c7\u0631\u0649\u064a\u06d5" },
            { "yao", "\u064a\u0627\u06cb\u0686\u06d5" },
            { "SZ", "\u0633\u0649\u06cb\u06d0\u0632\u0649\u0644\u0627\u0646\u062f" },
            { "arw", "\u0626\u0627\u0631\u0627\u06cb\u0627\u0643\u0686\u06d5" },
            { "yap", "\u064a\u0627\u067e\u0686\u06d5" },
            { "TA", "\u062a\u0631\u0649\u0633\u062a\u0627\u0646 \u062f\u0627\u0643\u06c7\u0646\u06be\u0627" },
            { "asa", "\u0626\u0627\u0633\u06c7\u0686\u06d5" },
            { "021", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u0631\u0627\u064a\u0648\u0646\u0649" },
            { "TC", "\u062a\u06c7\u0631\u0643\u0633 \u06cb\u06d5 \u0643\u0627\u064a\u0643\u0648\u0633 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "yav", "\u064a\u0627\u06ad\u0628\u06d5\u0646\u0686\u06d5" },
            { "TD", "\u0686\u0627\u062f" },
            { "TF", "\u0641\u0649\u0631\u0627\u0646\u0633\u0649\u064a\u06d5\u0646\u0649\u06ad \u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0632\u06d0\u0645\u0649\u0646\u0649" },
            { "TG", "\u062a\u0648\u06af\u0648" },
            { "TH", "\u062a\u0627\u064a\u0644\u0627\u0646\u062f" },
            { "TJ", "\u062a\u0627\u062c\u0649\u0643\u0649\u0633\u062a\u0627\u0646" },
            { "029", "\u0643\u0627\u0631\u0649\u0628 \u062f\u06d0\u06ad\u0649\u0632\u0649" },
            { "TK", "\u062a\u0648\u0643\u06d0\u0644\u0627\u06cb" },
            { "TL", "\u0634\u06d5\u0631\u0642\u0649\u064a \u062a\u0649\u0645\u0648\u0631" },
            { "ybb", "\u064a\u06d0\u0645\u0628\u0627\u0686\u06d5" },
            { "type.co.searchjl", "\u0643\u0648\u0631\u0649\u064a\u06d5\u0686\u06d5 \u0626\u06c8\u0632\u06c8\u0643 \u062a\u0627\u06cb\u06c7\u0634 \u0628\u0648\u064a\u0649\u0686\u06d5 \u0626\u0649\u0632\u062f\u06d5\u0634" },
            { "TM", "\u062a\u06c8\u0631\u0643\u0645\u06d5\u0646\u0649\u0633\u062a\u0627\u0646" },
            { "%%BOONT", "\u0628\u06c7\u0646\u062a\u0644\u0649\u06ad\u0686\u06d5" },
            { "TN", "\u062a\u06c7\u0646\u0649\u0633" },
            { "TO", "\u062a\u0648\u0646\u06af\u0627" },
            { "%%NULIK", "\u0632\u0627\u0645\u0627\u0646\u0649\u06cb\u0649 \u06cb\u0648\u0644\u0627\u067e\u06c7\u0643\u0686\u06d5" },
            { "TR", "\u062a\u06c8\u0631\u0643\u0649\u064a\u06d5" },
            { "TT", "\u062a\u0649\u0631\u0649\u0646\u0649\u062f\u0627\u062f \u06cb\u06d5 \u062a\u0648\u0628\u0627\u06af\u0648" },
            { "TV", "\u062a\u06c7\u06cb\u0627\u0644\u06c7" },
            { "TW", "\u062a\u06d5\u064a\u06cb\u06d5\u0646" },
            { "ast", "\u0626\u0627\u0633\u062a\u06c7\u0631\u0649\u064a\u06d5\u0686\u06d5" },
            { "Orkh", "\u0626\u0648\u0631\u062e\u06c7\u0646\u0686\u06d5" },
            { "TZ", "\u062a\u0627\u0646\u0632\u0627\u0646\u0649\u064a\u06d5" },
            { "nmg", "\u0643\u06cb\u0627\u0633\u0649\u064a\u0648\u0686\u06d5" },
            { "Zzzz", "\u064a\u0648\u0686\u06c7\u0646 \u064a\u06d0\u0632\u0649\u0642" },
            { "Sind", "\u0643\u06c7\u062f\u0627\u06cb\u0627\u062f\u0686\u06d5" },
            { "UA", "\u0626\u06c7\u0643\u0631\u0627\u0626\u0649\u0646\u0627" },
            { "rup", "\u0626\u0627\u0631\u0648\u0645\u0627\u0646\u0686\u06d5" },
            { "030", "\u0634\u06d5\u0631\u0642\u0649\u064a \u0626\u0627\u0633\u0649\u064a\u0627" },
            { "tyv", "\u062a\u0648\u06cb\u0627\u0686\u06d5" },
            { "sw_CD", "\u0643\u0648\u0646\u06af\u0648 \u0633\u0649\u06cb\u0627\u0644\u0649\u0686\u06d5" },
            { "034", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0626\u0627\u0633\u0649\u064a\u0627" },
            { "hai", "\u06be\u06d5\u064a\u062f\u06d5\u0686\u06d5" },
            { "035", "\u0634\u06d5\u0631\u0642\u0649\u064a \u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0626\u0627\u0633\u0649\u064a\u0627" },
            { "UG", "\u0626\u06c7\u06af\u0627\u0646\u062f\u0627" },
            { "type.co.pinyin", "\u067e\u0649\u0646\u064a\u0649\u0646 \u062a\u0649\u0632\u0649\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "039", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627" },
            { "Sinh", "\u0633\u0649\u0646\u062e\u0627\u0644\u0627\u0686\u06d5" },
            { "UM", "\u0626\u0627 \u0642 \u0634 \u062a\u0627\u0634\u0642\u0649 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "US", "\u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u0642\u0648\u0634\u0645\u0627 \u0626\u0649\u0634\u062a\u0627\u062a\u0644\u0649\u0631\u0649" },
            { "haw", "\u06be\u0627\u06cb\u0627\u064a\u0686\u06d5" },
            { "%%1959ACAD", "\u0626\u0627\u0643\u0627\u062f\u06d0\u0645\u0649\u0643" },
            { "type.co.gb2312han", "\u0626\u0627\u062f\u062f\u0649\u064a \u062e\u06d5\u0646\u0686\u06d5 \u062a\u0649\u0632\u0649\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649 - GB2312" },
            { "UY", "\u0626\u06c7\u0631\u06c7\u06af\u06cb\u0627\u064a" },
            { "UZ", "\u0626\u06c6\u0632\u0628\u06d0\u0643\u0649\u0633\u062a\u0627\u0646" },
            { "tzm", "\u0645\u06d5\u0631\u0643\u0649\u0632\u0649\u064a \u0626\u0627\u062a\u0644\u0627\u0633 \u062a\u0627\u0645\u0627\u0632\u0627\u064a\u062a\u0686\u06d5" },
            { "type.co.stroke", "\u0633\u0649\u0632\u0649\u0642 \u0628\u0648\u064a\u0649\u0686\u06d5 \u062a\u06d5\u0631\u062a\u0649\u067e\u0644\u06d5\u0634" },
            { "nnh", "\u0646\u06af\u06d0\u0645\u0628\u06c7\u0646\u0686\u06d5" },
            { "VA", "\u06cb\u0627\u062a\u0649\u0643\u0627\u0646" },
            { "pro", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u067e\u0631\u0648\u06cb\u06d0\u0646\u0686\u0627\u0644\u0686\u06d5" },
            { "VC", "\u0633\u0627\u064a\u0646\u062a \u06cb\u0649\u0646\u0633\u06d0\u0646\u062a \u06cb\u06d5 \u06af\u0649\u0631\u06d0\u0646\u0627\u062f\u0649\u0646\u06d0\u0633" },
            { "VE", "\u06cb\u06d0\u0646\u06d0\u0633\u06c7\u0626\u06d0\u0644\u0627" },
            { "VG", "\u0626\u06d5\u0646\u06af\u0644\u0649\u064a\u06d5 \u06cb\u0649\u0631\u06af\u0649\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "VI", "\u0626\u0627 \u0642 \u0634 \u06cb\u0649\u0631\u06af\u0649\u0646 \u0626\u0627\u0631\u0627\u0644\u0644\u0649\u0631\u0649" },
            { "VN", "\u06cb\u0649\u064a\u06d0\u062a\u0646\u0627\u0645" },
            { "VU", "\u06cb\u0627\u0646\u06c7\u0626\u0627\u062a\u06c7" },
            { "nog", "\u0646\u0648\u063a\u0627\u064a\u0686\u06d5" },
            { "rwk", "\u0631\u0649\u06cb\u0627\u0686\u06d5" },
            { "non", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0646\u0648\u0631\u06cb\u06d0\u06af\u0686\u06d5" },
            { "053", "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0626\u0627\u0633\u0649\u064a\u0627" },
            { "%%AREVMDA", "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u06d5\u0631\u0645\u06d5\u0646\u0686\u06d5" },
            { "054", "\u0645\u06d0\u0644\u0627\u0646\u06d0\u0633\u0649\u064a\u06d5" },
            { "WF", "\u06cb\u0627\u0644\u0644\u0649\u0633 \u06cb\u06d5 \u0641\u06c7\u062a\u06c7\u0646\u0627" },
            { "type.co.traditional", "\u0626\u06d5\u0646\u0626\u06d5\u0646\u0649\u06cb\u0649 \u062a\u06d5\u0631\u062a\u0649\u067e\u0644\u06d5\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "057", "\u0645\u0649\u0643\u0631\u0648\u0646\u06d0\u0632\u0649\u064a\u06d5 \u0631\u0627\u064a\u0648\u0646\u0649" },
            { "jgo", "\u0646\u06af\u0648\u0645\u0628\u0627\u0686\u06d5" },
            { "%%HEPBURN", "\u062e\u06d0\u067e\u0628\u06c7\u0631\u0646 \u0644\u0627\u062a\u0649\u0646\u0644\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634" },
            { "wae", "\u06cb\u0627\u0644\u0633\u06d0\u0631\u0686\u06d5" },
            { "WS", "\u0633\u0627\u0645\u0648\u0626\u0627" },
            { "Bass", "\u0628\u0627\u0633\u0633\u0627" },
            { "type.nu.mtei", "\u0645\u0627\u0646\u0649\u067e\u06c7\u0631\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "wal", "\u06cb\u0648\u0644\u0627\u064a\u062a\u0627\u0686\u06d5" },
            { "was", "\u06cb\u0627\u0634\u0648\u0686\u06d5" },
            { "war", "\u06cb\u0627\u0631\u0627\u064a\u0686\u06d5" },
            { "awa", "\u0626\u0627\u06cb\u0627\u062f\u0649\u0686\u06d5" },
            { "061", "\u067e\u0648\u0644\u0649\u0646\u0649\u0632\u0649\u064a\u06d5" },
            { "%%KSCOR", "\u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "XK", "\u0643\u0648\u0633\u0648\u06cb\u0648" },
            { "type.nu.brah", "\u0628\u0649\u0631\u0627\u062e\u0645\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u064a\u06d0\u0632\u0649\u0644\u0645\u0649\u063a\u0627\u0646" },
            { "Olck", "\u0626\u0648\u0644-\u0686\u0649\u0643\u0649\u0686\u06d5" },
            { "Batk", "\u0628\u0627\u062a\u0627\u0643" },
            { "Blis", metaValue_zbl },
            { "YE", "\u064a\u06d5\u0645\u06d5\u0646" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u062a\u06d5\u0631\u062a\u0649\u067e\u0644\u06d5\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "fan", "\u0641\u0627\u06ad\u0686\u06d5" },
            { "%%ROZAJ", "\u0631\u06d0\u0633\u0649\u064a\u0627\u0646" },
            { "fat", "\u0641\u0627\u0646\u062a\u0649\u0686\u06d5" },
            { "Sgnw", "\u0626\u0649\u0634\u0627\u0631\u06d5\u062a \u062a\u0649\u0644\u0649" },
            { "YT", "\u0645\u0627\u064a\u0648\u062a\u0649" },
            { "type.nu.cham", "\u0686\u0627\u0645\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "ZA", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0626\u0627\u0641\u0631\u0649\u0642\u0627" },
            { "type.nu.sund", "\u0633\u06c7\u0646\u062f\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Deva", "\u062f\u06d0\u06cb\u0627\u0646\u0627\u06af\u0627\u0631\u0649" },
            { "type.nu.geor", "\u06af\u0649\u0631\u06c7\u0632\u0649\u0646\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "type.co.zhuyin", "\u062a\u0631\u0627\u0646\u0633\u0643\u0631\u0649\u067e\u0633\u0649\u064a\u06d5 \u062a\u06d5\u0631\u062a\u0649\u067e\u0644\u06d5\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "Hira", "\u062e\u0649\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u0649\u064a\u06d5" },
            { "%%PINYIN", "\u067e\u0649\u0646\u064a\u0649\u0646 \u0644\u0627\u062a\u0649\u0646\u0644\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634" },
            { "ZW", "\u0632\u0649\u0645\u0628\u0627\u0628\u06cb\u06d0" },
            { "ZZ", "\u064a\u0648\u0686\u06c7\u0646 \u062c\u0627\u064a" },
            { "Runr", "\u0631\u06c7\u0646\u0649\u0643\u0686\u06d5" },
            { "type.ca.iso8601", "ISO-8601 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "lol", "\u0645\u0648\u0646\u06af\u0648\u0686\u06d5" },
            { "nso", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0633\u0648\u062a\u0648\u0686\u06d5" },
            { "type.nu.telu", "\u062a\u06d0\u0644\u06c7\u06af\u06c7\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "loz", "\u0644\u0648\u0632\u0649\u0686\u06d5" },
            { "Nkgb", "\u0646\u0627\u0634\u0649\u0686\u06d5" },
            { "jmc", "\u0645\u0627\u0686\u0627\u0645\u0686\u06d5" },
            { "type.nu.hansfin", "\u0626\u0627\u062f\u062f\u0649\u064a \u062e\u06d5\u0646\u0686\u06d5 \u067e\u06c7\u0644-\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "hil", "\u062e\u0649\u0644\u0649\u06af\u0627\u064a\u0646\u0648\u0646\u0686\u06d5" },
            { "type.nu.arabext", "\u0643\u06d0\u06ad\u06d5\u064a\u062a\u0649\u0644\u06af\u06d5\u0646 \u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5-\u06be\u0649\u0646\u062f\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "nus", "\u0645\u06c7\u0626\u06d0\u0631\u0686\u06d5" },
            { "dak", "\u062f\u0627\u0643\u0648\u062a\u0627\u0686\u06d5" },
            { "type.nu.fullwide", "\u062a\u0648\u0644\u06c7\u0642 \u0643\u06d5\u06ad\u0644\u0649\u0643\u062a\u0649\u0643\u0649 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "hit", "\u062e\u0649\u062a\u062a\u0649\u062a\u0686\u06d5" },
            { "dar", "\u062f\u0627\u0631\u06af\u0649\u06cb\u0627\u0686\u06d5" },
            { "dav", "\u062a\u0627\u064a\u062a\u0627\u0686\u06d5" },
            { "Maya", "\u0645\u0627\u064a\u0627\u0686\u06d5 \u062a\u06d5\u0633\u06cb\u0649\u0631\u0649\u064a \u064a\u06d0\u0632\u0649\u0642" },
            { "Copt", "\u0643\u0648\u067e\u062a\u0649\u0643" },
            { "nwc", "\u0646\u06d0\u06cb\u0627\u0631\u0686\u06d5" },
            { "udm", "\u0626\u06c7\u062f\u0645\u06c7\u0631\u062a\u0686\u06d5" },
            { "Khmr", "\u0643\u06d0\u062e\u0645\u06d0\u0631\u0686\u06d5" },
            { "type.ca.islamic-rgsa", "\u0626\u0649\u0633\u0644\u0627\u0645 \u06be\u0649\u062c\u0631\u0649\u064a\u06d5 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649 (\u0633\u06d5\u0626\u06c7\u062f\u0649 \u0626\u06d5\u0631\u06d5\u0628\u0649\u0633\u062a\u0627\u0646 \u0626\u0627\u064a)" },
            { "Limb", "\u0644\u0649\u0645\u0628\u06c7\u0686\u06d5" },
            { "sad", "\u0633\u0627\u0646\u062f\u0627\u06cb\u06d0\u0686\u06d5" },
            { "type.nu.roman", "\u0631\u0649\u0645 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "sah", "\u0633\u0627\u062e\u0627\u0686\u06d5" },
            { "type.nu.shrd", "\u0634\u0627\u0631\u0627\u062f\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "sam", "\u0633\u0627\u0645\u0627\u0631\u0649\u062a\u0627\u0646\u0686\u06d5" },
            { "%%SCOUSE", "\u0633\u0649\u0643\u0627\u06cb\u06c7\u0632" },
            { "saq", "\u0633\u0627\u0645\u0628\u06c7\u0631\u06c7\u0686\u06d5" },
            { "sas", "\u0633\u0627\u0633\u0627\u0643\u0686\u06d5" },
            { "sat", "\u0633\u0627\u0646\u062a\u0627\u0644\u0686\u06d5" },
            { "Tfng", "\u062a\u0649\u0641\u0649\u0646\u0627\u063a\u0686\u06d5" },
            { "jpr", "\u0626\u0649\u0628\u0631\u0627\u0646\u0649 \u067e\u0627\u0631\u0633\u0686\u06d5" },
            { "sba", "\u0646\u06af\u0627\u0645\u0628\u0627\u064a\u0686\u06d5" },
            { "Guru", "\u06af\u06c7\u0631\u0645\u06c7\u0643\u0649\u0686\u06d5" },
            { "%%ALUKU", "\u0626\u0627\u0644\u06c7\u0643\u06c7 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "lua", "\u0644\u06c7\u0628\u0627-\u0644\u06c7\u0626\u0627\u0686\u06d5" },
            { "sbp", "\u0633\u0627\u0646\u06af\u06c7\u0686\u06d5" },
            { "lui", "\u0644\u06c7\u064a\u0633\u06d0\u0646\u06af\u0648\u0686\u06d5" },
            { "nyn", "\u0646\u0649\u064a\u0627\u0646\u0643\u0648\u0644\u06d0\u0686\u06d5" },
            { "nym", "\u0646\u064a\u0627\u0645\u06cb\u06d0\u0632\u0649\u0686\u06d5" },
            { "lun", "\u0644\u06c7\u0646\u062f\u0627\u0686\u06d5" },
            { "nyo", "\u0646\u0649\u0626\u0648\u0631\u0648\u0686\u06d5" },
            { "luo", "\u0644\u06c7\u0626\u0648\u0686\u06d5" },
            { "hmn", metaValue_hmn },
            { "fil", "\u0641\u0649\u0644\u0649\u067e\u067e\u0649\u0646\u0686\u06d5" },
            { "del", "\u062f\u06d0\u0644\u0627\u06cb\u0627\u0631\u06d0\u0686\u06d5" },
            { "lus", "\u0645\u0649\u0632\u0648\u0686\u06d5" },
            { "bal", "\u0628\u06d0\u0644\u06c7\u062c\u0649\u0686\u06d5" },
            { "den", "\u0633\u0644\u0627\u06cb\u0686\u06d5" },
            { "uga", metaValue_uga },
            { "ban", "\u0628\u0627\u0644\u0649\u0686\u06d5" },
            { "luy", "\u0644\u06c7\u064a\u0627\u0686\u06d5" },
            { "bas", "\u0628\u0627\u0633\u0627\u0686\u06d5" },
            { "bax", "\u0628\u0627\u0645\u06c7\u0646\u0686\u06d5" },
            { "jrb", "\u0626\u0649\u0628\u0631\u0627\u0646\u0649 \u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5" },
            { "es_ES", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u0626\u0649\u0633\u067e\u0627\u0646\u0686\u06d5" },
            { "nzi", "\u0646\u0649\u0632\u06d5\u0645\u0627\u0686\u06d5" },
            { "sco", "\u0634\u0648\u062a\u0644\u0627\u0646\u062f\u0649\u064a\u06d5\u0686\u06d5" },
            { "scn", "\u0633\u0649\u062a\u0633\u0649\u0644\u0649\u064a\u06d5\u0686\u06d5" },
            { "aa", "\u0626\u0627\u0641\u0627\u0631\u0686\u06d5" },
            { "ab", "\u0626\u0627\u0628\u062e\u0627\u0632\u0686\u06d5" },
            { "ae", "\u0626\u0627\u06cb\u06d0\u0633\u062a\u0627\u0686\u06d5" },
            { "af", "\u0626\u0627\u0641\u0631\u0649\u0643\u0627\u0646\u0686\u06d5" },
            { "ak", "\u0626\u0627\u0643\u0627\u0646\u0686\u06d5" },
            { "type.nu.cakm", "\u0686\u0627\u0643\u0645\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "bbj", "\u06af\u0648\u0645\u0627\u0644\u0627\u0686\u06d5" },
            { "am", "\u0626\u0627\u0645\u06be\u0627\u0631\u0686\u06d5" },
            { "an", "\u0626\u0627\u0631\u0627\u06af\u0648\u0646\u0686\u06d5" },
            { "Arab", "\u0626\u06d5\u0631\u06d5\u0628" },
            { "%%SOLBA", "\u0633\u0649\u062a\u0648\u0644\u06cb\u0649\u0632\u0632\u0627/\u0633\u0648\u0644\u0628\u0649\u0643\u0627 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "Jpan", metaValue_ja },
            { "ar", "\u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5" },
            { "Hrkt", "\u064a\u0627\u067e\u0648\u0646\u0686\u06d5 \u062e\u0649\u0631\u0627\u06af\u0627\u0646\u0627 \u064a\u0627\u0643\u0649 \u0643\u0627\u062a\u0627\u0643\u0627\u0646\u0627" },
            { "as", "\u0626\u0627\u0633\u0627\u0645\u0686\u06d5" },
            { "Lina", "\u0633\u0649\u0632\u0649\u0642\u0644\u0649\u0642 A" },
            { "av", "\u0626\u0627\u06cb\u0627\u0631\u0686\u06d5" },
            { "Linb", "\u0633\u0649\u0632\u0649\u0642\u0644\u0649\u0642 B" },
            { "ay", "\u0626\u0627\u064a\u0645\u0627\u0631\u0627\u0686\u06d5" },
            { "az", "\u0626\u06d5\u0632\u06d5\u0631\u0628\u06d5\u064a\u062c\u0627\u0646\u0686\u06d5" },
            { "Khoj", "\u062e\u0648\u062c\u0643\u0649\u0686\u06d5" },
            { "%%OSOJS", "\u0626\u0648\u0633\u06d0\u0626\u0627\u0643\u0643\u0648/\u0626\u0648\u0633\u0648\u062c\u06d5\u0646 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "ba", "\u0628\u0627\u0634\u0642\u0649\u0631\u062a\u0686\u06d5" },
            { "type.co.unihan", "\u064a\u0627\u0646 \u0628\u06c6\u0644\u06d5\u0643 \u0633\u0649\u0632\u0649\u0642 \u0628\u0648\u064a\u0686\u06d5 \u062a\u06d5\u0631\u062a\u0649\u067e\u0644\u06d5\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "be", "\u0628\u06d0\u0644\u0627\u0631\u06c7\u0633\u0686\u06d5" },
            { "bg", "\u0628\u06c7\u0644\u063a\u0627\u0631\u0686\u06d5" },
            { "bi", "\u0628\u0649\u0633\u0644\u0627\u0645\u0627\u0686\u06d5" },
            { "type.nu.java", "\u064a\u0627\u06cb\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "bm", "\u0628\u0627\u0645\u0628\u0627\u0631\u0627\u0686\u06d5" },
            { "bn", "\u0628\u06d0\u0646\u06af\u0627\u0644\u0686\u06d5" },
            { "bo", metaValue_bo },
            { "dgr", "\u062f\u0648\u06af\u0631\u0649\u0628\u0686\u06d5" },
            { "br", "\u0628\u0649\u0631\u06d0\u062a\u0648\u0646\u0686\u06d5" },
            { "bs", "\u0628\u0648\u0633\u0649\u0646\u0686\u06d5" },
            { "see", "\u0633\u06d0\u0643\u0646\u06d0\u0643\u0627\u0686\u06d5" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "\u0644\u0627\u0626\u0648\u0633\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "seh", "\u0633\u06d0\u0646\u0627\u0686\u06d5" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0633\u06d0\u0644\u0643\u0627\u067e\u0686\u06d5" },
            { "ca", "\u0643\u0627\u062a\u0627\u0644\u0627\u0646\u0686\u06d5" },
            { "ses", "\u0634\u06d5\u0631\u0642\u0649\u064a \u0633\u0648\u06ad\u062e\u0627\u064a\u0686\u06d5" },
            { "ce", "\u0686\u06d0\u0686\u0649\u0646\u0686\u06d5" },
            { "ch", "\u0686\u0627\u0645\u0648\u0631\u0631\u0648\u0686\u06d5" },
            { "%%REVISED", "\u062a\u06c8\u0632\u0649\u062a\u0649\u0644\u06af\u06d5\u0646 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "co", "\u0643\u0648\u0631\u0633\u06c7\u0686\u06d5" },
            { "Orya", "\u0626\u0648\u0631\u0649\u064a\u0627\u0686\u06d5" },
            { "cr", "\u0643\u0631\u0649\u0686\u06d5" },
            { "cs", "\u0686\u06d0\u062e\u0686\u06d5" },
            { "cu", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0633\u0644\u0627\u06cb\u064a\u0627\u0646\u0686\u06d5" },
            { "cv", "\u0686\u06c7\u06cb\u0627\u0634\u0686\u06d5" },
            { "cy", "\u06cb\u06d0\u0644\u0634\u0686\u06d5" },
            { "type.nu.ethi", "\u0626\u06d0\u0641\u0649\u064a\u0648\u067e\u0649\u064a\u06d5\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Yiii", "\u064a\u0649\u0686\u06d5" },
            { "da", "\u062f\u0627\u0646\u0649\u0634\u0686\u06d5" },
            { "pt_PT", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627 \u067e\u0648\u0631\u062a\u06c7\u06af\u0627\u0644\u0686\u06d5" },
            { "de", "\u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5" },
            { "bej", "\u0628\u06d0\u062c\u0627\u0686\u06d5" },
            { "din", "\u062f\u0649\u0646\u0643\u0627\u0686\u06d5" },
            { "Bugi", "\u0628\u06c7\u06af\u0649" },
            { "bem", "\u0628\u06d0\u0645\u0628\u0627\u0686\u06d5" },
            { "sga", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0626\u0649\u0631\u06d0\u0644\u0627\u0646\u062f\u0686\u06d5" },
            { "type.nu.mong", "\u0645\u0648\u06ad\u063a\u06c7\u0644\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "dv", "\u062f\u0649\u06cb\u06d0\u062e\u0686\u06d5" },
            { "es_419", "\u0644\u0627\u062a\u0649\u0646 \u0626\u0627\u0645\u06d0\u0631\u0649\u0643\u0627 \u0626\u0649\u0633\u067e\u0627\u0646\u0686\u06d5" },
            { "dz", "\u0632\u0648\u06ad\u062e\u0627\u0686\u06d5" },
            { "bez", "\u0628\u06d0\u0646\u0627\u0686\u06d5" },
            { "type.ca.chinese", "\u062f\u06d0\u06be\u0642\u0627\u0646\u0644\u0627\u0631 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "Lisu", "\u0641\u0631\u0627\u0633\u06d0\u0631\u0686\u06d5" },
            { "dje", "\u0632\u0627\u0631\u0645\u0627\u0686\u06d5" },
            { "type.nu.grek", "\u06af\u0649\u0631\u06d0\u0643\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "ee", "\u0626\u06d0\u06cb\u06d0\u0686\u06d5" },
            { "bfd", "\u0628\u0627\u0641\u06c7\u062a\u0686\u06d5" },
            { "el", metaValue_el },
            { "en", "\u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "eo", "\u0626\u06d0\u0633\u067e\u0631\u0627\u0646\u062a\u0648\u0686\u06d5" },
            { "type.co.big5han", "\u0645\u06c7\u0631\u06d5\u0643\u0643\u06d5\u067e \u062e\u06d5\u0646\u0686\u06d5 \u062a\u0649\u0632\u0649\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649 - Big5" },
            { "es", "\u0626\u0649\u0633\u067e\u0627\u0646\u0686\u06d5" },
            { "et", "\u0626\u06d0\u0633\u062a\u0648\u0646\u0686\u06d5" },
            { "eu", "\u0628\u0627\u0633\u0643\u0649\u0686\u06d5" },
            { "Buhd", "\u0628\u06c7\u062e\u0649\u062a" },
            { "Samr", "\u0633\u0627\u0645\u0627\u0631\u0649\u0686\u06d5" },
            { "shi", "\u0634\u0649\u0644\u062e\u0627\u0686\u06d5" },
            { "hsb", "\u0626\u06c8\u0633\u062a\u06c8\u0646 \u0633\u0648\u0631\u0628\u0686\u06d5" },
            { "Hani", "\u062e\u06d5\u0646\u0686\u06d5" },
            { "shn", "\u0634\u0627\u0646\u0686\u06d5" },
            { "Hano", "\u062e\u0627\u0646\u06c7\u0646\u06c7\u0686\u06d5" },
            { "fa", "\u067e\u0627\u0631\u0633\u0686\u06d5" },
            { "Hans", metaValue_Hans },
            { "type.nu.latn", "\u063a\u06d5\u0631\u0628\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Hant", metaValue_Hant },
            { "ff", "\u0641\u06c7\u0644\u0627\u06be\u0686\u06d5" },
            { "shu", "\u0686\u0627\u062f \u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5" },
            { "fi", "\u0641\u0649\u0646\u0686\u06d5" },
            { "fj", "\u0641\u0649\u062c\u0649\u0686\u06d5" },
            { "fon", "\u0641\u0648\u0646\u0686\u06d5" },
            { "yue", "\u06af\u06c7\u0627\u06ad\u062f\u0648\u06ad\u0686\u06d5" },
            { "fo", "\u0641\u0627\u0626\u06d0\u0631\u0648\u0686\u06d5" },
            { "umb", "\u0626\u06c7\u0645\u0628\u06c7\u0646\u062f\u06c7\u0686\u06d5" },
            { "fr", "\u0641\u0649\u0631\u0627\u0646\u0633\u06c7\u0632\u0686\u06d5" },
            { "sid", "\u0633\u0649\u062f\u0627\u0645\u0648\u0686\u06d5" },
            { "fy", "\u063a\u06d5\u0631\u0628\u0649\u064a \u0641\u0649\u0631\u0633\u0686\u06d5" },
            { "ga", "\u0626\u0649\u0631\u06d0\u0644\u0627\u0646\u062f\u0686\u06d5" },
            { "gd", "\u0634\u0648\u062a\u0644\u0627\u0646\u062f\u0649\u064a\u06d5 \u06af\u0627\u064a\u0644\u0686\u0649\u0633\u0649" },
            { "gl", "\u06af\u0627\u0644\u0649\u0686\u06d5" },
            { "gn", "\u06af\u06c7\u0626\u0627\u0631\u0627\u0646\u0649\u0686\u06d5" },
            { "bho", "\u0628\u0648\u062c\u067e\u06c7\u0631\u0649\u0686\u06d5" },
            { "und", "\u064a\u0648\u0686\u06c7\u0646 \u062a\u0649\u0644" },
            { "type.ca.ethiopic-amete-alem", "\u0626\u06d0\u0641\u0649\u064a\u0648\u067e\u0649\u064a\u06d5 \u0626\u0627\u0645\u06d0\u062a\u06d0 \u0626\u0627\u0644\u06d0\u0645 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u0626\u0649\u0633\u0644\u0627\u0645 \u06be\u0649\u062c\u0631\u0649\u064a\u06d5 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649 (\u0626\u0627\u0633\u062a\u0631\u0648\u0646\u0648\u0645\u0649\u064a\u06d5 \u062f\u06d5\u06cb\u0631\u0649)" },
            { "gv", "\u0645\u0627\u0646\u0686\u06d5" },
            { "type.nu.osma", "\u0626\u0648\u0633\u0645\u0627\u0646\u0649\u064a\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "ha", "\u062e\u0627\u0626\u06c7\u0633\u0627\u0686\u06d5" },
            { "he", "\u0626\u0649\u0628\u0631\u0627\u0646\u0649\u064a\u0686\u06d5" },
            { "hi", "\u06be\u0649\u0646\u062f\u0649\u0686\u06d5" },
            { "hup", "\u062e\u06c7\u067e\u0627\u0686\u06d5" },
            { "bik", "\u0628\u0649\u0643\u0648\u0644\u0686\u06d5" },
            { "bin", "\u0628\u0649\u0646\u0649\u0686\u06d5" },
            { "ho", "\u06be\u0649\u0631\u0649 \u0645\u0648\u062a\u06c7\u0686\u06d5" },
            { "hr", "\u0643\u0649\u0631\u0648\u062f\u0649\u0686\u06d5" },
            { "ht", "\u06be\u0627\u064a\u062a\u0649\u0686\u06d5" },
            { "hu", "\u06cb\u06d0\u0646\u06af\u0649\u0631\u0686\u06d5" },
            { "hy", "\u0626\u06d5\u0631\u0645\u06d0\u0646\u0686\u06d5" },
            { "hz", "\u062e\u06d0\u0631\u06d0\u0631\u0648\u0686\u06d5" },
            { "%%FONIPA", "IPA \u062a\u0627\u06cb\u06c7\u0634\u0644\u0649\u0631\u0649" },
            { "ia", "\u0626\u0627\u0631\u0649\u0644\u0649\u0642 \u062a\u0649\u0644" },
            { "id", "\u06be\u0649\u0646\u062f\u0648\u0646\u06d0\u0632\u0686\u06d5" },
            { "type.nu.tibt", "\u062a\u0649\u0628\u06d5\u062a\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "ie", "\u0626\u0649\u0646\u062a\u0649\u0631\u0644\u0649\u06ad\u0686\u06d5" },
            { "ig", "\u0626\u0649\u06af\u0628\u0648\u0686\u06d5" },
            { "ii", "\u064a\u0649\u0686\u06d5 (\u0633\u0649\u0686\u06c8\u06d5\u0646)" },
            { "frm", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u06d5\u0633\u0649\u0631 \u0641\u0649\u0631\u0627\u0646\u0633\u06c7\u0632\u0686\u06d5" },
            { "ik", "\u0626\u0649\u0646\u06c7\u067e\u0649\u0643\u0686\u06d5" },
            { "fro", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0641\u0649\u0631\u0627\u0646\u0633\u06c7\u0632\u0686\u06d5" },
            { "io", "\u0626\u0649\u062f\u0648\u0686\u06d5" },
            { "frs", "\u0634\u06d5\u0631\u0642\u0649 \u0641\u0649\u0631\u0649\u0632\u064a\u06d5\u0686\u06d5" },
            { "frr", "\u0634\u0649\u0645\u0627\u0644\u0649 \u0641\u0649\u0631\u0649\u0632\u064a\u06d5\u0686\u06d5" },
            { "is", "\u0626\u0649\u0633\u0644\u0627\u0646\u062f\u0686\u06d5" },
            { "it", "\u0626\u0649\u062a\u0627\u0644\u0649\u064a\u0627\u0646\u0686\u06d5" },
            { "iu", "\u0626\u0649\u0646\u06c7\u0643\u062a\u0649\u062a\u06c7\u062a\u0686\u06d5" },
            { "ja", metaValue_ja },
            { "Mlym", "\u0645\u0627\u0644\u0627\u064a\u0627\u0645\u0686\u06d5" },
            { "Sarb", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u062c\u06d5\u0646\u06c7\u0628\u0649 \u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5" },
            { "Sara", "\u0633\u0627\u0631\u0627\u062a\u0649\u0686\u06d5" },
            { "doi", "\u062f\u0648\u06af\u0631\u0649\u0686\u06d5" },
            { "type.nu.lepc", "\u0644\u06d5\u067e\u0686\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "bkm", "\u0643\u0648\u0645\u0686\u06d5" },
            { "sma", "\u062c\u06d5\u0646\u06c7\u0628\u0649\u064a \u0633\u0627\u0645\u0649\u0686\u06d5" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0634\u0627\u06cb\u0649\u064a\u0627\u0646\u0686\u06d5" },
            { "mad", "\u0645\u0627\u062f\u06c7\u0631\u06d0\u0633\u0686\u06d5" },
            { "smj", "\u0644\u06c7\u0644\u06d0 \u0633\u0627\u0645\u0649\u0686\u06d5" },
            { "mag", "\u0645\u0627\u06af\u0627\u062e\u0649\u0686\u06d5" },
            { "maf", "\u0645\u0627\u0641\u0627\u0686\u06d5" },
            { "mai", "\u0645\u0627\u064a\u062a\u0649\u0644\u0649\u0686\u06d5" },
            { "smn", "\u0626\u0649\u0646\u0627\u0631\u0649 \u0633\u0627\u0645\u0649\u0686\u06d5" },
            { "ka", "\u06af\u0649\u0631\u06c7\u0632\u0686\u06d5" },
            { "bla", "\u0633\u0649\u0643\u0633\u0649\u0643\u0627\u0686\u06d5" },
            { "mak", "\u0645\u0627\u0643\u0627\u0633\u0627\u0631\u0686\u06d5" },
            { "sms", "\u0633\u0643\u0648\u0644\u062a \u0633\u0627\u0645\u0649\u0686\u06d5" },
            { "man", "\u0645\u0627\u0646\u062f\u0649\u0646\u06af\u0648\u0686\u06d5" },
            { "kg", "\u0643\u0648\u0646\u06af\u0648\u0686\u06d5" },
            { "Goth", metaValue_got },
            { "ki", "\u0643\u0649\u0643\u06c7\u064a\u06c7\u0686\u06d5" },
            { "mas", "\u0645\u0627\u0633\u0627\u064a\u0686\u06d5" },
            { "kj", "\u0643\u0649\u06cb\u0627\u0646\u064a\u0627\u0645\u0627\u0686\u06d5" },
            { "kk", "\u0642\u0627\u0632\u0627\u0642\u0686\u06d5" },
            { "kl", "\u06af\u0649\u0631\u06d0\u0646\u0644\u0627\u0646\u062f\u0686\u06d5" },
            { "km", "\u0643\u0649\u0645\u06d0\u0631\u0686\u06d5" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u0643\u0627\u0646\u06c7\u0631\u0686\u06d5" },
            { "ks", "\u0643\u06d5\u0634\u0645\u0649\u0631\u0686\u06d5" },
            { "Cirt", "\u0643\u0649\u0631\u0633\u0686\u06d5" },
            { "Lepc", "\u0644\u06d5\u067e\u0686\u0627\u0686\u06d5" },
            { "Avst", "\u0626\u0627\u06cb\u06d0\u0633\u062a\u0627" },
            { "ku", "\u0643\u06c7\u0631\u062f\u0686\u06d5" },
            { "kv", "\u0643\u0648\u0645\u0649\u0686\u06d5" },
            { "kw", "\u0643\u0648\u0631\u0646\u0649\u0634\u0686\u06d5" },
            { "ky", "\u0642\u0649\u0631\u063a\u0649\u0632\u0686\u06d5" },
            { "snk", "\u0633\u0648\u0646\u0649\u0646\u0643\u06d5\u0686\u06d5" },
            { "la", metaValue_la },
            { "lb", "\u0644\u0649\u064a\u06c7\u0643\u0633\u06d0\u0645\u0628\u06c7\u0631\u06af\u0686\u06d5" },
            { "type.nu.mlym", "\u0645\u0627\u0644\u0627\u064a\u0627\u0644\u0627\u0645\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627\u0686\u06d5" },
            { "Roro", "\u0631\u0648\u06ad\u06af\u0648\u0631\u0648\u06ad\u06af\u0648" },
            { "li", "\u0644\u0649\u0645\u0628\u06c7\u0631\u06af\u0686\u06d5" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0644\u0649\u0646\u06af\u0627\u0644\u0627\u0686\u06d5" },
            { "fur", "\u0641\u0649\u0631\u0649\u0626\u06c7\u0644\u0649\u0686\u06d5" },
            { "lo", metaValue_lo },
            { "type.nu.lana", "\u062a\u0627\u064a \u062a\u0627\u0645\u0686\u06d5 \u062e\u0648\u0631\u0627 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "lt", "\u0644\u0649\u062a\u06cb\u0627\u0646\u0649\u0686\u06d5" },
            { "lu", "\u0644\u06c7\u0628\u0627-\u0643\u0627\u062a\u0627\u0646\u06af\u0627\u0686\u06d5" },
            { "lv", "\u0644\u0627\u062a\u0686\u06d5" },
            { "sog", "\u0633\u0648\u063a\u062f\u0649\u0686\u06d5" },
            { "ListCompositionPattern", "{0}\u060c {1}" },
            { "mg", "\u0645\u0627\u0644\u0627\u06af\u0627\u0633\u0686\u06d5" },
            { "mh", "\u0645\u0627\u0631\u0634\u0627\u0644\u0686\u06d5" },
            { "type.co.ducet", "\u0643\u06c6\u06ad\u06c8\u0644\u062f\u0649\u0643\u0649 \u064a\u06c7\u0646\u0649\u0643\u0648\u062f \u062a\u0649\u0632\u0649\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "mi", "\u0645\u0627\u06cb\u0631\u0649\u0686\u06d5" },
            { "mk", "\u0645\u0627\u0643\u06d0\u062f\u0648\u0646\u0686\u06d5" },
            { "ml", "\u0645\u0627\u0644\u0627\u064a\u0627\u0644\u0627\u0645\u0686\u06d5" },
            { "mn", metaValue_mn },
            { "mr", "\u0645\u0627\u0631\u0627\u062a\u0649\u0686\u06d5" },
            { "ms", "\u0645\u0627\u0644\u0627\u064a\u0686\u06d5" },
            { "mt", "\u0645\u0627\u0644\u062a\u0627\u0686\u06d5" },
            { "my", metaValue_my },
            { "Saur", "\u0633\u0627\u0626\u06c7\u0631\u0627\u0634\u062a\u0649\u0631\u0627\u0686\u06d5" },
            { "Armn", "\u0626\u06d5\u0631\u0645\u06d5\u0646" },
            { "mdf", "\u0645\u0648\u0643\u0634\u0627\u0686\u06d5" },
            { "mde", "\u0645\u0627\u0628\u0627\u0686\u06d5" },
            { "dsb", "\u062a\u06c6\u06cb\u06d5\u0646 \u0633\u0648\u0631\u0628\u0686\u06d5" },
            { "Armi", "\u062e\u0627\u0646 \u062c\u06d5\u0645\u06d5\u062a\u0649 \u0626\u0627\u0631\u0627\u0645\u06c7" },
            { "na", "\u0646\u0627\u06cb\u0631\u06c7\u0686\u06d5" },
            { "type.co.search", "\u0626\u0627\u062f\u06d5\u062a\u062a\u0649\u0643\u0649 \u0626\u0649\u0632\u062f\u06d5\u0634" },
            { "nb", "\u0646\u0648\u0631\u06cb\u0649\u06af\u0649\u064a\u06d5 \u0628\u0648\u0643\u0645\u0627\u0644\u0686\u06d5" },
            { "nd", "\u0634\u0649\u0645\u0627\u0644\u0649 \u0646\u062f\u06d5\u0628\u06d5\u0644\u06d5\u0686\u06d5" },
            { "ne", "\u0646\u06d0\u067e\u0627\u0644\u0686\u06d5" },
            { "ng", "\u0646\u062f\u0648\u0646\u06af\u0627\u0686\u06d5" },
            { "mdr", "\u0645\u0627\u0646\u062f\u0627\u0631\u0686\u06d5" },
            { "nl", "\u06af\u0648\u0644\u0644\u0627\u0646\u062f\u0686\u06d5" },
            { "nn", "\u064a\u06d0\u06ad\u0649 \u0646\u0648\u0631\u06cb\u06d0\u06af\u0686\u06d5" },
            { "no", "\u0646\u0648\u0631\u06cb\u06d0\u06af\u0686\u06d5" },
            { "nr", "\u062c\u06d5\u0646\u06c7\u0628\u0649 \u0646\u062f\u06d5\u0628\u06d5\u0644\u06d5\u0686\u06d5" },
            { "nv", "\u0646\u0627\u06cb\u0627\u062e\u0648\u0686\u06d5" },
            { "kaa", "\u0642\u0627\u0631\u0627-\u0642\u0627\u0644\u067e\u0627\u0642\u0686\u06d5" },
            { "ny", "\u0646\u0649\u064a\u0627\u0646\u062c\u0627\u0686\u06d5" },
            { "kac", "\u0643\u0627\u0686\u0649\u0646\u0686\u06d5" },
            { "kab", "\u0643\u0627\u0628\u0649\u0644\u06d0\u0686\u06d5" },
            { "%%POLYTON", "\u067e\u0648\u0644\u0649\u062a\u0648\u0646\u0649\u0643" },
            { "oc", "\u0626\u0648\u0643\u0633\u0649\u062a\u0686\u06d5" },
            { "kaj", "\u062c\u06c7\u0686\u06d5" },
            { "kam", "\u0643\u0627\u0645\u0628\u0627\u0686\u06d5" },
            { "men", metaValue_men },
            { "%%EMODENG", "\u062f\u06d5\u0633\u0644\u06d5\u067e\u0643\u0649 \u0645\u06d5\u0632\u06af\u0649\u0644\u062f\u0649\u0643\u0649 \u0632\u0627\u0645\u0627\u0646\u0649\u06cb\u0649 \u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "oj", "\u0626\u0648\u062c\u0649\u0628\u06cb\u0627\u0686\u06d5" },
            { "mer", "\u0645\u06d0\u0631\u06c7\u0686\u06d5" },
            { "type.nu.armn", "\u0626\u06d5\u0631\u0645\u06d5\u0646\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "om", "\u0626\u0648\u0631\u0648\u0645\u0648\u0686\u06d5" },
            { "kaw", "\u0643\u0627\u06cb\u0649\u0686\u06d5" },
            { "or", "\u0626\u0648\u062f\u0649\u064a\u0627\u0686\u06d5" },
            { "os", "\u0626\u0648\u0633\u0633\u06d0\u062a\u0686\u06d5\u0686\u06d5" },
            { "%%ALALC97", "ALA-LC \u0644\u0627\u062a\u0649\u0646\u0644\u0627\u0634\u062a\u06c7\u0631\u06c7\u0634\u060c 1997 \u0646\u06d5\u0634\u0631\u0649" },
            { "kbd", "\u0643\u0627\u0628\u0627\u0631\u062f\u06d5\u064a\u0686\u06d5" },
            { "mfe", "\u0645\u0648\u0631\u0649\u0633\u064a\u06d0\u0646\u0686\u06d5" },
            { "srn", "\u0633\u0649\u0631\u0627\u0646\u0627\u0646-\u062a\u0648\u06ad\u0648\u0686\u06d5" },
            { "pa", "\u067e\u06d5\u0646\u062c\u0627\u0628\u0686\u06d5" },
            { "dua", "\u062f\u06c7\u0626\u0627\u0644\u0627\u0686\u06d5" },
            { "srr", "\u0633\u06d0\u0631\u06d0\u0631\u0686\u06d5" },
            { "%%LIPAW", "\u0631\u06d0\u0633\u0649\u064a\u0627\u0646\u0646\u0649\u06ad \u0644\u0649\u067e\u0648\u06cb\u0627\u0632 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "kbl", "\u0643\u0627\u0646\u06d0\u0645\u0628\u06c7\u0686\u06d5" },
            { "pi", "\u067e\u0627\u0644\u0649\u0686\u06d5" },
            { "pl", "\u067e\u0648\u0644\u06d5\u0643\u0686\u06d5" },
            { "dum", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u06af\u0648\u0644\u0644\u0627\u0646\u062f\u0649\u064a\u06d5\u0686\u06d5" },
            { "type.nu.saur", "\u0633\u0627\u0626\u06c7\u0631\u0627\u0634\u062a\u0649\u0631\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "type.ca.dangi", "\u062f\u0627\u0646\u06af\u0649 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "ps", "\u067e\u06c7\u0634\u062a\u06c7\u0686\u06d5" },
            { "pt", "\u067e\u0648\u0631\u062a\u06c7\u06af\u0627\u0644\u0686\u06d5" },
            { "mga", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u06d5\u0633\u0649\u0631 \u0626\u0649\u0631\u06d0\u0644\u0627\u0646\u062f\u0686\u06d5" },
            { "key.co", "\u062a\u06d5\u0631\u062a\u0649\u067e\u0644\u06d5\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "pt_BR", "\u0628\u0649\u0631\u0627\u0632\u0649\u0644\u0649\u064a\u06d5 \u067e\u0648\u0631\u062a\u06c7\u06af\u0627\u0644\u0686\u06d5" },
            { "%%BOHORIC", "\u0628\u0648\u062e\u0648\u0631\u0649\u0686 \u0626\u06d0\u0644\u0649\u067e\u0628\u06d5\u0633\u0649" },
            { "kcg", "\u062a\u064a\u0627\u067e\u0686\u06d5" },
            { "mgh", "\u0645\u0627\u0643\u06c7\u06cb\u0627\u0686\u06d5" },
            { "type.nu.nkoo", "\u0646\u0649\u0643\u0648\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "bra", "\u0628\u0649\u0631\u0627\u062c\u0686\u06d5" },
            { "key.ca", "\u064a\u0649\u0644\u0646\u0627\u0645\u06d5" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0645\u06d0\u062a\u0627\u0686\u06d5\u2019" },
            { "ssy", metaValue_ssy },
            { "type.nu.mymr", "\u0628\u06d0\u0631\u0645\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "qu", "\u0643\u06d0\u0686\u0649\u06cb\u0627\u0686\u06d5" },
            { "zap", "\u0632\u0627\u067e\u0648\u062a\u06d0\u0643\u0686\u06d5" },
            { "brx", "\u0628\u0648\u062f\u0648\u0686\u06d5" },
            { "Lana", "\u0644\u0627\u0646\u0646\u0627\u0686\u06d5" },
            { "kde", "\u0645\u0627\u0643\u0648\u0646\u062f\u06d0\u0686\u06d5" },
            { "Ethi", "\u0626\u06d0\u0641\u0649\u064a\u0648\u067e\u0649\u064a\u06d5\u0686\u06d5" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0633\u0686\u06d5" },
            { "rn", "\u0631\u06c7\u0646\u062f\u0649\u0686\u06d5" },
            { "key.cu", "\u067e\u06c7\u0644" },
            { "ro", "\u0631\u0648\u0645\u0649\u0646\u0686\u06d5" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "\u0626\u0648\u0631\u0649\u064a\u0627\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "type.nu.hanidec", "\u062e\u06d5\u0646\u0686\u06d5 \u0626\u0648\u0646\u0644\u06c7\u0642 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "ru", "\u0631\u06c7\u0633\u0686\u06d5" },
            { "bss", "\u0626\u0627\u0643\u06c7\u0633\u0686\u06d5" },
            { "zbl", metaValue_zbl },
            { "rw", "\u0643\u06d0\u0646\u0649\u064a\u06d5\u0631\u0649\u06cb\u0627\u0646\u062f\u0627\u0686\u06d5" },
            { "kea", "\u0643\u0627\u0628\u06c7\u06cb\u06d0\u0631\u062f\u0649\u064a\u0627\u0646\u0686\u06d5" },
            { "mic", "\u0645\u0649\u0643\u0645\u0627\u0643\u0686\u06d5" },
            { "suk", "\u0633\u06c7\u0643\u06c7\u0645\u0627\u0686\u06d5" },
            { "en_AU", "\u0626\u0627\u06cb\u0633\u062a\u0631\u0627\u0644\u0649\u064a\u06d5 \u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "Dupl", "\u062f\u06c7\u067e\u0644\u0648\u064a\u0627\u0646 \u062a\u06d0\u0632 \u062e\u0627\u062a\u0649\u0631\u0649\u0644\u06d5\u0634" },
            { "sa", "\u0633\u0627\u0646\u0633\u0643\u0631\u0649\u062a\u0686\u06d5" },
            { "%%UCCOR", "\u0628\u0649\u0631\u0644\u0649\u0643\u0643\u06d5 \u0643\u06d5\u0644\u06af\u06d5\u0646 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "sc", "\u0633\u0627\u0631\u062f\u0649\u0646\u0649\u064a\u06d5\u0686\u06d5" },
            { "sus", "\u0633\u06c7\u0633\u06c7\u0686\u06d5" },
            { "sd", "\u0633\u0649\u0646\u062f\u0649\u0686\u06d5" },
            { "se", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0633\u0627\u0645\u0649\u0686\u06d5" },
            { "min", "\u0645\u0649\u0646\u0627\u06ad\u0643\u0627\u0628\u0627\u0626\u06c7\u0686\u06d5" },
            { "sg", "\u0633\u0627\u0646\u06af\u0648\u0686\u06d5" },
            { "sh", "\u0633\u06d0\u0631\u0628-\u0643\u0631\u0648\u062f\u0649\u064a\u06d5\u0686\u06d5" },
            { "si", "\u0633\u0649\u0646\u06af\u0627\u0644\u0686\u06d5" },
            { "sux", "\u0633\u06c8\u0645\u06d5\u0631\u0686\u06d5" },
            { "sk", "\u0633\u0649\u0644\u0648\u06cb\u0627\u0643\u0686\u06d5" },
            { "sl", "\u0633\u0649\u0644\u0648\u06cb\u06d0\u0646\u0686\u06d5" },
            { "Gran", "\u06af\u0649\u0631\u0627\u0646\u062a\u0627\u0686\u06d5" },
            { "sm", "\u0633\u0627\u0645\u0648\u0626\u0627\u0686\u06d5" },
            { "sn", "\u0634\u0648\u0646\u0627\u0686\u06d5" },
            { "so", "\u0633\u0648\u0645\u0627\u0644\u0649\u0686\u06d5" },
            { "type.nu.arab", "\u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5-\u06be\u0649\u0646\u062f\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "sq", "\u0626\u0627\u0644\u0628\u0627\u0646\u0686\u06d5" },
            { "sr", "\u0633\u06d0\u0631\u0628\u0686\u06d5" },
            { "ss", "\u0633\u0649\u06cb\u0627\u062a\u0649\u0686\u06d5" },
            { "Java", metaValue_jv },
            { "st", "\u0633\u0648\u062a\u0648\u0686\u06d5" },
            { "su", metaValue_su },
            { "%%NEDIS", "\u0646\u0627\u062a\u0649\u0633\u0648\u0646 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "sv", "\u0634\u0649\u06cb\u06d0\u062f\u0686\u06d5" },
            { "sw", "\u0633\u0649\u06cb\u0627\u06be\u0649\u0644\u0686\u06d5" },
            { "type.nu.hantfin", "\u0645\u06c7\u0631\u06d5\u0643\u0643\u06d5\u067e \u062e\u06d5\u0646\u0686\u06d5 \u067e\u06c7\u0644-\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "ibb", "\u0626\u0649\u0628\u0649\u0628\u0649\u0626\u0648\u0686\u06d5" },
            { "iba", "\u0626\u0649\u0628\u0627\u0646\u0686\u06d5" },
            { "ta", metaValue_ta },
            { "142", "\u0626\u0627\u0633\u0649\u064a\u0627" },
            { "bua", "\u0628\u06c7\u0631\u0649\u064a\u0627\u062a\u0686\u06d5" },
            { "143", "\u0626\u0648\u062a\u062a\u06c7\u0631\u0627 \u0626\u0627\u0633\u0649\u064a\u0627" },
            { "te", metaValue_te },
            { "145", "\u063a\u06d5\u0631\u0628\u0649\u064a \u0626\u0627\u0633\u0649\u064a\u0627" },
            { "tg", "\u062a\u0627\u062c\u0649\u0643\u0686\u06d5" },
            { "th", metaValue_th },
            { "ti", "\u062a\u0649\u06af\u0631\u0649\u0646\u064a\u0627\u0686\u06d5" },
            { "bug", "\u0628\u06c7\u06af\u0649\u0686\u06d5" },
            { "kfo", "\u0643\u0648\u0631\u0648\u0686\u06d5" },
            { "en_CA", "\u0643\u0627\u0646\u0627\u062f\u0627 \u0626\u0649\u0646\u06af\u0644\u0649\u0632\u0686\u06d5" },
            { "tk", "\u062a\u06c8\u0631\u0643\u0645\u06d5\u0646\u0686\u06d5" },
            { "tl", metaValue_tl },
            { "tn", "\u0633\u0649\u06cb\u0627\u0646\u0627\u0686\u06d5" },
            { "to", "\u062a\u0648\u0646\u06af\u0627\u0646\u0686\u06d5" },
            { "bum", "\u0628\u06c7\u0644\u06c7\u0686\u06d5" },
            { "dyo", "\u062c\u0648\u0644\u0627\u0686\u06d5" },
            { "type.nu.jpan", "\u064a\u0627\u067e\u0648\u0646\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "tr", "\u062a\u06c8\u0631\u0643\u0686\u06d5" },
            { "ts", "\u0633\u0648\u0646\u06af\u0627\u0686\u06d5" },
            { "swb", "\u0643\u0648\u0645\u0648\u0631\u0649\u0686\u06d5" },
            { "Cakm", "\u0686\u0627\u0643\u0645\u0627" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631\u0686\u06d5" },
            { "dyu", "\u062f\u0649\u064a\u06c7\u0644\u0627\u0686\u06d5" },
            { "tw", "\u062a\u0649\u06cb\u0649\u0686\u06d5" },
            { "ty", "\u062a\u0627\u062e\u062a\u0649\u0686\u06d5" },
            { "%%BISKE", "\u0633\u0627\u0646 \u06af\u0649\u064a\u0648\u0631\u06af\u0649\u064a\u0648/\u0628\u0649\u0644\u0627 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "150", "\u064a\u0627\u06cb\u0631\u0648\u067e\u0627" },
            { "151", "\u0634\u06d5\u0631\u0642\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627" },
            { "154", "\u0634\u0649\u0645\u0627\u0644\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627" },
            { "dzg", "\u062f\u0627\u0632\u0627\u06af\u0627\u0686\u06d5" },
            { "155", "\u063a\u06d5\u0631\u0628\u0649\u064a \u064a\u0627\u06cb\u0631\u0648\u067e\u0627" },
            { "ug", "\u0626\u06c7\u064a\u063a\u06c7\u0631\u0686\u06d5" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0626\u0649\u062a\u0627\u0644\u064a\u0627\u0646\u0686\u06d5" },
            { "Zyyy", "\u0626\u0648\u0631\u062a\u0627\u0642" },
            { "uk", "\u0626\u06c7\u0643\u0631\u0627\u0626\u0649\u0646\u0686\u06d5" },
            { "type.ca.coptic", "\u0643\u0648\u067e\u062a\u0649\u0643 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "ur", "\u0626\u0648\u0631\u062f\u06c7\u0686\u06d5" },
            { "%%1994", "\u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u06d5\u0634\u062a\u06c8\u0631\u06c8\u0644\u06af\u06d5\u0646 \u0631\u06d0\u0633\u0649\u064a\u0627\u0646 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "xal", "\u0642\u0627\u0644\u0645\u0627\u0642\u0686\u06d5" },
            { "zen", "\u0632\u06d0\u0646\u0627\u06af\u0627\u0686\u06d5" },
            { "uz", "\u0626\u06c6\u0632\u0628\u06d0\u0643\u0686\u06d5" },
            { "kha", "\u0643\u0627\u0633\u0649\u0686\u06d5" },
            { "%%1996", "\u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649 1996" },
            { "Sylo", "\u0633\u0649\u064a\u0648\u0644\u0648\u062a\u0649-\u0646\u0627\u06af\u0631\u0649\u0686\u06d5" },
            { "ve", "\u06cb\u06d0\u0646\u062f\u0627\u0686\u06d5" },
            { "Wara", "\u06cb\u0627\u0631\u0627\u06ad \u0643\u0649\u0634\u0649\u062a\u0649" },
            { "type.ca.roc", "\u0645\u0649\u0646\u06af\u0648 \u064a\u0649\u0644\u0646\u0627\u0645\u06d5\u0633\u0649" },
            { "vi", "\u06cb\u0649\u064a\u06d0\u062a\u0646\u0627\u0645\u0686\u06d5" },
            { "kho", "\u062e\u0648\u062a\u06d5\u0646\u0686\u06d5" },
            { "khq", "\u0643\u0648\u064a\u0631\u0627 \u0686\u0649\u0646\u0649\u0686\u06d5" },
            { "%%TARASK", "\u062a\u0627\u0631\u0627\u0633\u0643\u0649\u06cb\u0649\u062a\u0633\u0627 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "vo", "\u06cb\u0648\u0644\u0627\u067e\u06c7\u0643\u0686\u06d5" },
            { "syc", "\u0642\u06d5\u062f\u0649\u0645\u0649\u064a \u0633\u06c7\u0631\u0649\u064a\u06d5\u0686\u06d5" },
            { "Osma", "\u0626\u0648\u0633\u0645\u0627\u0646\u064a\u06d5" },
            { "gaa", "\u06af\u0627\u0686\u06d5" },
            { "wa", "\u06cb\u0627\u0644\u0644\u06c7\u0646\u0686\u06d5" },
            { "syr", "\u0633\u06c7\u0631\u0649\u064a\u06d5\u0686\u06d5" },
            { "Grek", metaValue_el },
            { "Lydi", "\u0644\u0649\u062f\u0649\u064a\u06d5\u0686\u06d5" },
            { "Xsux", "\u0633\u06c7\u0645\u06d0\u0631-\u0626\u0627\u0643\u0643\u0627\u062f\u0649\u064a\u0627\u0646 \u0645\u0649\u062e \u062e\u06d5\u062a" },
            { "wo", "\u06cb\u0648\u0644\u0648\u0641\u0686\u06d5" },
            { "zgh", "\u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u0645\u0627\u0631\u0627\u0643\u06d5\u0634 \u062a\u0627\u0645\u0627\u0632\u0649\u062a\u0686\u06d5" },
            { "ar_001", "\u06be\u0627\u0632\u0649\u0631\u0642\u0649 \u0632\u0627\u0645\u0627\u0646 \u0626\u06c6\u0644\u0686\u06d5\u0645\u0644\u0649\u0643 \u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5" },
            { "Cans", "\u0628\u0649\u0631\u0644\u0649\u0643\u0643\u06d5 \u0643\u06d5\u0644\u06af\u06d5\u0646 \u0643\u0627\u0646\u0627\u062f\u0627 \u064a\u06d5\u0631\u0644\u0649\u0643 \u0628\u0648\u063a\u06c7\u0645 \u062c\u06d5\u062f\u06cb\u0649\u0644\u0649" },
            { "gay", "\u06af\u0627\u064a\u0648\u0686\u06d5" },
            { "Mong", metaValue_mn },
            { "mnc", "\u0645\u0627\u0646\u062c\u06c7\u0686\u06d5" },
            { "Latf", "\u0641\u0649\u0631\u0627\u0643\u062a\u06c7\u0631 \u0644\u0627\u062a\u0649\u0646\u0686\u06d5" },
            { "Hluw", "\u0626\u0627\u0646\u0627\u062a\u0648\u0644\u0649\u064a\u06d5 \u062a\u06d5\u0633\u06cb\u0649\u0631\u0649\u064a \u064a\u06d0\u0632\u0649\u0642" },
            { "gba", "\u06af\u0649\u0628\u0627\u064a\u0627\u0686\u06d5" },
            { "mni", "\u0645\u0627\u0646\u0649\u067e\u06c7\u0631\u0686\u06d5" },
            { "Latn", metaValue_la },
            { "Latg", "\u0633\u0649\u0643\u0648\u062a \u0644\u0627\u062a\u0649\u0646\u0686\u06d5" },
            { "type.nu.hans", "\u0626\u0627\u062f\u062f\u0649\u064a \u062e\u06d5\u0646\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "type.nu.hant", "\u0645\u06c7\u0631\u06d5\u0643\u0643\u06d5\u067e \u062e\u06d5\u0646\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "xh", "\u062e\u0648\u0633\u0627\u0686\u06d5" },
            { "type.nu.romanlow", "\u0631\u0649\u0645 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631 (\u0643\u0649\u0686\u0649\u0643 \u06be\u06d5\u0631\u067e)" },
            { "byn", "\u0628\u0649\u0644\u0649\u0646\u0686\u06d5" },
            { "%%PAMAKA", "\u067e\u0627\u0645\u0627\u0643\u0627 \u0634\u0649\u06cb\u06d5\u0633\u0649" },
            { "Lyci", "\u0644\u0649\u0633\u0649\u064a\u0627\u0646\u0686\u06d5" },
            { "osa", "\u0626\u0648\u0633\u0627\u06af\u06d0\u0644\u0627\u0631\u0686\u06d5" },
            { "byv", "\u0645\u06d0\u062f\u06c7\u0645\u0628\u0627\u0686\u06d5" },
            { "Moon", "\u0643\u0648\u0631\u0649\u064a\u06d5" },
            { "moh", "\u0645\u0648\u062e\u0627\u06cb\u0643\u0686\u06d5" },
            { "kkj", "\u0643\u0627\u0643\u0648\u0686\u06d5" },
            { "%%1694ACAD", "\u062f\u06d5\u0633\u0644\u06d5\u067e\u0643\u0649 \u0645\u06d5\u0632\u06af\u0649\u0644\u062f\u0649\u0643\u0649 \u0632\u0627\u0645\u0627\u0646\u0649\u06cb\u0649 \u0641\u0649\u0631\u0627\u0646\u0633\u06c7\u0632\u0686\u06d5" },
            { "yi", "\u064a\u0649\u062f\u062f\u0649\u0634\u0686\u06d5" },
            { "mos", "\u0645\u0648\u0633\u0633\u0649\u0686\u06d5" },
            { "Syrc", "\u0633\u06c8\u0631\u0649\u064a\u06d5\u0686\u06d5" },
            { "Dsrt", "\u062f\u06d0\u0632\u06d0\u0631\u06d0\u062a" },
            { "yo", "\u064a\u0648\u0631\u06c7\u0628\u0627\u0686\u06d5" },
            { "es_MX", "\u0645\u06d0\u0643\u0633\u0649\u0643\u0627 \u0626\u0649\u0633\u067e\u0627\u0646\u0686\u06d5" },
            { "Syrj", "\u063a\u06d5\u0631\u0628\u0649\u064a \u0633\u06c8\u0631\u0649\u064a\u06d5\u0686\u06d5" },
            { "ota", "\u0626\u0648\u0633\u0645\u0627\u0646 \u062a\u06c8\u0631\u0643\u0686\u06d5" },
            { "Syre", "\u0633\u06c8\u0631\u0649\u064a\u06d5\u0686\u06d5 \u0626\u06d5\u0628\u062c\u06d5\u062a" },
            { "vai", metaValue_vai },
            { "za", "\u062c\u06c7\u0627\u06ad\u0686\u06d5" },
            { "Cari", "\u0643\u0627\u0631\u0649\u064a\u0627" },
            { "kln", "\u0643\u0627\u0644\u06d0\u0646\u062c\u0649\u0646\u0686\u06d5" },
            { "zh", "\u062e\u06d5\u0646\u0632\u06c7\u0686\u06d5" },
            { "Afak", "\u0626\u0627\u0641\u0627\u0643\u0627" },
            { "Bopo", "\u062e\u06d5\u0646\u0686\u06d5 \u067e\u0649\u0646\u064a\u0649\u0646" },
            { "Perm", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u067e\u06d0\u0631\u0645\u0649\u0643\u0686\u06d5" },
            { "zu", "\u0632\u06c7\u0644\u06c7\u0686\u06d5" },
            { "type.co.phonebook", "\u062a\u06d0\u0644\u06d0\u0641\u0648\u0646 \u0646\u0648\u0645\u06c7\u0631 \u062a\u0649\u0632\u0649\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "%%MONOTON", "\u0626\u0627\u062f\u062f\u0649\u064a" },
            { "Geor", "\u06af\u0649\u0631\u06c7\u0632\u0649\u0646\u0686\u06d5" },
            { "Shrd", "\u0634\u0627\u0631\u0627\u062f\u0627\u0686\u06d5" },
            { "kmb", "\u0643\u0649\u0645\u0628\u06c7\u0646\u062f\u06c7\u0686\u06d5" },
            { "type.nu.jpanfin", "\u064a\u0627\u067e\u0648\u0646\u0686\u06d5 \u067e\u06c7\u0644-\u0645\u06c7\u0626\u0627\u0645\u0649\u0644\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Cham", "\u0686\u0627\u0645" },
            { "gez", "\u06af\u0649\u0632\u0686\u06d5" },
            { "Syrn", "\u0634\u06d5\u0631\u0642\u0649\u064a \u0633\u06c8\u0631\u0649\u064a\u06d5\u0686\u06d5" },
            { "type.nu.mymrshan", "\u0628\u06d0\u0631\u0645\u0627 \u0634\u0627\u0646\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Narb", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0634\u0649\u0645\u0627\u0644\u0649\u064a \u0626\u06d5\u0631\u06d5\u0628\u0686\u06d5" },
            { "type.nu.olck", "\u0626\u0648\u0644-\u0686\u0649\u0643\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "type.co.reformed", "\u064a\u0627\u062e\u0634\u0649\u0644\u0627\u0646\u063a\u0627\u0646 \u062a\u06d5\u0631\u062a\u0649\u067e\u0644\u06d5\u0634 \u062a\u06d5\u0631\u062a\u0649\u067e\u0649" },
            { "Tglg", metaValue_tl },
            { "Egyd", "\u062f\u06d0\u0645\u0648\u062a\u0649\u0643\u0686\u06d5 \u0645\u0649\u0633\u0649\u0631" },
            { "Egyh", "\u062e\u0649\u064a\u06d5\u0631\u0627\u062a\u0649\u0643\u0686\u06d5 \u0645\u0649\u0633\u0649\u0631" },
            { "Palm", "\u067e\u0627\u0644\u0645\u0649\u0631\u0627\u0686\u06d5" },
            { "ebu", "\u0626\u06d0\u0645\u0628\u06c7\u0686\u06d5" },
            { "Egyp", "\u062a\u06d5\u0633\u06cb\u0649\u0631\u0649\u064a \u064a\u06d0\u0632\u0649\u0642 \u0645\u0649\u0633\u0649\u0631" },
            { "Geok", "\u062e\u06c7\u062a\u0633\u06c7\u0631\u0649 \u06af\u0649\u0631\u06c7\u0632\u0649\u0646\u0686\u06d5" },
            { "zh_Hans", metaValue_Hans },
            { "Hung", "\u0642\u06d5\u062f\u0649\u0645\u0643\u0649 \u0645\u0627\u062c\u0627\u0631\u0686\u06d5" },
            { "kok", "\u0643\u0648\u0646\u0643\u0627\u0646\u0686\u06d5" },
            { "%%1901", "\u0626\u06d5\u0646\u0626\u06d5\u0646\u0649\u06cb\u0649 \u06af\u06d0\u0631\u0645\u0627\u0646\u0686\u06d5 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "kos", "\u0643\u0648\u0633\u0631\u0627\u064a\u06d0\u0686\u06d5" },
            { "type.nu.limb", "\u0644\u0649\u0645\u0628\u06c7\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "zh_Hant", metaValue_Hant },
            { "Sund", metaValue_su },
            { "kpe", "\u0643\u0649\u067e\u06d5\u0644\u0644\u06d0\u0686\u06d5" },
            { "type.nu.khmr", "\u0643\u06d0\u062e\u0645\u06d0\u0631\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "Tirh", "\u062a\u0649\u0631\u062e\u06c7\u062a\u0627\u0686\u06d5" },
            { "ilo", "\u0626\u0649\u0644\u0648\u0643\u0627\u0646\u0648\u0686\u06d5" },
            { "%%VALENCIA", "\u06cb\u0627\u0644\u06d0\u0646\u0633\u0649\u064a\u06d5" },
            { "Cprt", metaValue_CY },
            { "%%BAKU1926", "\u0628\u0649\u0631\u0644\u0649\u0643\u0643\u06d5 \u0643\u06d5\u0644\u06af\u06d5\u0646 \u062a\u06c8\u0631\u0643 \u0644\u0627\u062a\u0649\u0646 \u0626\u06d0\u0644\u0649\u067e\u0628\u06d5\u0633\u0649" },
            { "mua", "\u0645\u06c7\u0646\u062f\u0627\u06ad\u0686\u06d5" },
            { "type.nu.guru", "\u06af\u06c7\u0631\u0645\u06c7\u0643\u0649\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "mul", "\u0643\u06c6\u067e \u062a\u0649\u0644\u0644\u0627\u0631" },
            { "cad", "\u0643\u0627\u062f\u062f\u0648\u0686\u06d5" },
            { "mus", "\u0643\u0649\u0631\u0649\u0643\u0686\u06d5" },
            { "Glag", "\u06af\u0649\u0644\u0627\u06af\u0648\u062a\u0686\u06d5" },
            { "gil", "\u06af\u0649\u0644\u0628\u06d0\u0631\u062a\u0686\u06d5" },
            { "%%KKCOR", "\u0626\u0648\u0631\u062a\u0627\u0642 \u0626\u0649\u0645\u0644\u0627 \u0642\u0627\u0626\u0649\u062f\u0649\u0633\u0649" },
            { "Cher", "\u0686\u06d0\u0631\u0648\u0643\u0649" },
            { "car", "\u0643\u0627\u0631\u0649\u0628\u0686\u06d5" },
            { "cay", "\u0643\u0627\u064a\u06c7\u06af\u0627\u0686\u06d5" },
            { "type.nu.tamldec", "\u062a\u0627\u0645\u0649\u0644\u0686\u06d5 \u0631\u06d5\u0642\u06d5\u0645\u0644\u06d5\u0631" },
            { "krc", "\u0642\u0627\u0631\u0627\u0686\u0627\u064a-\u0628\u0627\u0644\u0642\u0627\u0631\u0686\u06d5" },
            { "inh", "\u0626\u0649\u0646\u06af\u06c7\u0634\u0686\u06d5" },
            { "krl", "\u0643\u0627\u0631\u06d5\u0644\u0686\u06d5" },
            { "efi", "\u0626\u06d0\u0641\u0649\u0643\u0686\u06d5" },
            { "key.nu", "\u0633\u0627\u0646" },
            { "kru", "\u0643\u06c7\u0631\u06c7\u062e\u0686\u06d5" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627\u0686\u06d5" },
            { "Telu", metaValue_te },
            { "ksf", "\u0628\u0627\u0641\u0649\u064a\u0627\u0686\u06d5" },
        };
        return data;
    }
}
