/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class History {
    private final List<HistoryOsmPrimitive> versions;
    private final long id;
    private final OsmPrimitiveType type;

    private static History filter(History history, FilterPredicate predicate) {
        ArrayList<HistoryOsmPrimitive> out = new ArrayList<HistoryOsmPrimitive>();
        for (HistoryOsmPrimitive primitive : history.versions) {
            if (!predicate.matches(primitive)) continue;
            out.add(primitive);
        }
        return new History(history.id, history.type, out);
    }

    protected History(long id, OsmPrimitiveType type, List<HistoryOsmPrimitive> versions) {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected, got {1}", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        this.id = id;
        this.type = type;
        this.versions = new ArrayList<HistoryOsmPrimitive>();
        if (versions != null) {
            this.versions.addAll(versions);
        }
    }

    public History sortAscending() {
        ArrayList<HistoryOsmPrimitive> copy = new ArrayList<HistoryOsmPrimitive>(this.versions);
        copy.sort(Comparator.naturalOrder());
        return new History(this.id, this.type, copy);
    }

    public History sortDescending() {
        ArrayList<HistoryOsmPrimitive> copy = new ArrayList<HistoryOsmPrimitive>(this.versions);
        copy.sort(Comparator.reverseOrder());
        return new History(this.id, this.type, copy);
    }

    public History from(Date fromDate) {
        return History.filter(this, primitive -> primitive.getTimestamp().compareTo(fromDate) >= 0);
    }

    public History until(Date untilDate) {
        return History.filter(this, primitive -> primitive.getTimestamp().compareTo(untilDate) <= 0);
    }

    public History between(Date fromDate, Date untilDate) {
        return this.from(fromDate).until(untilDate);
    }

    public History from(long fromVersion) {
        return History.filter(this, primitive -> primitive.getVersion() >= fromVersion);
    }

    public History until(long untilVersion) {
        return History.filter(this, primitive -> primitive.getVersion() <= untilVersion);
    }

    public History between(long fromVersion, long untilVersion) {
        return this.from(fromVersion).until(untilVersion);
    }

    public History forUserId(long uid) {
        return History.filter(this, primitive -> primitive.getUser() != null && primitive.getUser().getId() == uid);
    }

    public long getId() {
        return this.id;
    }

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.id, this.type);
    }

    public boolean contains(long version) {
        for (HistoryOsmPrimitive primitive : this.versions) {
            if (!primitive.matches(this.id, version)) continue;
            return true;
        }
        return false;
    }

    public HistoryOsmPrimitive getByVersion(long version) {
        for (HistoryOsmPrimitive primitive : this.versions) {
            if (!primitive.matches(this.id, version)) continue;
            return primitive;
        }
        return null;
    }

    public HistoryOsmPrimitive getByDate(Date date) {
        History h = this.sortAscending();
        if (h.versions.isEmpty()) {
            return null;
        }
        if (h.get(0).getTimestamp().compareTo(date) > 0) {
            return null;
        }
        for (int i = 1; i < h.versions.size(); ++i) {
            if (h.get(i - 1).getTimestamp().compareTo(date) > 0 || h.get(i).getTimestamp().compareTo(date) < 0) continue;
            return h.get(i);
        }
        return h.getLatest();
    }

    public HistoryOsmPrimitive get(int idx) {
        if (idx < 0 || idx >= this.versions.size()) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Parameter ''{0}'' in range 0..{1} expected. Got ''{2}''.", "idx", this.versions.size() - 1, idx));
        }
        return this.versions.get(idx);
    }

    public HistoryOsmPrimitive getEarliest() {
        if (this.isEmpty()) {
            return null;
        }
        return this.sortAscending().versions.get(0);
    }

    public HistoryOsmPrimitive getLatest() {
        if (this.isEmpty()) {
            return null;
        }
        return this.sortDescending().versions.get(0);
    }

    public int getNumVersions() {
        return this.versions.size();
    }

    public final boolean isEmpty() {
        return this.versions.isEmpty();
    }

    public OsmPrimitiveType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("History [" + (this.type != null ? "type=" + (Object)((Object)this.type) + ", " : "") + "id=" + this.id);
        if (this.versions != null) {
            result.append(", versions=\n");
            for (HistoryOsmPrimitive v : this.versions) {
                result.append('\t').append(v).append(",\n");
            }
        }
        result.append(']');
        return result.toString();
    }

    @FunctionalInterface
    private static interface FilterPredicate {
        public boolean matches(HistoryOsmPrimitive var1);
    }
}

