/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;
import org.openstreetmap.josm.tools.Destroyable;

public class JosmTextField
extends JTextField
implements Destroyable,
FocusListener {
    private final PopupMenuLauncher launcher;
    private String hint;

    public JosmTextField(Document doc, String text, int columns) {
        this(doc, text, columns, true);
    }

    public JosmTextField(Document doc, String text, int columns, boolean undoRedo) {
        super(doc, text, columns);
        this.launcher = TextContextualPopupMenu.enableMenuFor(this, undoRedo);
        if (columns > 0) {
            this.setMinimumSize(this.getPreferredSize());
        }
        this.addFocusListener(this);
        JosmPasswordField.workaroundJdkBug6322854(this);
    }

    public JosmTextField(String text, int columns) {
        this(null, text, columns);
    }

    public JosmTextField(String text) {
        this(null, text, 0);
    }

    public JosmTextField(int columns) {
        this(null, null, columns);
    }

    public JosmTextField() {
        this(null, null, 0);
    }

    public final String getHint() {
        return this.hint;
    }

    public final void setHint(String hint) {
        this.hint = hint;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.hint != null && !this.hint.isEmpty() && this.getText().isEmpty() && !this.isFocusOwner()) {
            int h = this.getHeight();
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            Insets ins = this.getInsets();
            FontMetrics fm = g.getFontMetrics();
            int c0 = this.getBackground().getRGB();
            int c1 = this.getForeground().getRGB();
            int m = -16843010;
            int c2 = ((c0 & m) >>> 1) + ((c1 & m) >>> 1);
            g.setColor(new Color(c2, true));
            g.drawString(this.hint, ins.left, h / 2 + fm.getAscent() / 2 - 2);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.keyDetector.setEnabled(false);
        }
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.keyDetector.setEnabled(true);
        }
        this.repaint();
    }

    @Override
    public void destroy() {
        this.removeFocusListener(this);
        TextContextualPopupMenu.disableMenuFor(this, this.launcher);
    }
}

