"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var geometries_1 = require("./geometries");
function getCurrentPointerPosition(state) {
    return state.interactions.pointer.current.position;
}
exports.getPickedShapes = re_reselect_1.default([geometries_1.geometries, getCurrentPointerPosition], function (geoms, pointerPosition) {
    var picker = geoms.pickQuads;
    var chartCenter = geoms.chartCenter;
    var x = pointerPosition.x - chartCenter.x;
    var y = pointerPosition.y - chartCenter.y;
    return picker(x, y);
})(function (state) { return state.chartId; });
exports.getPickedShapesLayerValues = re_reselect_1.default([exports.getPickedShapes], function (pickedShapes) {
    var elements = pickedShapes.map(function (model) {
        var values = [];
        values.push({
            groupByRollup: 'Actual',
            value: model.actual,
        });
        return values.reverse();
    });
    return elements;
})(function (state) { return state.chartId; });
//# sourceMappingURL=picked_shapes.js.map