"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var get_last_click_1 = require("../../../../state/selectors/get_last_click");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var utils_1 = require("../../../../state/utils");
var picked_shapes_1 = require("./picked_shapes");
var pie_spec_1 = require("./pie_spec");
function createOnElementClickCaller() {
    var prevClick = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartTypes.Partition) {
            selector = re_reselect_1.default([pie_spec_1.getPieSpec, get_last_click_1.getLastClickSelector, get_settings_specs_1.getSettingsSpecSelector, picked_shapes_1.getPickedShapesLayerValues], function (pieSpec, lastClick, settings, pickedShapes) {
                if (!pieSpec) {
                    return;
                }
                if (!settings.onElementClick) {
                    return;
                }
                var nextPickedShapesLength = pickedShapes.length;
                if (nextPickedShapesLength > 0 && utils_1.isClicking(prevClick, lastClick)) {
                    if (settings && settings.onElementClick) {
                        var elements = pickedShapes.map(function (values) { return [
                            values,
                            {
                                specId: pieSpec.id,
                                key: "spec{" + pieSpec.id + "}",
                            },
                        ]; });
                        settings.onElementClick(elements);
                    }
                }
                prevClick = lastClick;
            })({
                keySelector: function (state) { return state.chartId; },
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnElementClickCaller = createOnElementClickCaller;
//# sourceMappingURL=on_element_click_caller.js.map