"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../../../utils/commons");
var axis_type_utils_1 = require("../../../utils/axis_type_utils");
function renderLine(ctx, props) {
    var position = props.axisSpec.position, axisPosition = props.axisPosition, axisLineStyle = props.axisConfig.axisLineStyle;
    var lineProps = [];
    if (axis_type_utils_1.isVerticalAxis(position)) {
        lineProps[0] = position === commons_1.Position.Left ? axisPosition.width : 0;
        lineProps[2] = position === commons_1.Position.Left ? axisPosition.width : 0;
        lineProps[1] = 0;
        lineProps[3] = axisPosition.height;
    }
    else {
        lineProps[0] = 0;
        lineProps[2] = axisPosition.width;
        lineProps[1] = position === commons_1.Position.Top ? axisPosition.height : 0;
        lineProps[3] = position === commons_1.Position.Top ? axisPosition.height : 0;
    }
    ctx.beginPath();
    ctx.moveTo(lineProps[0], lineProps[1]);
    ctx.lineTo(lineProps[2], lineProps[3]);
    ctx.strokeStyle = axisLineStyle.stroke;
    ctx.lineWidth = axisLineStyle.strokeWidth;
    ctx.stroke();
}
exports.renderLine = renderLine;
//# sourceMappingURL=line.js.map