"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var spec_factory_1 = require("../state/spec_factory");
var constants_1 = require("./constants");
exports.Settings = spec_factory_1.getConnect()(spec_factory_1.specComponentFactory(constants_1.DEFAULT_SETTINGS_SPEC));
function isPointerOutEvent(event) {
    return event !== null && event !== undefined && event.type === constants_1.PointerEventType.Out;
}
exports.isPointerOutEvent = isPointerOutEvent;
function isPointerOverEvent(event) {
    return event !== null && event !== undefined && event.type === constants_1.PointerEventType.Over;
}
exports.isPointerOverEvent = isPointerOverEvent;
function isTooltipProps(config) {
    return typeof config === 'object';
}
exports.isTooltipProps = isTooltipProps;
function isTooltipType(config) {
    return typeof config === 'string';
}
exports.isTooltipType = isTooltipType;
function isCrosshairTooltipType(type) {
    return type === constants_1.TooltipType.VerticalCursor || type === constants_1.TooltipType.Crosshairs;
}
exports.isCrosshairTooltipType = isCrosshairTooltipType;
function isFollowTooltipType(type) {
    return type === constants_1.TooltipType.Follow;
}
exports.isFollowTooltipType = isFollowTooltipType;
function getTooltipType(settings, externalTooltip) {
    if (externalTooltip === void 0) { externalTooltip = false; }
    var defaultType = constants_1.TooltipType.VerticalCursor;
    if (externalTooltip) {
        return getExternalTooltipType(settings);
    }
    var tooltip = settings.tooltip;
    if (tooltip === undefined || tooltip === null) {
        return defaultType;
    }
    if (isTooltipType(tooltip)) {
        return tooltip;
    }
    if (isTooltipProps(tooltip)) {
        return tooltip.type || defaultType;
    }
    return defaultType;
}
exports.getTooltipType = getTooltipType;
function getExternalTooltipType(_a) {
    var visible = _a.externalPointerEvents.tooltip.visible;
    return visible ? constants_1.TooltipType.VerticalCursor : constants_1.TooltipType.None;
}
exports.getExternalTooltipType = getExternalTooltipType;
//# sourceMappingURL=settings.js.map