function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ORIGIN } from './origin';
import { toAbsoluteUrl } from './utils';
export var AbstractEmsService = /*#__PURE__*/function () {
  function AbstractEmsService(config, emsClient, proxyPath) {
    var _this = this;

    _classCallCheck(this, AbstractEmsService);

    _defineProperty(this, "_emsClient", void 0);

    _defineProperty(this, "_config", void 0);

    _defineProperty(this, "_proxyPath", void 0);

    _defineProperty(this, "_getAbsoluteUrl", function (url) {
      if (/^https?:\/\//.test(url)) {
        return url;
      } else {
        return toAbsoluteUrl(_this.getApiUrl(), url);
      }
    });

    this._config = config;
    this._emsClient = emsClient;
    this._proxyPath = proxyPath;
  }

  _createClass(AbstractEmsService, [{
    key: "getAttributions",
    value: function getAttributions() {
      var _this2 = this;

      return this._config.attribution.map(function (attribution) {
        var url = _this2._emsClient.getValueInLanguage(attribution.url);

        var label = _this2._emsClient.getValueInLanguage(attribution.label);

        return {
          url: url,
          label: label
        };
      });
    }
  }, {
    key: "getHTMLAttribution",
    value: function getHTMLAttribution() {
      var _this3 = this;

      var attributions = this._config.attribution.map(function (attribution) {
        var url = _this3._emsClient.getValueInLanguage(attribution.url);

        var label = _this3._emsClient.getValueInLanguage(attribution.label);

        var html = url ? "<a rel=\"noreferrer noopener\" href=\"".concat(url, "\">").concat(label, "</a>") : label;
        return _this3._emsClient.sanitizeHtml(html);
      });

      return attributions.join(' | '); //!!!this is the current convention used in Kibana
    }
  }, {
    key: "getMarkdownAttribution",
    value: function getMarkdownAttribution() {
      var _this4 = this;

      var attributions = this._config.attribution.map(function (attribution) {
        var url = _this4._emsClient.getValueInLanguage(attribution.url);

        var label = _this4._emsClient.getValueInLanguage(attribution.label);

        return "[".concat(label, "](").concat(url, ")");
      });

      return attributions.join('|');
    }
  }, {
    key: "getOrigin",
    value: function getOrigin() {
      return ORIGIN.EMS;
    }
    /**
     * Checks if url is absolute. If not, prepend the basePath.
     */

  }]);

  return AbstractEmsService;
}();