function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { List } from 'react-virtualized'; // eslint-disable-line import/named

import { EuiCode } from '../../../components/code';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiHighlight } from '../../highlight';
import { EuiPanel } from '../../panel';
import { EuiText } from '../../text';
import { EuiLoadingSpinner } from '../../loading';
import { EuiComboBoxTitle } from './combo_box_title';
import { EuiI18n } from '../../i18n';
import { EuiFilterSelectItem } from '../../filter_group/filter_select_item';
var positionToClassNameMap = {
  top: 'euiComboBoxOptionsList--top',
  bottom: 'euiComboBoxOptionsList--bottom'
};
var OPTION_CONTENT_CLASSNAME = 'euiComboBoxOption__content';
export var EuiComboBoxOptionsList =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiComboBoxOptionsList, _Component);

  function EuiComboBoxOptionsList() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, EuiComboBoxOptionsList);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(EuiComboBoxOptionsList)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "listRefInstance", null);

    _defineProperty(_assertThisInitialized(_this), "updatePosition", function () {
      // Wait a beat for the DOM to update, since we depend on DOM elements' bounds.
      requestAnimationFrame(function () {
        _this.props.updatePosition(_this.listRefInstance);
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closeListOnScroll", function (event) {
      // Close the list when a scroll event happens, but not if the scroll happened in the options list.
      // This mirrors Firefox's approach of auto-closing `select` elements onscroll.
      if (_this.listRefInstance && event.target && _this.listRefInstance.contains(event.target) === false) {
        _this.props.onCloseList();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "listRefCallback", function (ref) {
      _this.props.listRef(ref);

      _this.listRefInstance = ref;
    });

    return _this;
  }

  _createClass(EuiComboBoxOptionsList, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      // Wait a frame, otherwise moving focus from one combo box to another will result in the class
      // being removed from the body.
      requestAnimationFrame(function () {
        document.body.classList.add('euiBody-hasPortalContent');
      });
      this.updatePosition();
      window.addEventListener('resize', this.updatePosition); // Firefox will trigger a scroll event in many common situations when the options list div is appended
      // to the DOM; in testing it was always within 100ms, but setting a timeout here for 500ms to be safe

      setTimeout(function () {
        window.addEventListener('scroll', _this2.closeListOnScroll, {
          passive: true,
          // for better performance as we won't call preventDefault
          capture: true // scroll events don't bubble, they must be captured instead

        });
      }, 500);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var options = prevProps.options,
          selectedOptions = prevProps.selectedOptions,
          searchValue = prevProps.searchValue; // We don't compare matchingOptions because that will result in a loop.

      if (searchValue !== this.props.searchValue || options !== this.props.options || selectedOptions !== this.props.selectedOptions) {
        this.updatePosition();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.body.classList.remove('euiBody-hasPortalContent');
      window.removeEventListener('resize', this.updatePosition);
      window.removeEventListener('scroll', this.closeListOnScroll, {
        capture: true
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          dataTestSubj = _this$props['data-test-subj'],
          activeOptionIndex = _this$props.activeOptionIndex,
          areAllOptionsSelected = _this$props.areAllOptionsSelected,
          fullWidth = _this$props.fullWidth,
          getSelectedOptionForSearchValue = _this$props.getSelectedOptionForSearchValue,
          isLoading = _this$props.isLoading,
          listRef = _this$props.listRef,
          matchingOptions = _this$props.matchingOptions,
          onCloseList = _this$props.onCloseList,
          onCreateOption = _this$props.onCreateOption,
          onOptionClick = _this$props.onOptionClick,
          onOptionEnterKey = _this$props.onOptionEnterKey,
          onScroll = _this$props.onScroll,
          optionRef = _this$props.optionRef,
          options = _this$props.options,
          position = _this$props.position,
          renderOption = _this$props.renderOption,
          rootId = _this$props.rootId,
          rowHeight = _this$props.rowHeight,
          scrollToIndex = _this$props.scrollToIndex,
          searchValue = _this$props.searchValue,
          selectedOptions = _this$props.selectedOptions,
          singleSelection = _this$props.singleSelection,
          updatePosition = _this$props.updatePosition,
          width = _this$props.width,
          delimiter = _this$props.delimiter,
          zIndex = _this$props.zIndex,
          style = _this$props.style,
          rest = _objectWithoutProperties(_this$props, ["data-test-subj", "activeOptionIndex", "areAllOptionsSelected", "fullWidth", "getSelectedOptionForSearchValue", "isLoading", "listRef", "matchingOptions", "onCloseList", "onCreateOption", "onOptionClick", "onOptionEnterKey", "onScroll", "optionRef", "options", "position", "renderOption", "rootId", "rowHeight", "scrollToIndex", "searchValue", "selectedOptions", "singleSelection", "updatePosition", "width", "delimiter", "zIndex", "style"]);

      var emptyStateContent;

      if (isLoading) {
        emptyStateContent = React.createElement(EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "center"
        }, React.createElement(EuiFlexItem, {
          grow: false
        }, React.createElement(EuiLoadingSpinner, {
          size: "m"
        })), React.createElement(EuiFlexItem, {
          grow: false
        }, React.createElement(EuiI18n, {
          token: "euiComboBoxOptionsList.loadingOptions",
          default: "Loading options"
        })));
      } else if (searchValue && matchingOptions && matchingOptions.length === 0) {
        if (onCreateOption && getSelectedOptionForSearchValue) {
          var selectedOptionForValue = getSelectedOptionForSearchValue(searchValue, selectedOptions);

          if (selectedOptionForValue) {
            // Disallow duplicate custom options.
            emptyStateContent = React.createElement("p", null, React.createElement(EuiI18n, {
              token: "euiComboBoxOptionsList.alreadyAdded",
              default: "{label} has already been added",
              values: {
                label: React.createElement("strong", null, selectedOptionForValue.label)
              }
            }));
          } else {
            emptyStateContent = React.createElement("p", null, React.createElement(EuiI18n, {
              token: "euiComboBoxOptionsList.createCustomOption",
              default: "Hit {key} to add {searchValue} as a custom option",
              values: {
                key: React.createElement(EuiCode, null, "ENTER"),
                searchValue: React.createElement("strong", null, searchValue)
              }
            }));
          }
        } else {
          if (delimiter && searchValue.includes(delimiter)) {
            emptyStateContent = React.createElement("p", null, React.createElement(EuiI18n, {
              token: "euiComboBoxOptionsList.delimiterMessage",
              default: "Hit enter to add each item separated by {delimiter}",
              values: {
                delimiter: React.createElement("strong", null, delimiter)
              }
            }));
          } else {
            emptyStateContent = React.createElement("p", null, React.createElement(EuiI18n, {
              token: "euiComboBoxOptionsList.noMatchingOptions",
              default: "{searchValue} doesn't match any options",
              values: {
                searchValue: React.createElement("strong", null, searchValue)
              }
            }));
          }
        }
      } else if (!options.length) {
        emptyStateContent = React.createElement("p", null, React.createElement(EuiI18n, {
          token: "euiComboBoxOptionsList.noAvailableOptions",
          default: "There aren't any options available"
        }));
      } else if (areAllOptionsSelected) {
        emptyStateContent = React.createElement("p", null, React.createElement(EuiI18n, {
          token: "euiComboBoxOptionsList.allOptionsSelected",
          default: "You've selected all available options"
        }));
      }

      var emptyState = emptyStateContent ? React.createElement(EuiText, {
        size: "xs",
        className: "euiComboBoxOptionsList__empty"
      }, emptyStateContent) : undefined;
      var numVisibleOptions = matchingOptions.length < 7 ? matchingOptions.length : 7;
      var height = numVisibleOptions * rowHeight;
      var optionsList = React.createElement(List, {
        height: height,
        id: rootId('listbox'),
        onScroll: onScroll,
        rowRenderer: function rowRenderer(_ref) {
          var key = _ref.key,
              index = _ref.index,
              style = _ref.style;
          var option = matchingOptions[index];

          var isGroupLabelOption = option.isGroupLabelOption,
              label = option.label,
              value = option.value,
              rest = _objectWithoutProperties(option, ["isGroupLabelOption", "label", "value"]);

          if (isGroupLabelOption) {
            return React.createElement("div", {
              key: key,
              style: style
            }, React.createElement(EuiComboBoxTitle, null, label));
          }

          var checked = undefined;

          if (singleSelection && selectedOptions.length && selectedOptions[0].label === label) {
            checked = 'on';
          }

          return React.createElement(EuiFilterSelectItem, _extends({
            style: style,
            key: option.label.toLowerCase(),
            onClick: function onClick() {
              if (onOptionClick) {
                onOptionClick(option);
              }
            },
            ref: optionRef.bind(_this3, index),
            isFocused: activeOptionIndex === index,
            checked: checked,
            showIcons: singleSelection ? true : false,
            id: rootId("_option-".concat(index)),
            title: label
          }, rest), renderOption ? renderOption(option, searchValue, OPTION_CONTENT_CLASSNAME) : React.createElement(EuiHighlight, {
            search: searchValue,
            className: OPTION_CONTENT_CLASSNAME
          }, label));
        },
        role: "listbox",
        rowCount: matchingOptions.length,
        rowHeight: rowHeight,
        scrollToIndex: scrollToIndex,
        width: width
      });
      var classes = classNames('euiComboBoxOptionsList', position ? positionToClassNameMap[position] : '', {
        'euiComboBoxOptionsList--fullWidth': fullWidth
      });
      return React.createElement(EuiPanel, _extends({
        paddingSize: "none",
        className: classes,
        panelRef: this.listRefCallback,
        "data-test-subj": "comboBoxOptionsList ".concat(dataTestSubj),
        style: _objectSpread({}, style, {
          zIndex: zIndex
        })
      }, rest), React.createElement("div", {
        className: "euiComboBoxOptionsList__rowWrap"
      }, emptyState || optionsList));
    }
  }]);

  return EuiComboBoxOptionsList;
}(Component);

_defineProperty(EuiComboBoxOptionsList, "defaultProps", {
  'data-test-subj': '',
  rowHeight: 27 // row height of default option renderer

});

EuiComboBoxOptionsList.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.oneOfType([PropTypes.string, PropTypes.string.isRequired]),
  activeOptionIndex: PropTypes.number,
  areAllOptionsSelected: PropTypes.bool,
  fullWidth: PropTypes.bool,
  getSelectedOptionForSearchValue: PropTypes.func,
  isLoading: PropTypes.bool,
  listRef: PropTypes.any.isRequired,
  matchingOptions: PropTypes.arrayOf(PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    options: PropTypes.arrayOf(PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any
    }).isRequired),
    value: PropTypes.any
  }).isRequired).isRequired,
  onCloseList: PropTypes.func.isRequired,
  onCreateOption: PropTypes.func,
  onOptionClick: PropTypes.func,
  onOptionEnterKey: PropTypes.func,
  onScroll: PropTypes.any,
  optionRef: PropTypes.func.isRequired,
  options: PropTypes.arrayOf(PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    options: PropTypes.arrayOf(PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any
    }).isRequired),
    value: PropTypes.any
  }).isRequired).isRequired,
  position: PropTypes.oneOf(["top", "bottom"]),
  renderOption: PropTypes.func,
  rootId: PropTypes.any.isRequired,
  rowHeight: PropTypes.number.isRequired,
  scrollToIndex: PropTypes.number,
  searchValue: PropTypes.string.isRequired,
  selectedOptions: PropTypes.arrayOf(PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    options: PropTypes.arrayOf(PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any
    }).isRequired),
    value: PropTypes.any
  }).isRequired).isRequired,
  updatePosition: PropTypes.func.isRequired,
  width: PropTypes.number.isRequired,
  singleSelection: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    asPlainText: PropTypes.bool
  }).isRequired]),
  delimiter: PropTypes.string,
  zIndex: PropTypes.number
};
EuiComboBoxOptionsList.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "updatePosition",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "closeListOnScroll",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "listRefCallback",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "ref",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiComboBoxOptionsList",
  "props": {
    "data-test-subj": {
      "defaultValue": {
        "value": "''",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "string"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": ""
    },
    "rowHeight": {
      "defaultValue": {
        "value": "27",
        "computed": false
      },
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "activeOptionIndex": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "areAllOptionsSelected": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "fullWidth": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "getSelectedOptionForSearchValue": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "isLoading": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "listRef": {
      "type": {
        "name": "any"
      },
      "required": true,
      "description": ""
    },
    "matchingOptions": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "className": {
              "name": "string",
              "required": false
            },
            "aria-label": {
              "name": "string",
              "required": false
            },
            "data-test-subj": {
              "name": "string",
              "required": false
            },
            "isGroupLabelOption": {
              "name": "bool",
              "required": false
            },
            "label": {
              "name": "string",
              "required": true
            },
            "options": {
              "name": "arrayOf",
              "value": {
                "name": "shape",
                "value": {
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "isGroupLabelOption": {
                    "name": "bool",
                    "required": false
                  },
                  "label": {
                    "name": "string",
                    "required": true
                  },
                  "options": {
                    "name": "arrayOf",
                    "value": {
                      "name": "any"
                    },
                    "required": false
                  },
                  "value": {
                    "name": "any",
                    "required": false
                  }
                }
              },
              "required": false
            },
            "value": {
              "name": "any",
              "required": false
            }
          }
        }
      },
      "required": true,
      "description": ""
    },
    "onCloseList": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "onCreateOption": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onOptionClick": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onOptionEnterKey": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "onScroll": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "optionRef": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "options": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "className": {
              "name": "string",
              "required": false
            },
            "aria-label": {
              "name": "string",
              "required": false
            },
            "data-test-subj": {
              "name": "string",
              "required": false
            },
            "isGroupLabelOption": {
              "name": "bool",
              "required": false
            },
            "label": {
              "name": "string",
              "required": true
            },
            "options": {
              "name": "arrayOf",
              "value": {
                "name": "shape",
                "value": {
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "isGroupLabelOption": {
                    "name": "bool",
                    "required": false
                  },
                  "label": {
                    "name": "string",
                    "required": true
                  },
                  "options": {
                    "name": "arrayOf",
                    "value": {
                      "name": "any"
                    },
                    "required": false
                  },
                  "value": {
                    "name": "any",
                    "required": false
                  }
                }
              },
              "required": false
            },
            "value": {
              "name": "any",
              "required": false
            }
          }
        }
      },
      "required": true,
      "description": ""
    },
    "position": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"top\"",
          "computed": false
        }, {
          "value": "\"bottom\"",
          "computed": false
        }]
      },
      "required": false,
      "description": ""
    },
    "renderOption": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": ""
    },
    "rootId": {
      "type": {
        "name": "any"
      },
      "required": true,
      "description": ""
    },
    "scrollToIndex": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    },
    "searchValue": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    },
    "selectedOptions": {
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "className": {
              "name": "string",
              "required": false
            },
            "aria-label": {
              "name": "string",
              "required": false
            },
            "data-test-subj": {
              "name": "string",
              "required": false
            },
            "isGroupLabelOption": {
              "name": "bool",
              "required": false
            },
            "label": {
              "name": "string",
              "required": true
            },
            "options": {
              "name": "arrayOf",
              "value": {
                "name": "shape",
                "value": {
                  "className": {
                    "name": "string",
                    "required": false
                  },
                  "aria-label": {
                    "name": "string",
                    "required": false
                  },
                  "data-test-subj": {
                    "name": "string",
                    "required": false
                  },
                  "isGroupLabelOption": {
                    "name": "bool",
                    "required": false
                  },
                  "label": {
                    "name": "string",
                    "required": true
                  },
                  "options": {
                    "name": "arrayOf",
                    "value": {
                      "name": "any"
                    },
                    "required": false
                  },
                  "value": {
                    "name": "any",
                    "required": false
                  }
                }
              },
              "required": false
            },
            "value": {
              "name": "any",
              "required": false
            }
          }
        }
      },
      "required": true,
      "description": ""
    },
    "updatePosition": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "width": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": ""
    },
    "singleSelection": {
      "type": {
        "name": "union",
        "value": [{
          "name": "bool"
        }, {
          "name": "shape",
          "value": {
            "asPlainText": {
              "name": "bool",
              "required": false
            }
          }
        }]
      },
      "required": false,
      "description": ""
    },
    "delimiter": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "zIndex": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    }
  }
};