function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useEffect, useRef, useState } from 'react';
import PropTypes from "prop-types";
import { htmlIdGenerator } from '../../services/accessibility';
import classnames from 'classnames';
import { keys } from '../../services';
import { EuiDataGridColumnResizer } from './data_grid_column_resizer';
import { EuiScreenReaderOnly } from '../accessibility';
import tabbable from 'tabbable';
export var EuiDataGridHeaderCell = function EuiDataGridHeaderCell(props) {
  var column = props.column,
      index = props.index,
      columnWidths = props.columnWidths,
      schema = props.schema,
      defaultColumnWidth = props.defaultColumnWidth,
      setColumnWidth = props.setColumnWidth,
      sorting = props.sorting,
      focusedCell = props.focusedCell,
      setFocusedCell = props.setFocusedCell,
      headerIsInteractive = props.headerIsInteractive,
      className = props.className;
  var id = column.id,
      display = column.display;
  var width = columnWidths[id] || defaultColumnWidth;
  var ariaProps = {};
  var screenReaderId;
  var sortString;

  if (sorting) {
    var sortedColumnIds = new Set(sorting.columns.map(function (_ref) {
      var id = _ref.id;
      return id;
    }));

    if (sorting.columns.length === 1 && sortedColumnIds.has(id)) {
      var sortDirection = sorting.columns[0].direction;
      var sortValue = 'other';

      if (sortDirection === 'asc') {
        sortValue = 'ascending';
      } else if (sortDirection === 'desc') {
        sortValue = 'descending';
      }

      ariaProps['aria-sort'] = sortValue;
    } else if (sorting.columns.length >= 2 && sortedColumnIds.has(id)) {
      sortString = sorting.columns.map(function (col) {
        return "Sorted by ".concat(col.id, " ").concat(col.direction);
      }).join(' then ');
      screenReaderId = htmlIdGenerator()();
      ariaProps['aria-describedby'] = screenReaderId;
    }
  }

  var columnType = schema[id] ? schema[id].columnType : null;
  var classes = classnames('euiDataGridHeaderCell', _defineProperty({}, "euiDataGridHeaderCell--".concat(columnType), columnType), className);
  var headerRef = useRef(null);
  var isFocused = focusedCell != null && focusedCell[0] === index && focusedCell[1] === -1;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isCellEntered = _useState2[0],
      setIsCellEntered = _useState2[1];

  var enableInteractives = useCallback(function () {
    if (headerRef.current) {
      var interactiveElements = headerRef.current.querySelectorAll('[data-euigrid-tab-managed]');

      for (var i = 0; i < interactiveElements.length; i++) {
        interactiveElements[i].setAttribute('tabIndex', '0');
      }
    }
  }, []);
  var disableInteractives = useCallback(function () {
    if (headerRef.current) {
      var tababbles = tabbable(headerRef.current);

      if (tababbles.length > 1) {
        console.warn("EuiDataGridHeaderCell expects at most 1 tabbable element, ".concat(tababbles.length, " found instead"));
      }

      for (var i = 0; i < tababbles.length; i++) {
        var element = tababbles[i];
        element.setAttribute('data-euigrid-tab-managed', 'true');
        element.setAttribute('tabIndex', '-1');
      }
    }
  }, []);
  useEffect(function () {
    if (headerRef.current) {
      if (isCellEntered) {
        enableInteractives();
        var tabbables = tabbable(headerRef.current);

        if (tabbables.length > 0) {
          tabbables[0].focus();
        }
      } else {
        disableInteractives();
      }
    }
  }, [disableInteractives, enableInteractives, isCellEntered]);
  useEffect(function () {
    if (headerRef.current) {
      // focusin bubbles while focus does not, and this needs to react to children gaining focus
      var onFocusIn = function onFocusIn(e) {
        if (headerIsInteractive === false) {
          // header is not interactive, avoid focusing
          requestAnimationFrame(function () {
            return headerRef.current.blur();
          });
          e.preventDefault();
          return false;
        } else {
          // take the focus
          if (focusedCell == null || focusedCell[0] !== index || focusedCell[1] !== -1) {
            setFocusedCell([index, -1]);
          } else if (headerRef.current) {
            // this cell already had the grid's focus, so re-enable interactives
            enableInteractives();
            setIsCellEntered(true); // if there is only one interactive element shift focus to the interactive element

            var tabbables = tabbable(headerRef.current);

            if (tabbables.length === 1) {
              tabbables[0].focus();
            }
          }
        }
      }; // focusout bubbles while blur does not, and this needs to react to the children losing focus


      var onFocusOut = function onFocusOut() {
        // wait for the next element to receive focus, then update interactives' state
        requestAnimationFrame(function () {
          if (headerRef.current) {
            if (headerRef.current.contains(document.activeElement) === false) {
              setIsCellEntered(false);
            }
          }
        });
      };

      var onKeyUp = function onKeyUp(event) {
        switch (event.key) {
          case keys.ENTER:
            {
              event.preventDefault();
              setIsCellEntered(true);
              break;
            }

          case keys.ESCAPE:
            {
              event.preventDefault(); // move focus to cell

              setIsCellEntered(false);
              headerRef.current.focus();
              break;
            }

          case keys.F2:
            {
              event.preventDefault();

              if (document.activeElement === headerRef.current) {
                // move focus into cell's interactives
                setIsCellEntered(true);
              } else {
                // move focus to cell
                setIsCellEntered(false);
                headerRef.current.focus();
              }

              break;
            }
        }
      };

      if (isFocused) {
        var interactives = headerRef.current.querySelectorAll('[data-euigrid-tab-managed]');

        if (interactives.length === 1) {
          setIsCellEntered(true);
        } else {
          headerRef.current.focus();
        }
      } else {
        setIsCellEntered(false);
      }

      var headerNode = headerRef.current; // @ts-ignore-next line TS doesn't have focusin

      headerNode.addEventListener('focusin', onFocusIn);
      headerNode.addEventListener('focusout', onFocusOut);
      headerNode.addEventListener('keyup', onKeyUp);
      return function () {
        // @ts-ignore-next line TS doesn't have focusin
        headerNode.removeEventListener('focusin', onFocusIn);
        headerNode.removeEventListener('focusout', onFocusOut);
        headerNode.removeEventListener('keyup', onKeyUp);
      };
    }
  }, [enableInteractives, headerIsInteractive, isFocused, setIsCellEntered, focusedCell, setFocusedCell, index]);
  return React.createElement("div", _extends({
    role: "columnheader"
  }, ariaProps, {
    ref: headerRef,
    tabIndex: isFocused && !isCellEntered ? 0 : -1,
    className: classes,
    "data-test-subj": "dataGridHeaderCell-".concat(id),
    style: width != null ? {
      width: "".concat(width, "px")
    } : {}
  }), column.isResizable !== false && width != null ? React.createElement(EuiDataGridColumnResizer, {
    columnId: id,
    columnWidth: width,
    setColumnWidth: setColumnWidth
  }) : null, React.createElement("div", {
    className: "euiDataGridHeaderCell__content"
  }, display || id), sorting && sorting.columns.length >= 2 && React.createElement(EuiScreenReaderOnly, null, React.createElement("div", {
    id: screenReaderId
  }, sortString)));
};
EuiDataGridHeaderCell.propTypes = {
  column: PropTypes.shape({
    /**
       * The unique identifier for this column
       */
    id: PropTypes.string.isRequired,

    /**
       * A `ReactNode` used when rendering the column header. When providing complicated content, please make sure to utilize CSS to respect truncation as space allows. Check the docs example.
       */
    display: PropTypes.node,

    /**
       * A Schema to use for the column. Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json'] but can be expanded by defining your own #EuiDataGrid `schemaDetectors` (for in-memory detection). In general, it is advised to pass in a value here when you are sure of the schema ahead of time, so that you don't need to rely on the automatic detection.
       */
    schema: PropTypes.string,

    /**
       * Defaults to true. Defines whether or not the column's cells can be expanded with a popup onClick / keydown.
       */
    isExpandable: PropTypes.bool,

    /**
       * Whether this column's width can be changed by the user, defaults to true
       */
    isResizable: PropTypes.bool,

    /**
       * Initial width (in pixels) of the column
       */
    initialWidth: PropTypes.number,

    /**
       * Whether this column is sortable
       */
    isSortable: PropTypes.bool,

    /**
       * Default sort direction of the column
       */
    defaultSortDirection: PropTypes.oneOf(["asc", "desc"]),

    /**
       * Display name as text for column. This can be used to display column name in column selector and column sorting where `display` won't be used. If not used `id` will be shown as column name in column selector and column sorting.
       */
    displayAsText: PropTypes.string
  }).isRequired,
  index: PropTypes.number.isRequired,
  className: PropTypes.string
};
EuiDataGridHeaderCell.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiDataGridHeaderCell",
  "props": {
    "column": {
      "type": {
        "name": "shape",
        "value": {
          "id": {
            "name": "string",
            "description": "The unique identifier for this column",
            "required": true
          },
          "display": {
            "name": "node",
            "description": "A `ReactNode` used when rendering the column header. When providing complicated content, please make sure to utilize CSS to respect truncation as space allows. Check the docs example.",
            "required": false
          },
          "schema": {
            "name": "string",
            "description": "A Schema to use for the column. Built-in values are ['boolean', 'currency', 'datetime', 'numeric', 'json'] but can be expanded by defining your own #EuiDataGrid `schemaDetectors` (for in-memory detection). In general, it is advised to pass in a value here when you are sure of the schema ahead of time, so that you don't need to rely on the automatic detection.",
            "required": false
          },
          "isExpandable": {
            "name": "bool",
            "description": "Defaults to true. Defines whether or not the column's cells can be expanded with a popup onClick / keydown.",
            "required": false
          },
          "isResizable": {
            "name": "bool",
            "description": "Whether this column's width can be changed by the user, defaults to true",
            "required": false
          },
          "initialWidth": {
            "name": "number",
            "description": "Initial width (in pixels) of the column",
            "required": false
          },
          "isSortable": {
            "name": "bool",
            "description": "Whether this column is sortable",
            "required": false
          },
          "defaultSortDirection": {
            "name": "enum",
            "value": [{
              "value": "\"asc\"",
              "computed": false
            }, {
              "value": "\"desc\"",
              "computed": false
            }],
            "description": "Default sort direction of the column",
            "required": false
          },
          "displayAsText": {
            "name": "string",
            "description": "Display name as text for column. This can be used to display column name in column selector and column sorting where `display` won't be used. If not used `id` will be shown as column name in column selector and column sorting.",
            "required": false
          }
        }
      },
      "required": true,
      "description": ""
    },
    "index": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": ""
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};