function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from "prop-types";
import moment from 'moment'; // eslint-disable-line import/named

import dateMath from '@elastic/datemath';
import { EuiDatePicker } from '../../date_picker';
import { EuiFormRow, EuiFieldText, EuiFormLabel } from '../../../form';
import { toSentenceCase } from '../../../../services/string/to_case';
export var EuiAbsoluteTab =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiAbsoluteTab, _Component);

  function EuiAbsoluteTab(props) {
    var _this;

    _classCallCheck(this, EuiAbsoluteTab);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(EuiAbsoluteTab).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "state", void 0);

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (date, event) {
      var onChange = _this.props.onChange;

      if (date === null) {
        return;
      }

      onChange(date.toISOString(), event);
      var valueAsMoment = moment(date);

      _this.setState({
        valueAsMoment: valueAsMoment,
        textInputValue: valueAsMoment.format(_this.props.dateFormat),
        isTextInvalid: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleTextChange", function (event) {
      var onChange = _this.props.onChange;
      var valueAsMoment = moment(event.target.value, _this.props.dateFormat, true);
      var dateIsValid = valueAsMoment.isValid();

      if (dateIsValid) {
        onChange(valueAsMoment.toISOString(), event);
      }

      _this.setState({
        textInputValue: event.target.value,
        isTextInvalid: !dateIsValid,
        valueAsMoment: dateIsValid ? valueAsMoment : null
      });
    });

    var sentenceCasedPosition = toSentenceCase(props.position);
    var parsedValue = dateMath.parse(props.value, {
      roundUp: props.roundUp
    });

    var _valueAsMoment = parsedValue && parsedValue.isValid() ? parsedValue : moment();

    var textInputValue = _valueAsMoment.locale(_this.props.locale || 'en').format(_this.props.dateFormat);

    _this.state = {
      isTextInvalid: false,
      sentenceCasedPosition: sentenceCasedPosition,
      textInputValue: textInputValue,
      valueAsMoment: _valueAsMoment
    };
    return _this;
  }

  _createClass(EuiAbsoluteTab, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          dateFormat = _this$props.dateFormat,
          timeFormat = _this$props.timeFormat,
          locale = _this$props.locale,
          utcOffset = _this$props.utcOffset;
      var _this$state = this.state,
          valueAsMoment = _this$state.valueAsMoment,
          isTextInvalid = _this$state.isTextInvalid,
          textInputValue = _this$state.textInputValue,
          sentenceCasedPosition = _this$state.sentenceCasedPosition;
      return React.createElement("div", null, React.createElement(EuiDatePicker, {
        inline: true,
        showTimeSelect: true,
        shadow: false,
        selected: valueAsMoment,
        onChange: this.handleChange,
        dateFormat: dateFormat,
        timeFormat: timeFormat,
        locale: locale,
        utcOffset: utcOffset
      }), React.createElement(EuiFormRow, {
        className: "euiSuperDatePicker__absoluteDateFormRow",
        isInvalid: isTextInvalid,
        error: isTextInvalid ? "Expected format ".concat(dateFormat) : undefined
      }, React.createElement(EuiFieldText, {
        compressed: true,
        isInvalid: isTextInvalid,
        value: textInputValue,
        onChange: this.handleTextChange,
        "data-test-subj": 'superDatePickerAbsoluteDateInput',
        prepend: React.createElement(EuiFormLabel, null, sentenceCasedPosition, " date")
      })));
    }
  }]);

  return EuiAbsoluteTab;
}(Component);
EuiAbsoluteTab.propTypes = {
  dateFormat: PropTypes.string.isRequired,
  timeFormat: PropTypes.string.isRequired,
  locale: PropTypes.any,
  value: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  roundUp: PropTypes.bool.isRequired,
  position: PropTypes.oneOf(["start", "end"]).isRequired,
  utcOffset: PropTypes.number
};
EuiAbsoluteTab.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "handleChange",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "date",
      "type": null
    }, {
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "handleTextChange",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiAbsoluteTab",
  "props": {
    "dateFormat": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    },
    "timeFormat": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    },
    "locale": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "value": {
      "type": {
        "name": "string"
      },
      "required": true,
      "description": ""
    },
    "onChange": {
      "type": {
        "name": "func"
      },
      "required": true,
      "description": ""
    },
    "roundUp": {
      "type": {
        "name": "bool"
      },
      "required": true,
      "description": ""
    },
    "position": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"start\"",
          "computed": false
        }, {
          "value": "\"end\"",
          "computed": false
        }]
      },
      "required": true,
      "description": ""
    },
    "utcOffset": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": ""
    }
  }
};