"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiResizablePanelContextProvider = EuiResizablePanelContextProvider;
exports.useEuiResizablePanelContext = exports.EuiResizablePanelRegistry = void 0;

var _react = _interopRequireWildcard(require("react"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var EuiResizablePanelRegistry =
/*#__PURE__*/
function () {
  function EuiResizablePanelRegistry() {
    _classCallCheck(this, EuiResizablePanelRegistry);

    _defineProperty(this, "panels", {});
  }

  _createClass(EuiResizablePanelRegistry, [{
    key: "registerPanel",
    value: function registerPanel(panel) {
      this.panels[panel.id] = panel;
    }
  }, {
    key: "deregisterPanel",
    value: function deregisterPanel(id) {
      delete this.panels[id];
    }
  }, {
    key: "getResizerSiblings",
    value: function getResizerSiblings(prevPanelId, nextPanelId) {
      return [this.panels[prevPanelId], this.panels[nextPanelId]];
    }
  }, {
    key: "fetchAllPanels",
    value: function fetchAllPanels(prevPanelId, nextPanelId, containerSize) {
      var panelWithSizes = {};

      for (var _key in this.panels) {
        if (_key !== prevPanelId && _key !== nextPanelId) {
          panelWithSizes[_key] = this.panels[_key].getSizePx() / containerSize * 100;
        }
      }

      return panelWithSizes;
    }
  }]);

  return EuiResizablePanelRegistry;
}();

exports.EuiResizablePanelRegistry = EuiResizablePanelRegistry;
var EuiResizablePanelContext = (0, _react.createContext)({});

function EuiResizablePanelContextProvider(_ref) {
  var children = _ref.children,
      registry = _ref.registry;
  return _react.default.createElement(EuiResizablePanelContext.Provider, {
    value: {
      registry: registry
    }
  }, children);
}

var useEuiResizablePanelContext = function useEuiResizablePanelContext() {
  var context = (0, _react.useContext)(EuiResizablePanelContext);

  if (!context.registry) {
    throw new Error('useEuiResizablePanelContext must be used within a <EuiResizablePanelContextProvider />');
  }

  return context;
};

exports.useEuiResizablePanelContext = useEuiResizablePanelContext;