"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkerProxyService = void 0;
const monaco_1 = require("../monaco");
const constants_1 = require("./constants");
class WorkerProxyService {
    async getAnnos(modelUri) {
        if (!this.worker) {
            throw new Error('Worker Proxy Service has not been setup!');
        }
        await this.worker.withSyncedResources([modelUri]);
        const proxy = await this.worker.getProxy();
        return proxy.parse(modelUri.toString());
    }
    setup() {
        this.worker = monaco_1.monaco.editor.createWebWorker({ label: constants_1.ID, moduleId: '' });
    }
    stop() {
        if (this.worker)
            this.worker.dispose();
    }
}
exports.WorkerProxyService = WorkerProxyService;
//# sourceMappingURL=worker_proxy_service.js.map