import * as log from '../log';
import { CompositeMarkNormalizer } from './base';
import { makeCompositeAggregatePartFactory } from './common';
import { errorBarParams } from './errorbar';
export const ERRORBAND = 'errorband';
export const ERRORBAND_PARTS = ['band', 'borders'];
export const errorBandNormalizer = new CompositeMarkNormalizer(ERRORBAND, normalizeErrorBand);
export function normalizeErrorBand(spec, { config }) {
    const { transform, continuousAxisChannelDef, continuousAxis, encodingWithoutContinuousAxis, markDef, outerSpec, tooltipEncoding } = errorBarParams(spec, ERRORBAND, config);
    const errorBandDef = markDef;
    const makeErrorBandPart = makeCompositeAggregatePartFactory(errorBandDef, continuousAxis, continuousAxisChannelDef, encodingWithoutContinuousAxis, config.errorband);
    const is2D = spec.encoding.x !== undefined && spec.encoding.y !== undefined;
    let bandMark = { type: is2D ? 'area' : 'rect' };
    let bordersMark = { type: is2D ? 'line' : 'rule' };
    const interpolate = Object.assign(Object.assign({}, (errorBandDef.interpolate ? { interpolate: errorBandDef.interpolate } : {})), (errorBandDef.tension && errorBandDef.interpolate ? { tension: errorBandDef.tension } : {}));
    if (is2D) {
        bandMark = Object.assign(Object.assign(Object.assign({}, bandMark), interpolate), { ariaRoleDescription: 'errorband' });
        bordersMark = Object.assign(Object.assign({}, bordersMark), interpolate);
    }
    else if (errorBandDef.interpolate) {
        log.warn(log.message.errorBand1DNotSupport('interpolate'));
    }
    else if (errorBandDef.tension) {
        log.warn(log.message.errorBand1DNotSupport('tension'));
    }
    return Object.assign(Object.assign({}, outerSpec), { transform, layer: [
            ...makeErrorBandPart({
                partName: 'band',
                mark: bandMark,
                positionPrefix: 'lower',
                endPositionPrefix: 'upper',
                extraEncoding: tooltipEncoding
            }),
            ...makeErrorBandPart({
                partName: 'borders',
                mark: bordersMark,
                positionPrefix: 'lower',
                aria: false,
                extraEncoding: tooltipEncoding
            }),
            ...makeErrorBandPart({
                partName: 'borders',
                mark: bordersMark,
                positionPrefix: 'upper',
                aria: false,
                extraEncoding: tooltipEncoding
            })
        ] });
}
//# sourceMappingURL=errorband.js.map