function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { i18n } from '@kbn/i18n';
import { I18nProvider } from '@kbn/i18n/react';
import { DashboardCloneModal } from './clone_modal';
export function showCloneModal(onClone, title) {
  var container = document.createElement('div');

  var closeModal = function closeModal() {
    ReactDOM.unmountComponentAtNode(container);
    document.body.removeChild(container);
  };

  var onCloneConfirmed = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) {
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              onClone(newTitle, isTitleDuplicateConfirmed, onTitleDuplicate).then(function (response) {
                // The only time you don't want to close the modal is if it's asking you
                // to confirm a duplicate title, in which case there will be no error and no id.
                if (response.error || response.id) {
                  closeModal();
                }
              });

            case 1:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function onCloneConfirmed(_x, _x2, _x3) {
      return _ref.apply(this, arguments);
    };
  }();

  document.body.appendChild(container);
  var element = /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(DashboardCloneModal, {
    onClone: onCloneConfirmed,
    onClose: closeModal,
    title: i18n.translate('dashboard.topNav.showCloneModal.dashboardCopyTitle', {
      defaultMessage: '{title} Copy',
      values: {
        title: title
      }
    })
  }));
  ReactDOM.render(element, container);
}