function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { getEmptyValueSuggestions, setupValueSuggestionProvider } from './providers/value_suggestion_provider';
export var AutocompleteService = /*#__PURE__*/function () {
  function AutocompleteService(initializerContext) {
    var _this = this;

    _classCallCheck(this, AutocompleteService);

    _defineProperty(this, "autocompleteConfig", void 0);

    _defineProperty(this, "querySuggestionProviders", new Map());

    _defineProperty(this, "getValueSuggestions", void 0);

    _defineProperty(this, "addQuerySuggestionProvider", function (language, provider) {
      if (language && provider && _this.autocompleteConfig.querySuggestions.enabled) {
        _this.querySuggestionProviders.set(language, provider);
      }
    });

    _defineProperty(this, "getQuerySuggestions", function (args) {
      var language = args.language;

      var provider = _this.querySuggestionProviders.get(language);

      if (provider) {
        return provider(args);
      }
    });

    _defineProperty(this, "hasQuerySuggestions", function (language) {
      return _this.querySuggestionProviders.has(language);
    });

    var _initializerContext$c = initializerContext.config.get(),
        autocomplete = _initializerContext$c.autocomplete;

    this.autocompleteConfig = autocomplete;
  }

  _createClass(AutocompleteService, [{
    key: "setup",

    /** @public **/
    value: function setup(core) {
      this.getValueSuggestions = this.autocompleteConfig.valueSuggestions.enabled ? setupValueSuggestionProvider(core) : getEmptyValueSuggestions;
      return {
        addQuerySuggestionProvider: this.addQuerySuggestionProvider,

        /** @obsolete **/

        /** please use "getProvider" only from the start contract **/
        getQuerySuggestions: this.getQuerySuggestions
      };
    }
    /** @public **/

  }, {
    key: "start",
    value: function start() {
      return {
        getQuerySuggestions: this.getQuerySuggestions,
        hasQuerySuggestions: this.hasQuerySuggestions,
        getValueSuggestions: this.getValueSuggestions
      };
    }
    /** @internal **/

  }, {
    key: "clearProviders",
    value: function clearProviders() {
      this.querySuggestionProviders.clear();
    }
  }]);

  return AutocompleteService;
}();
/** @public **/