function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './index.scss';
import { Storage, createStartServicesGetter } from '../../kibana_utils/public';
import { AutocompleteService } from './autocomplete';
import { SearchService } from './search/search_service';
import { FieldFormatsService } from './field_formats';
import { QueryService } from './query';
import { createIndexPatternSelect } from './ui/index_pattern_select';
import { IndexPatternsService, onRedirectNoIndexPattern, onUnsupportedTimePattern, IndexPatternsApiClient, UiSettingsPublicToCommon } from './index_patterns';
import { setFieldFormats, setHttp, setIndexPatterns, setInjectedMetadata, setNotifications, setOverlays, setQueryService, setSearchService, setUiSettings } from './services';
import { createSearchBar } from './ui/search_bar/create_search_bar';
import { esaggs } from './search/expressions';
import { SELECT_RANGE_TRIGGER, VALUE_CLICK_TRIGGER, APPLY_FILTER_TRIGGER } from '../../ui_actions/public';
import { ACTION_GLOBAL_APPLY_FILTER, createFilterAction, createFiltersFromValueClickAction, createFiltersFromRangeSelectAction } from './actions';
import { selectRangeAction, ACTION_SELECT_RANGE } from './actions/select_range_action';
import { valueClickAction, ACTION_VALUE_CLICK } from './actions/value_click_action';
import { SavedObjectsClientPublicToCommon } from './index_patterns';
import { indexPatternLoad } from './index_patterns/expressions/load_index_pattern';
export var DataPublicPlugin = /*#__PURE__*/function () {
  function DataPublicPlugin(initializerContext) {
    _classCallCheck(this, DataPublicPlugin);

    _defineProperty(this, "autocomplete", void 0);

    _defineProperty(this, "searchService", void 0);

    _defineProperty(this, "fieldFormatsService", void 0);

    _defineProperty(this, "queryService", void 0);

    _defineProperty(this, "storage", void 0);

    _defineProperty(this, "packageInfo", void 0);

    this.searchService = new SearchService();
    this.queryService = new QueryService();
    this.fieldFormatsService = new FieldFormatsService();
    this.autocomplete = new AutocompleteService(initializerContext);
    this.storage = new Storage(window.localStorage);
    this.packageInfo = initializerContext.env.packageInfo;
  }

  _createClass(DataPublicPlugin, [{
    key: "setup",
    value: function setup(core, _ref) {
      var expressions = _ref.expressions,
          uiActions = _ref.uiActions,
          usageCollection = _ref.usageCollection;
      var startServices = createStartServicesGetter(core.getStartServices);

      var getInternalStartServices = function getInternalStartServices() {
        var _startServices = startServices(),
            coreStart = _startServices.core,
            self = _startServices.self;

        return {
          fieldFormats: self.fieldFormats,
          notifications: coreStart.notifications,
          uiSettings: coreStart.uiSettings,
          searchService: self.search,
          injectedMetadata: coreStart.injectedMetadata
        };
      };

      expressions.registerFunction(esaggs);
      expressions.registerFunction(indexPatternLoad);
      var queryService = this.queryService.setup({
        uiSettings: core.uiSettings,
        storage: this.storage
      });
      uiActions.registerAction(createFilterAction(queryService.filterManager, queryService.timefilter.timefilter));
      uiActions.addTriggerAction(SELECT_RANGE_TRIGGER, selectRangeAction(queryService.filterManager, queryService.timefilter.timefilter));
      uiActions.addTriggerAction(VALUE_CLICK_TRIGGER, valueClickAction(queryService.filterManager, queryService.timefilter.timefilter));
      return {
        autocomplete: this.autocomplete.setup(core),
        search: this.searchService.setup(core, {
          expressions: expressions,
          usageCollection: usageCollection,
          getInternalStartServices: getInternalStartServices,
          packageInfo: this.packageInfo
        }),
        fieldFormats: this.fieldFormatsService.setup(core),
        query: queryService
      };
    }
  }, {
    key: "start",
    value: function start(core, _ref2) {
      var uiActions = _ref2.uiActions;
      var uiSettings = core.uiSettings,
          http = core.http,
          notifications = core.notifications,
          savedObjects = core.savedObjects,
          overlays = core.overlays,
          application = core.application;
      setHttp(http);
      setNotifications(notifications);
      setOverlays(overlays);
      setUiSettings(uiSettings);
      setInjectedMetadata(core.injectedMetadata);
      var fieldFormats = this.fieldFormatsService.start();
      setFieldFormats(fieldFormats);
      var indexPatterns = new IndexPatternsService({
        uiSettings: new UiSettingsPublicToCommon(uiSettings),
        savedObjectsClient: new SavedObjectsClientPublicToCommon(savedObjects.client),
        apiClient: new IndexPatternsApiClient(http),
        fieldFormats: fieldFormats,
        onNotification: function onNotification(toastInputFields) {
          notifications.toasts.add(toastInputFields);
        },
        onError: notifications.toasts.addError,
        onRedirectNoIndexPattern: onRedirectNoIndexPattern(application.capabilities, application.navigateToApp, overlays),
        onUnsupportedTimePattern: onUnsupportedTimePattern(notifications.toasts, application.navigateToApp)
      });
      setIndexPatterns(indexPatterns);
      var query = this.queryService.start({
        storage: this.storage,
        savedObjectsClient: savedObjects.client,
        uiSettings: uiSettings
      });
      setQueryService(query);
      var search = this.searchService.start(core, {
        indexPatterns: indexPatterns
      });
      setSearchService(search);
      uiActions.addTriggerAction(APPLY_FILTER_TRIGGER, uiActions.getAction(ACTION_GLOBAL_APPLY_FILTER));
      var dataServices = {
        actions: {
          createFiltersFromValueClickAction: createFiltersFromValueClickAction,
          createFiltersFromRangeSelectAction: createFiltersFromRangeSelectAction
        },
        autocomplete: this.autocomplete.start(),
        fieldFormats: fieldFormats,
        indexPatterns: indexPatterns,
        query: query,
        search: search
      };
      var SearchBar = createSearchBar({
        core: core,
        data: dataServices,
        storage: this.storage
      });
      return _objectSpread(_objectSpread({}, dataServices), {}, {
        ui: {
          IndexPatternSelect: createIndexPatternSelect(core.savedObjects.client),
          SearchBar: SearchBar
        }
      });
    }
  }, {
    key: "stop",
    value: function stop() {
      this.autocomplete.clearProviders();
    }
  }]);

  return DataPublicPlugin;
}();