function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import * as Rx from 'rxjs';
import { map } from 'rxjs/operators';

var defaultIsDuplicate = function defaultIsDuplicate(oldItem, newItem) {
  return _.isEqual(oldItem, newItem);
};

export var PersistedLog = /*#__PURE__*/function () {
  function PersistedLog(name) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var storage = arguments.length > 2 ? arguments[2] : undefined;

    _classCallCheck(this, PersistedLog);

    _defineProperty(this, "name", void 0);

    _defineProperty(this, "maxLength", void 0);

    _defineProperty(this, "filterDuplicates", void 0);

    _defineProperty(this, "isDuplicate", void 0);

    _defineProperty(this, "storage", void 0);

    _defineProperty(this, "items", void 0);

    _defineProperty(this, "update$", new Rx.BehaviorSubject(undefined));

    this.name = name;
    this.maxLength = typeof options.maxLength === 'string' ? this.maxLength = parseInt(options.maxLength, 10) : options.maxLength;
    this.filterDuplicates = options.filterDuplicates || false;
    this.isDuplicate = options.isDuplicate || defaultIsDuplicate;
    this.storage = storage;
    this.items = this.storage.get(this.name) || [];

    if (this.maxLength !== undefined && !isNaN(this.maxLength)) {
      this.items = _.take(this.items, this.maxLength);
    }
  }

  _createClass(PersistedLog, [{
    key: "add",
    value: function add(val) {
      var _this = this;

      if (val == null) {
        return this.items;
      } // remove any matching items from the stack if option is set


      if (this.filterDuplicates) {
        _.remove(this.items, function (item) {
          return _this.isDuplicate(item, val);
        });
      }

      this.items.unshift(val); // if maxLength is set, truncate the stack

      if (this.maxLength && !isNaN(this.maxLength)) {
        this.items = _.take(this.items, this.maxLength);
      } // persist the stack


      this.storage.set(this.name, this.items);
      this.update$.next(undefined);
      return this.items;
    }
  }, {
    key: "get",
    value: function get() {
      return _.cloneDeep(this.items);
    }
  }, {
    key: "get$",
    value: function get$() {
      var _this2 = this;

      return this.update$.pipe(map(function () {
        return _this2.get();
      }));
    }
  }]);

  return PersistedLog;
}();