function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiButtonEmpty, EuiFlexGroup, EuiFlexItem, EuiPopover } from '@elastic/eui';
import { FormattedMessage, injectI18n } from '@kbn/i18n/react';
import classNames from 'classnames';
import React, { useState } from 'react';
import { FilterEditor } from './filter_editor';
import { FilterItem } from './filter_item';
import { FilterOptions } from './filter_options';
import { useKibana } from '../../../../kibana_react/public';
import { buildEmptyFilter, enableFilter, disableFilter, pinFilter, toggleFilterDisabled, toggleFilterNegated, unpinFilter, UI_SETTINGS } from '../../../common';

function FilterBarUI(props) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isAddFilterPopoverOpen = _useState2[0],
      setIsAddFilterPopoverOpen = _useState2[1];

  var kibana = useKibana();
  var uiSettings = kibana.services.uiSettings;
  if (!uiSettings) return null;

  function onFiltersUpdated(filters) {
    if (props.onFiltersUpdated) {
      props.onFiltersUpdated(filters);
    }
  }

  function renderItems() {
    return props.filters.map(function (filter, i) {
      return /*#__PURE__*/React.createElement(EuiFlexItem, {
        key: i,
        grow: false,
        className: "globalFilterBar__flexItem"
      }, /*#__PURE__*/React.createElement(FilterItem, {
        id: "".concat(i),
        intl: props.intl,
        filter: filter,
        onUpdate: function onUpdate(newFilter) {
          return _onUpdate(i, newFilter);
        },
        onRemove: function onRemove() {
          return _onRemove(i);
        },
        indexPatterns: props.indexPatterns,
        uiSettings: uiSettings
      }));
    });
  }

  function renderAddFilter() {
    var isPinned = uiSettings.get(UI_SETTINGS.FILTERS_PINNED_BY_DEFAULT);

    var _props$indexPatterns = _slicedToArray(props.indexPatterns, 1),
        indexPattern = _props$indexPatterns[0];

    var index = indexPattern && indexPattern.id;
    var newFilter = buildEmptyFilter(isPinned, index);
    var button = /*#__PURE__*/React.createElement(EuiButtonEmpty, {
      size: "xs",
      onClick: function onClick() {
        return setIsAddFilterPopoverOpen(true);
      },
      "data-test-subj": "addFilter",
      className: "globalFilterBar__addButton"
    }, "+", ' ', /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "data.filter.filterBar.addFilterButtonLabel",
      defaultMessage: "Add filter"
    }));
    return /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiPopover, {
      id: "addFilterPopover",
      button: button,
      isOpen: isAddFilterPopoverOpen,
      closePopover: function closePopover() {
        return setIsAddFilterPopoverOpen(false);
      },
      anchorPosition: "downLeft",
      withTitle: true,
      panelPaddingSize: "none",
      ownFocus: true,
      initialFocus: ".filterEditor__hiddenItem",
      repositionOnScroll: true
    }, /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement("div", {
      style: {
        width: 400
      }
    }, /*#__PURE__*/React.createElement(FilterEditor, {
      filter: newFilter,
      indexPatterns: props.indexPatterns,
      onSubmit: onAdd,
      onCancel: function onCancel() {
        return setIsAddFilterPopoverOpen(false);
      },
      key: JSON.stringify(newFilter)
    })))));
  }

  function onAdd(filter) {
    setIsAddFilterPopoverOpen(false);
    var filters = [].concat(_toConsumableArray(props.filters), [filter]);
    onFiltersUpdated(filters);
  }

  function _onRemove(i) {
    var filters = _toConsumableArray(props.filters);

    filters.splice(i, 1);
    onFiltersUpdated(filters);
  }

  function _onUpdate(i, filter) {
    var filters = _toConsumableArray(props.filters);

    filters[i] = filter;
    onFiltersUpdated(filters);
  }

  function onEnableAll() {
    var filters = props.filters.map(enableFilter);
    onFiltersUpdated(filters);
  }

  function onDisableAll() {
    var filters = props.filters.map(disableFilter);
    onFiltersUpdated(filters);
  }

  function onPinAll() {
    var filters = props.filters.map(pinFilter);
    onFiltersUpdated(filters);
  }

  function onUnpinAll() {
    var filters = props.filters.map(unpinFilter);
    onFiltersUpdated(filters);
  }

  function onToggleAllNegated() {
    var filters = props.filters.map(toggleFilterNegated);
    onFiltersUpdated(filters);
  }

  function onToggleAllDisabled() {
    var filters = props.filters.map(toggleFilterDisabled);
    onFiltersUpdated(filters);
  }

  function onRemoveAll() {
    onFiltersUpdated([]);
  }

  var classes = classNames('globalFilterBar', props.className);
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    className: "globalFilterGroup",
    gutterSize: "none",
    alignItems: "flexStart",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    className: "globalFilterGroup__branch",
    grow: false
  }, /*#__PURE__*/React.createElement(FilterOptions, {
    onEnableAll: onEnableAll,
    onDisableAll: onDisableAll,
    onPinAll: onPinAll,
    onUnpinAll: onUnpinAll,
    onToggleAllNegated: onToggleAllNegated,
    onToggleAllDisabled: onToggleAllDisabled,
    onRemoveAll: onRemoveAll
  })), /*#__PURE__*/React.createElement(EuiFlexItem, {
    className: "globalFilterGroup__filterFlexItem"
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    className: classes,
    wrap: true,
    responsive: false,
    gutterSize: "xs",
    alignItems: "center"
  }, renderItems(), renderAddFilter())));
}

export var FilterBar = injectI18n(FilterBarUI);