function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useState, useEffect } from 'react';
import { i18n } from '@kbn/i18n';
import { populateStateFromSavedQuery } from './populate_state_from_saved_query';
import { clearStateFromSavedQuery } from './clear_saved_query';
export var useSavedQuery = function useSavedQuery(props) {
  // Handle saved queries
  var defaultLanguage = props.defaultLanguage;

  var _useState = useState(),
      _useState2 = _slicedToArray(_useState, 2),
      savedQuery = _useState2[0],
      _setSavedQuery = _useState2[1]; // Effect is used to convert a saved query id into an object


  useEffect(function () {
    var fetchSavedQuery = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(savedQueryId) {
        var newSavedQuery;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return props.queryService.savedQueries.getSavedQuery(savedQueryId);

              case 3:
                newSavedQuery = _context.sent;

                // Make sure we set the saved query to the most recent one
                if (newSavedQuery && newSavedQuery.id === savedQueryId) {
                  _setSavedQuery(newSavedQuery);

                  populateStateFromSavedQuery(props.queryService, props.setQuery, newSavedQuery);
                }

                _context.next = 12;
                break;

              case 7:
                _context.prev = 7;
                _context.t0 = _context["catch"](0);

                // Clear saved query
                _setSavedQuery(undefined);

                clearStateFromSavedQuery(props.queryService, props.setQuery, defaultLanguage); // notify of saving error

                props.notifications.toasts.addWarning({
                  title: i18n.translate('data.search.unableToGetSavedQueryToastTitle', {
                    defaultMessage: 'Unable to load saved query {savedQueryId}',
                    values: {
                      savedQueryId: savedQueryId
                    }
                  }),
                  text: "".concat(_context.t0.message)
                });

              case 12:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 7]]);
      }));

      return function fetchSavedQuery(_x) {
        return _ref.apply(this, arguments);
      };
    }();

    if (props.savedQueryId) fetchSavedQuery(props.savedQueryId);else _setSavedQuery(undefined);
  }, [defaultLanguage, props.notifications.toasts, props.queryService, props.queryService.savedQueries, props.savedQueryId, props.setQuery]);
  return {
    savedQuery: savedQuery,
    setSavedQuery: function setSavedQuery(q) {
      _setSavedQuery(q);

      populateStateFromSavedQuery(props.queryService, props.setQuery, q);
    },
    clearSavedQuery: function clearSavedQuery() {
      _setSavedQuery(undefined);

      clearStateFromSavedQuery(props.queryService, props.setQuery, defaultLanguage);
    }
  };
};