/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { uniq } from 'lodash';
export var buildPointSeriesData = function buildPointSeriesData(table, dimensions) {
  var x = dimensions.x,
      y = dimensions.y;
  var xAccessor = table.columns[x.accessor].id;
  var yAccessor = table.columns[y.accessor].id;
  var chart = {};
  chart.xAxisOrderedValues = uniq(table.rows.map(function (r) {
    return r[xAccessor];
  }));
  chart.xAxisFormat = x.format;
  chart.xAxisLabel = table.columns[x.accessor].name;
  var _x$params = x.params,
      intervalESUnit = _x$params.intervalESUnit,
      intervalESValue = _x$params.intervalESValue,
      interval = _x$params.interval,
      bounds = _x$params.bounds;
  chart.ordered = {
    date: true,
    interval: interval,
    intervalESUnit: intervalESUnit,
    intervalESValue: intervalESValue,
    min: bounds.min,
    max: bounds.max
  };
  chart.yAxisLabel = table.columns[y.accessor].name;
  chart.values = table.rows.filter(function (row) {
    return row && row[yAccessor] !== 'NaN';
  }).map(function (row) {
    return {
      x: row[xAccessor],
      y: row[yAccessor]
    };
  });
  return chart;
};