/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiText, EuiButtonIcon, EuiFlexGroup, EuiFlexItem, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { StringFieldProgressBar } from './string_progress_bar';
import './discover_field_bucket.scss';
export function DiscoverFieldBucket(_ref) {
  var field = _ref.field,
      bucket = _ref.bucket,
      onAddFilter = _ref.onAddFilter;
  var emptyTxt = i18n.translate('discover.fieldChooser.detailViews.emptyStringText', {
    defaultMessage: 'Empty string'
  });
  var addLabel = i18n.translate('discover.fieldChooser.detailViews.filterValueButtonAriaLabel', {
    defaultMessage: 'Filter for {field}: "{value}"',
    values: {
      value: bucket.value,
      field: field.name
    }
  });
  var removeLabel = i18n.translate('discover.fieldChooser.detailViews.filterOutValueButtonAriaLabel', {
    defaultMessage: 'Filter out {field}: "{value}"',
    values: {
      value: bucket.value,
      field: field.name
    }
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    className: "dscFieldDetails__barContainer",
    grow: 1
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: 1,
    className: "eui-textTruncate"
  }, /*#__PURE__*/React.createElement(EuiText, {
    title: bucket.display === '' ? emptyTxt : "".concat(bucket.display, ": ").concat(bucket.count, " (").concat(bucket.percent, "%)"),
    size: "xs",
    className: "eui-textTruncate"
  }, bucket.display === '' ? emptyTxt : bucket.display)), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate"
  }, /*#__PURE__*/React.createElement(EuiText, {
    color: "secondary",
    size: "xs",
    className: "eui-textTruncate"
  }, bucket.percent, "%"))), /*#__PURE__*/React.createElement(StringFieldProgressBar, {
    value: bucket.value,
    percent: bucket.percent,
    count: bucket.count
  })), field.filterable && /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiButtonIcon, {
    iconSize: "s",
    iconType: "plusInCircle",
    onClick: function onClick() {
      return onAddFilter(field, bucket.value, '+');
    },
    "aria-label": addLabel,
    "data-test-subj": "plus-".concat(field.name, "-").concat(bucket.value),
    style: {
      minHeight: 'auto',
      minWidth: 'auto',
      paddingRight: 2,
      paddingLeft: 2,
      paddingTop: 0,
      paddingBottom: 0
    }
  }), /*#__PURE__*/React.createElement(EuiButtonIcon, {
    iconSize: "s",
    iconType: "minusInCircle",
    onClick: function onClick() {
      return onAddFilter(field, bucket.value, '-');
    },
    "aria-label": removeLabel,
    "data-test-subj": "minus-".concat(field.name, "-").concat(bucket.value),
    style: {
      minHeight: 'auto',
      minWidth: 'auto',
      paddingTop: 0,
      paddingBottom: 0,
      paddingRight: 2,
      paddingLeft: 2
    }
  })))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }));
}