/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// eslint-disable-next-line
import { uiActionsPluginMock } from '../../../ui_actions/public/mocks'; // eslint-disable-next-line

import { inspectorPluginMock } from '../../../inspector/public/mocks';
import { dataPluginMock } from '../../../data/public/mocks';
import { coreMock } from '../../../../core/public/mocks';
import { EmbeddablePublicPlugin } from '../plugin';
export var testPlugin = function testPlugin() {
  var coreSetup = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : coreMock.createSetup();
  var coreStart = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : coreMock.createStart();
  var uiActions = uiActionsPluginMock.createPlugin(coreSetup, coreStart);
  var initializerContext = {};
  var plugin = new EmbeddablePublicPlugin(initializerContext);
  var setup = plugin.setup(coreSetup, {
    data: dataPluginMock.createSetupContract(),
    uiActions: uiActions.setup
  });
  return {
    plugin: plugin,
    coreSetup: coreSetup,
    coreStart: coreStart,
    setup: setup,
    doStart: function doStart() {
      var anotherCoreStart = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : coreStart;
      var start = plugin.start(anotherCoreStart, {
        data: dataPluginMock.createStartContract(),
        inspector: inspectorPluginMock.createStartContract(),
        uiActions: uiActionsPluginMock.createStartContract()
      });
      return start;
    },
    uiActions: uiActions.doStart(coreStart)
  };
};