/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiButton, EuiButtonEmpty } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
export var ActionButtons = function ActionButtons(_ref) {
  var goToPreviousStep = _ref.goToPreviousStep,
      submittable = _ref.submittable,
      createIndexPattern = _ref.createIndexPattern;
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    iconType: "arrowLeft",
    onClick: goToPreviousStep
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.stepTime.backButton",
    defaultMessage: "Back"
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, {
    isDisabled: !submittable,
    "data-test-subj": "createIndexPatternButton",
    fill: true,
    onClick: createIndexPattern
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.stepTime.createPatternButton",
    defaultMessage: "Create index pattern"
  }))));
};