/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiForm, EuiFormRow, EuiFieldText, EuiButtonEmpty, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
export var AdvancedOptions = function AdvancedOptions(_ref) {
  var isVisible = _ref.isVisible,
      indexPatternId = _ref.indexPatternId,
      toggleAdvancedOptions = _ref.toggleAdvancedOptions,
      onChangeIndexPatternId = _ref.onChangeIndexPatternId;
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    iconType: isVisible ? 'arrowDown' : 'arrowRight',
    onClick: toggleAdvancedOptions
  }, isVisible ? /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.stepTime.options.hideButton",
    defaultMessage: "Hide advanced options"
  }) : /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.stepTime.options.showButton",
    defaultMessage: "Show advanced options"
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "xs"
  }), isVisible ? /*#__PURE__*/React.createElement(EuiForm, null, /*#__PURE__*/React.createElement(EuiFormRow, {
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.createIndexPattern.stepTime.options.patternHeader",
      defaultMessage: "Custom index pattern ID"
    }),
    helpText: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "indexPatternManagement.createIndexPattern.stepTime.options.patternLabel",
      defaultMessage: "Kibana will provide a unique identifier for each index pattern. If you do not want to use this unique ID, enter a custom one."
    })
  }, /*#__PURE__*/React.createElement(EuiFieldText, {
    name: "indexPatternId",
    "data-test-subj": "createIndexPatternIdInput",
    value: indexPatternId,
    onChange: onChangeIndexPatternId,
    placeholder: i18n.translate('indexPatternManagement.createIndexPattern.stepTime.options.patternPlaceholder', {
      defaultMessage: 'custom-index-pattern-id'
    })
  }))) : null);
};