function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiSpacer } from '@elastic/eui';
import { getSupportedScriptingLanguages, getDeprecatedScriptingLanguages } from '../../../scripting_languages';
import { Table, Header, CallOuts, DeleteScritpedFieldConfirmationModal } from './components';
export var ScriptedFieldsTable = /*#__PURE__*/function (_Component) {
  _inherits(ScriptedFieldsTable, _Component);

  var _super = _createSuper(ScriptedFieldsTable);

  function ScriptedFieldsTable(props) {
    var _this;

    _classCallCheck(this, ScriptedFieldsTable);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "fetchFields", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var fields, deprecatedLangsInUse, deprecatedLangs, supportedLangs, _iterator, _step, field, lang;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return _this.props.indexPattern.getScriptedFields();

            case 2:
              fields = _context.sent;
              deprecatedLangsInUse = [];
              deprecatedLangs = getDeprecatedScriptingLanguages();
              supportedLangs = getSupportedScriptingLanguages();
              _iterator = _createForOfIteratorHelper(fields);

              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  field = _step.value;
                  lang = field.lang;

                  if (deprecatedLangs.includes(lang) || !supportedLangs.includes(lang)) {
                    deprecatedLangsInUse.push(lang);
                  }
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }

              _this.setState({
                fields: fields,
                deprecatedLangsInUse: deprecatedLangsInUse
              });

            case 9:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "getFilteredItems", function () {
      var fields = _this.state.fields;
      var _this$props = _this.props,
          fieldFilter = _this$props.fieldFilter,
          scriptedFieldLanguageFilter = _this$props.scriptedFieldLanguageFilter;
      var languageFilteredFields = fields;

      if (scriptedFieldLanguageFilter) {
        languageFilteredFields = fields.filter(function (field) {
          return field.lang === _this.props.scriptedFieldLanguageFilter;
        });
      }

      var filteredFields = languageFilteredFields;

      if (fieldFilter) {
        var normalizedFieldFilter = fieldFilter.toLowerCase();
        filteredFields = languageFilteredFields.filter(function (field) {
          return field.name.toLowerCase().includes(normalizedFieldFilter);
        });
      }

      return filteredFields;
    });

    _defineProperty(_assertThisInitialized(_this), "startDeleteField", function (field) {
      _this.setState({
        fieldToDelete: field,
        isDeleteConfirmationModalVisible: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "hideDeleteConfirmationModal", function () {
      _this.setState({
        fieldToDelete: undefined,
        isDeleteConfirmationModalVisible: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "deleteField", function () {
      var _this$props2 = _this.props,
          indexPattern = _this$props2.indexPattern,
          onRemoveField = _this$props2.onRemoveField;
      var fieldToDelete = _this.state.fieldToDelete;
      indexPattern.removeScriptedField(fieldToDelete);

      if (onRemoveField) {
        onRemoveField();
      }

      _this.fetchFields();

      _this.hideDeleteConfirmationModal();
    });

    _this.state = {
      deprecatedLangsInUse: [],
      fieldToDelete: undefined,
      isDeleteConfirmationModalVisible: false,
      fields: []
    };
    return _this;
  }

  _createClass(ScriptedFieldsTable, [{
    key: "UNSAFE_componentWillMount",
    value: function UNSAFE_componentWillMount() {
      this.fetchFields();
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props3 = this.props,
          indexPattern = _this$props3.indexPattern,
          painlessDocLink = _this$props3.painlessDocLink;
      var _this$state = this.state,
          fieldToDelete = _this$state.fieldToDelete,
          deprecatedLangsInUse = _this$state.deprecatedLangsInUse;
      var items = this.getFilteredItems();
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Header, {
        indexPatternId: indexPattern.id || ''
      }), /*#__PURE__*/React.createElement(CallOuts, {
        deprecatedLangsInUse: deprecatedLangsInUse,
        painlessDocLink: painlessDocLink
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/React.createElement(Table, {
        indexPattern: indexPattern,
        items: items,
        editField: function editField(field) {
          return _this2.props.helpers.redirectToRoute(field);
        },
        deleteField: this.startDeleteField
      }), fieldToDelete && /*#__PURE__*/React.createElement(DeleteScritpedFieldConfirmationModal, {
        deleteField: this.deleteField,
        field: fieldToDelete,
        hideDeleteConfirmationModal: this.hideDeleteConfirmationModal
      }));
    }
  }]);

  return ScriptedFieldsTable;
}(Component);