function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import url from 'url';
import { CREATE_PATH, getGotoPath } from '../../common/short_url_routes';
export function shortenUrl(_x, _x2) {
  return _shortenUrl.apply(this, arguments);
}

function _shortenUrl() {
  _shortenUrl = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(absoluteUrl, _ref) {
    var basePath, post, parsedUrl, path, hash, relativeUrl, body, resp;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            basePath = _ref.basePath, post = _ref.post;
            parsedUrl = url.parse(absoluteUrl);

            if (!(!parsedUrl || !parsedUrl.path)) {
              _context.next = 4;
              break;
            }

            return _context.abrupt("return");

          case 4:
            path = parsedUrl.path.replace(basePath, '');
            hash = parsedUrl.hash ? parsedUrl.hash : '';
            relativeUrl = path + hash;
            body = JSON.stringify({
              url: relativeUrl
            });
            _context.next = 10;
            return post(CREATE_PATH, {
              body: body
            });

          case 10:
            resp = _context.sent;
            return _context.abrupt("return", url.format({
              protocol: parsedUrl.protocol,
              host: parsedUrl.host,
              pathname: "".concat(basePath).concat(getGotoPath(resp.urlId))
            }));

          case 12:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _shortenUrl.apply(this, arguments);
}