/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect } from 'react';
import { EuiFormRow, EuiSelect } from '@elastic/eui';
import { i18n } from '@kbn/i18n';

function OrderParamEditor(_ref) {
  var aggParam = _ref.aggParam,
      value = _ref.value,
      showValidation = _ref.showValidation,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      setTouched = _ref.setTouched;
  var label = i18n.translate('visDefaultEditor.controls.orderLabel', {
    defaultMessage: 'Order'
  });
  var isValid = !!value;
  useEffect(function () {
    setValidity(isValid);
  }, [isValid, setValidity]); // @ts-ignore

  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiSelect, {
    options: aggParam.options,
    value: value && value.value,
    onChange: function onChange(ev) {
      return setValue(aggParam.options.find(function (opt) {
        return opt.value === ev.target.value;
      }));
    },
    fullWidth: true,
    compressed: true,
    isInvalid: showValidation ? !isValid : false,
    onBlur: setTouched
  }));
}

export { OrderParamEditor };