/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiPanel, EuiTitle, EuiLink, EuiIcon, EuiTextArea, EuiFlexGroup, EuiFlexItem, EuiText } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';

function MarkdownOptions(_ref) {
  var stateParams = _ref.stateParams,
      setValue = _ref.setValue;
  var onMarkdownUpdate = useCallback(function (value) {
    return setValue('markdown', value);
  }, [setValue]);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    className: "mkdEditor"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement("label", {
    htmlFor: "markdownVisInput"
  }, "Markdown")))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiText, {
    size: "xs"
  }, /*#__PURE__*/React.createElement(EuiLink, {
    href: "https://help.github.com/articles/github-flavored-markdown/",
    target: "_blank"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeMarkdown.params.helpLinkLabel",
    defaultMessage: "Help"
  }), ' ', /*#__PURE__*/React.createElement(EuiIcon, {
    type: "popout",
    size: "s"
  })))))), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiTextArea, {
    id: "markdownVisInput",
    className: "visEditor--markdown__textarea",
    value: stateParams.markdown,
    onChange: function onChange(_ref2) {
      var value = _ref2.target.value;
      return onMarkdownUpdate(value);
    },
    fullWidth: true,
    "data-test-subj": "markdownTextarea",
    resize: "none"
  }))));
}

export { MarkdownOptions };