/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiPanel } from '@elastic/eui';
import { TimelionInterval, TimelionExpressionInput } from './components';

function TimelionOptions(_ref) {
  var stateParams = _ref.stateParams,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity;
  var setInterval = useCallback(function (value) {
    return setValue('interval', value);
  }, [setValue]);
  var setExpressionInput = useCallback(function (value) {
    return setValue('expression', value);
  }, [setValue]);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    className: "visEditorSidebar__timelionOptions",
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(TimelionInterval, {
    value: stateParams.interval,
    setValue: setInterval,
    setValidity: setValidity
  }), /*#__PURE__*/React.createElement(TimelionExpressionInput, {
    value: stateParams.expression,
    setValue: setExpressionInput
  }));
}

export { TimelionOptions };