/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import moment from 'moment';

export default {
  rows: [
    {
      label: '0.0-1000.0: bytes',
      xAxisLabel: '@timestamp per 30 sec',
      ordered: {
        date: true,
        interval: 30000,
        min: 1415826260456,
        max: 1415827160456,
      },
      yAxisLabel: 'Count of documents',
      xAxisFormatter: function (thing) {
        return moment(thing);
      },
      tooltipFormatter: function (d) {
        return d;
      },
      series: [
        {
          label: 'jpg',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826660000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827020000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827110000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
        {
          label: 'css',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826660000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827020000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415827110000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
        {
          label: 'png',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826660000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827020000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827110000,
              y: 1,
              y0: 1,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
        {
          label: 'php',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826660000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827020000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827110000,
              y: 0,
              y0: 2,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
        {
          label: 'gif',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 3,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826660000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 1,
              y0: 1,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827020000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 1,
              y0: 1,
            },
            {
              x: 1415827110000,
              y: 1,
              y0: 2,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
      ],
    },
    {
      label: '1000.0-2000.0: bytes',
      xAxisLabel: '@timestamp per 30 sec',
      ordered: {
        date: true,
        interval: 30000,
        min: 1415826260457,
        max: 1415827160457,
      },
      yAxisLabel: 'Count of documents',
      xAxisFormatter: function (thing) {
        return moment(thing);
      },
      tooltipFormatter: function (d) {
        return d;
      },
      series: [
        {
          label: 'jpg',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826660000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826810000,
              y: 2,
              y0: 0,
            },
            {
              x: 1415826840000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827020000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827110000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
        {
          label: 'css',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826660000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 2,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827020000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827110000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
        {
          label: 'png',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826660000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 2,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415827020000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827110000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
        {
          label: 'php',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 1,
              y0: 0,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826660000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 2,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827020000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827110000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
        {
          label: 'gif',
          values: [
            {
              x: 1415826240000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826270000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826300000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826330000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826360000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826390000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826420000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826450000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826480000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826510000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826540000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826570000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826600000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826630000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826660000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826690000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826720000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826750000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826780000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826810000,
              y: 0,
              y0: 2,
            },
            {
              x: 1415826840000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826870000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826900000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415826930000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826960000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415826990000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827020000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827050000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827080000,
              y: 0,
              y0: 0,
            },
            {
              x: 1415827110000,
              y: 0,
              y0: 1,
            },
            {
              x: 1415827140000,
              y: 0,
              y0: 0,
            },
          ],
        },
      ],
    },
  ],
  xAxisOrderedValues: [
    1415826240000,
    1415826270000,
    1415826300000,
    1415826330000,
    1415826360000,
    1415826390000,
    1415826420000,
    1415826450000,
    1415826480000,
    1415826510000,
    1415826540000,
    1415826570000,
    1415826600000,
    1415826630000,
    1415826660000,
    1415826690000,
    1415826720000,
    1415826750000,
    1415826780000,
    1415826810000,
    1415826840000,
    1415826870000,
    1415826900000,
    1415826930000,
    1415826960000,
    1415826990000,
    1415827020000,
    1415827050000,
    1415827080000,
    1415827110000,
    1415827140000,
  ],
  hits: 236,
};
