/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { I18nProvider } from '@kbn/i18n/react';
import { NewVisModal } from './new_vis_modal';
import { getHttp, getSavedObjects, getTypes, getUISettings, getUsageCollector, getApplication, getEmbeddable } from '../services';

/**
 * shows modal dialog that allows you to create new visualization
 * @param {string[]} editorParams
 * @param {function} onClose - function that will be called when dialog is closed
 */
export function showNewVisModal() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$editorParams = _ref.editorParams,
      editorParams = _ref$editorParams === void 0 ? [] : _ref$editorParams,
      onClose = _ref.onClose,
      originatingApp = _ref.originatingApp,
      outsideVisualizeApp = _ref.outsideVisualizeApp;

  var container = document.createElement('div');
  var isClosed = false;

  var handleClose = function handleClose() {
    if (isClosed) return;
    ReactDOM.unmountComponentAtNode(container);
    document.body.removeChild(container);

    if (onClose) {
      onClose();
    }

    isClosed = true;
  };

  document.body.appendChild(container);
  var element = /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(NewVisModal, {
    isOpen: true,
    onClose: handleClose,
    originatingApp: originatingApp,
    stateTransfer: getEmbeddable().getStateTransfer(),
    outsideVisualizeApp: outsideVisualizeApp,
    editorParams: editorParams,
    visTypesRegistry: getTypes(),
    addBasePath: getHttp().basePath.prepend,
    uiSettings: getUISettings(),
    savedObjects: getSavedObjects(),
    usageCollection: getUsageCollector(),
    application: getApplication()
  }));
  ReactDOM.render(element, container);
  return function () {
    return handleClose();
  };
}