/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.TerminalDebugSmartCommandAction;
import com.intellij.terminal.TerminalExecutorAction;
import com.intellij.terminal.TerminalRunSmartCommandAction;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.Alarm;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.StyledTextConsumerAdapter;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalModelListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalCommandHandlerCustomizer;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

public final class TerminalShellCommandHandlerHelper {
    private static final Logger LOG = Logger.getInstance(TerminalShellCommandHandler.class);
    @NonNls
    private static final String TERMINAL_CUSTOM_COMMANDS_GOT_IT = "TERMINAL_CUSTOM_COMMANDS_GOT_IT";
    @NonNls
    private static final String GOT_IT = "got_it";
    @NonNls
    private static final String FEATURE_ID = "terminal.shell.command.handling";
    private static Experiments ourExperiments;
    private static final NotificationGroup ourToolWindowGroup;
    private final ShellTerminalWidget myWidget;
    private final Alarm myAlarm;
    private volatile String myWorkingDirectory;
    private volatile Boolean myHasRunningCommands;
    private PropertiesComponent myPropertiesComponent;
    private final SingletonNotificationManager mySingletonNotificationManager;
    private final AtomicBoolean myKeyPressed;

    TerminalShellCommandHandlerHelper(@NotNull ShellTerminalWidget widget) {
        if (widget == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(0);
        }
        this.mySingletonNotificationManager = new SingletonNotificationManager(ourToolWindowGroup, NotificationType.INFORMATION, null);
        this.myKeyPressed = new AtomicBoolean(false);
        this.myWidget = widget;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)widget);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myWidget).subscribe(TerminalCommandHandlerCustomizer.Companion.getTERMINAL_COMMAND_HANDLER_TOPIC(), () -> this.scheduleCommandHighlighting());
        TerminalModelListener listener = () -> {
            if (this.myKeyPressed.compareAndSet(true, false)) {
                this.scheduleCommandHighlighting();
            }
        };
        widget.getTerminalTextBuffer().addModelListener(listener);
        Disposer.register((Disposable)this.myWidget, () -> widget.getTerminalTextBuffer().removeModelListener(listener));
    }

    public void processKeyPressed() {
        if (TerminalShellCommandHandlerHelper.isFeatureEnabled()) {
            this.myKeyPressed.set(true);
            this.scheduleCommandHighlighting();
        }
    }

    private void scheduleCommandHighlighting() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.highlightMatchedCommand(this.myWidget.getProject()), 0);
    }

    public static boolean isFeatureEnabled() {
        Experiments experiments = ourExperiments;
        if (experiments == null) {
            ourExperiments = experiments = (Experiments)ReadAction.compute(() -> ApplicationManager.getApplication().isDisposed() ? null : Experiments.getInstance());
        }
        return experiments != null && experiments.isFeatureEnabled(FEATURE_ID);
    }

    private void highlightMatchedCommand(@NotNull Project project) {
        if (project == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(1);
        }
        if (!this.isEnabledForProject()) {
            this.myWidget.getTerminalPanel().setFindResult(null);
            return;
        }
        String command = this.myWidget.getTypedShellCommand().trim();
        SubstringFinder.FindResult result = TerminalShellCommandHandler.Companion.matches(project, this.getWorkingDirectory(), !this.hasRunningCommands(), command) ? this.searchMatchedCommand(command) : null;
        this.myWidget.getTerminalPanel().setFindResult(result);
        if (this.getPropertiesComponent().getBoolean(TERMINAL_CUSTOM_COMMANDS_GOT_IT, false)) {
            return;
        }
        if (result != null) {
            String title = TerminalBundle.message("smart_command_execution.notification.title", new Object[0]);
            String content = TerminalBundle.message("smart_command_execution.notification.text", KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getRunAction()), KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getDebugAction()), ShowSettingsUtil.getSettingsMenuName(), GOT_IT);
            NotificationListener.Adapter listener = new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (TerminalShellCommandHandlerHelper.GOT_IT.equals(e.getDescription())) {
                        TerminalShellCommandHandlerHelper.this.getPropertiesComponent().setValue(TerminalShellCommandHandlerHelper.TERMINAL_CUSTOM_COMMANDS_GOT_IT, true, false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.mySingletonNotificationManager.notify(title, content, project, (NotificationListener)listener);
        }
    }

    private boolean isEnabledForProject() {
        return this.getPropertiesComponent().getBoolean("terminalCustomCommandExecutionTurnOff", true);
    }

    @NotNull
    private PropertiesComponent getPropertiesComponent() {
        PropertiesComponent propertiesComponent = this.myPropertiesComponent;
        if (propertiesComponent == null) {
            this.myPropertiesComponent = propertiesComponent = (PropertiesComponent)ReadAction.compute(() -> PropertiesComponent.getInstance());
        }
        PropertiesComponent propertiesComponent2 = propertiesComponent;
        if (propertiesComponent2 == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(2);
        }
        return propertiesComponent2;
    }

    @Nullable
    private String getWorkingDirectory() {
        String workingDirectory = this.myWorkingDirectory;
        if (workingDirectory == null) {
            this.myWorkingDirectory = workingDirectory = StringUtil.notNullize((String)TerminalWorkingDirectoryManager.getWorkingDirectory(this.myWidget, null));
        }
        return StringUtil.nullize((String)workingDirectory);
    }

    private boolean hasRunningCommands() {
        Boolean hasRunningCommands = this.myHasRunningCommands;
        if (hasRunningCommands == null) {
            this.myHasRunningCommands = hasRunningCommands = Boolean.valueOf(this.myWidget.hasRunningCommands());
        }
        return hasRunningCommands;
    }

    @Nullable
    private SubstringFinder.FindResult searchMatchedCommand(@NotNull String pattern) {
        if (pattern == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(3);
        }
        if (pattern.length() == 0) {
            return null;
        }
        return this.myWidget.processTerminalBuffer(textBuffer -> {
            int cursorLine = this.myWidget.getLineNumberAtCursor();
            if (cursorLine < 0 || cursorLine >= textBuffer.getHeight()) {
                return null;
            }
            String lineText = textBuffer.getLine(cursorLine).getText();
            final int patternStartInd = lineText.lastIndexOf(pattern);
            if (patternStartInd < 0) {
                return null;
            }
            final SubstringFinder finder = new SubstringFinder(pattern, true){

                public boolean accept(@NotNull SubstringFinder.FindResult.FindItem item) {
                    if (item == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return item.getStart().x >= patternStartInd;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper$2", "accept"));
                }
            };
            textBuffer.processScreenLines(cursorLine, 1, (StyledTextConsumer)new StyledTextConsumerAdapter(){

                public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                    if (style == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (characters == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    for (int i = 0; i < characters.length(); ++i) {
                        finder.nextChar(x, y - startRow, characters, i);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "style";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "characters";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper$3";
                    objectArray[2] = "consume";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return finder.getResult();
        });
    }

    public boolean processEnterKeyPressed(@NotNull String command, @NotNull KeyEvent keyPressed) {
        boolean localSession;
        if (command == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(4);
        }
        if (keyPressed == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(5);
        }
        if (!TerminalShellCommandHandlerHelper.isFeatureEnabled() || !this.isEnabledForProject()) {
            this.onShellCommandExecuted();
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("typed shell command to execute: " + command);
        }
        this.myAlarm.cancelAllRequests();
        TerminalExecutorAction matchedExecutorAction = TerminalShellCommandHandlerHelper.matchedExecutorAction(keyPressed);
        if (matchedExecutorAction == null) {
            this.onShellCommandExecuted();
            return false;
        }
        Project project = this.myWidget.getProject();
        String workingDirectory = this.getWorkingDirectory();
        boolean bl = localSession = !this.hasRunningCommands();
        if (!TerminalShellCommandHandler.Companion.matches(project, workingDirectory, localSession, command)) {
            this.onShellCommandExecuted();
            return false;
        }
        TerminalShellCommandHandler handler = TerminalShellCommandHandler.Companion.getEP().getExtensionList().stream().filter(it -> it.matches(project, workingDirectory, localSession, command)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find matching command handler."));
        TerminalUsageTriggerCollector.Companion.triggerSmartCommandExecuted(project, workingDirectory, localSession, command, handler);
        TerminalShellCommandHandler.Companion.executeShellCommandHandler(this.myWidget.getProject(), this.getWorkingDirectory(), !this.hasRunningCommands(), command, matchedExecutorAction);
        this.clearTypedCommand(command);
        return true;
    }

    private void onShellCommandExecuted() {
        this.myWorkingDirectory = null;
        this.myHasRunningCommands = null;
    }

    private void clearTypedCommand(@NotNull String command) {
        if (command == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(6);
        }
        TtyConnector connector = this.myWidget.getTtyConnector();
        byte[] array = new byte[command.length()];
        Arrays.fill(array, (byte)8);
        try {
            connector.write(array);
        }
        catch (IOException e) {
            LOG.info("Cannot clear shell command " + command, (Throwable)e);
        }
    }

    static TerminalExecutorAction matchedExecutorAction(@NotNull KeyEvent e) {
        TerminalExecutorAction action;
        if (e == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(7);
        }
        return (action = TerminalShellCommandHandlerHelper.matchedRunAction(e)) != null ? action : TerminalShellCommandHandlerHelper.matchedDebugAction(e);
    }

    private static TerminalExecutorAction matchedRunAction(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(8);
        }
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        AnAction action = TerminalShellCommandHandlerHelper.getRunAction();
        return action instanceof TerminalRunSmartCommandAction && Arrays.stream(action.getShortcutSet().getShortcuts()).anyMatch(sc -> sc.isKeyboard() && sc.startsWith((Shortcut)eventShortcut)) ? (TerminalRunSmartCommandAction)action : null;
    }

    private static TerminalExecutorAction matchedDebugAction(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(9);
        }
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        AnAction action = TerminalShellCommandHandlerHelper.getDebugAction();
        return action instanceof TerminalDebugSmartCommandAction && Arrays.stream(action.getShortcutSet().getShortcuts()).anyMatch(sc -> sc.isKeyboard() && sc.startsWith((Shortcut)eventShortcut)) ? (TerminalDebugSmartCommandAction)action : null;
    }

    @NotNull
    private static AnAction getRunAction() {
        AnAction anAction = Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Run"));
        if (anAction == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(10);
        }
        return anAction;
    }

    @NotNull
    private static AnAction getDebugAction() {
        AnAction anAction = Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Debug"));
        if (anAction == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(11);
        }
        return anAction;
    }

    static {
        ourToolWindowGroup = NotificationGroup.toolWindowGroup((String)"Terminal", (String)"Terminal");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPressed";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "highlightMatchedCommand";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "searchMatchedCommand";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processEnterKeyPressed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearTypedCommand";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchedExecutorAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchedRunAction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchedDebugAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

