/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Notification {
    private static final Logger LOG = Logger.getInstance(Notification.class);
    private static final DataKey<Notification> KEY = DataKey.create("Notification");
    public final String id;
    @Nullable
    public final String displayId;
    private final String myGroupId;
    private Icon myIcon;
    private final NotificationType myType;
    private String myTitle;
    private String mySubtitle;
    private String myContent;
    private NotificationListener myListener;
    private String myDropDownText;
    private List<AnAction> myActions;
    private CollapseActionsDirection myCollapseActionsDirection;
    private AnAction myContextHelpAction;
    private final AtomicBoolean myExpired;
    private Runnable myWhenExpired;
    private Boolean myImportant;
    private WeakReference<Balloon> myBalloonRef;
    private final long myTimestamp;

    public Notification(@NotNull String groupId, @Nullable Icon icon, @NotNull NotificationType type) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(0);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(1);
        }
        this(groupId, icon, null, null, null, type, null);
    }

    public Notification(@NotNull @NonNls String groupId, @Nullable Icon icon, @Nullable @NlsContexts.NotificationTitle String title, @Nullable @NlsContexts.NotificationSubtitle String subtitle, @Nullable @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(2);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(3);
        }
        this.myCollapseActionsDirection = CollapseActionsDirection.KEEP_RIGHTMOST;
        this.myExpired = new AtomicBoolean(false);
        this.myGroupId = groupId;
        this.myTitle = StringUtil.notNullize((String)title);
        this.myContent = StringUtil.notNullize((String)content);
        this.myType = type;
        this.myListener = listener2;
        this.myTimestamp = System.currentTimeMillis();
        this.myIcon = icon;
        this.mySubtitle = subtitle;
        this.displayId = null;
        this.id = Notification.calculateId(this);
    }

    public Notification(@NotNull @NonNls String groupId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(4);
        }
        if (title == null) {
            Notification.$$$reportNull$$$0(5);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(6);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(7);
        }
        this(groupId, null, title, content, type, null);
    }

    public Notification(@NotNull @NonNls String groupId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(8);
        }
        if (title == null) {
            Notification.$$$reportNull$$$0(9);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(10);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(11);
        }
        this(groupId, null, title, content, type, listener2);
    }

    public Notification(@NotNull @NonNls String groupId, @Nullable @NonNls String displayId, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String content, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (groupId == null) {
            Notification.$$$reportNull$$$0(12);
        }
        if (title == null) {
            Notification.$$$reportNull$$$0(13);
        }
        if (content == null) {
            Notification.$$$reportNull$$$0(14);
        }
        if (type == null) {
            Notification.$$$reportNull$$$0(15);
        }
        this.myCollapseActionsDirection = CollapseActionsDirection.KEEP_RIGHTMOST;
        this.myExpired = new AtomicBoolean(false);
        this.myGroupId = groupId;
        this.myTitle = title;
        this.myContent = content;
        this.myType = type;
        this.myListener = listener2;
        this.myTimestamp = System.currentTimeMillis();
        this.displayId = displayId;
        this.id = Notification.calculateId(this);
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Notification setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(16);
        }
        return notification;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            Notification.$$$reportNull$$$0(17);
        }
        return string;
    }

    public boolean hasTitle() {
        return !StringUtil.isEmptyOrSpaces((String)this.myTitle) || !StringUtil.isEmptyOrSpaces((String)this.mySubtitle);
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            Notification.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public Notification setTitle(@Nullable @NlsContexts.NotificationTitle String title) {
        this.myTitle = StringUtil.notNullize((String)title);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(19);
        }
        return notification;
    }

    @NotNull
    public Notification setTitle(@Nullable @NlsContexts.NotificationTitle String title, @Nullable @NlsContexts.NotificationSubtitle String subtitle) {
        Notification notification = this.setTitle(title).setSubtitle(subtitle);
        if (notification == null) {
            Notification.$$$reportNull$$$0(20);
        }
        return notification;
    }

    @Nullable
    public String getSubtitle() {
        return this.mySubtitle;
    }

    @NotNull
    public Notification setSubtitle(@Nullable String subtitle) {
        this.mySubtitle = subtitle;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(21);
        }
        return notification;
    }

    public boolean hasContent() {
        return !StringUtil.isEmptyOrSpaces((String)this.myContent);
    }

    @NotNull
    public String getContent() {
        String string = this.myContent;
        if (string == null) {
            Notification.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public Notification setContent(@Nullable String content) {
        this.myContent = StringUtil.notNullize((String)content);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(23);
        }
        return notification;
    }

    @Nullable
    public NotificationListener getListener() {
        return this.myListener;
    }

    @NotNull
    public Notification setListener(@NotNull NotificationListener listener2) {
        if (listener2 == null) {
            Notification.$$$reportNull$$$0(24);
        }
        this.myListener = listener2;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(25);
        }
        return notification;
    }

    @NotNull
    public List<AnAction> getActions() {
        List list = ContainerUtil.notNullize(this.myActions);
        if (list == null) {
            Notification.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public static Notification get(@NotNull AnActionEvent e) {
        if (e == null) {
            Notification.$$$reportNull$$$0(27);
        }
        Notification notification = e.getData(KEY);
        if (notification == null) {
            Notification.$$$reportNull$$$0(28);
        }
        return notification;
    }

    public static void fire(@NotNull Notification notification, @NotNull AnAction action) {
        if (notification == null) {
            Notification.$$$reportNull$$$0(29);
        }
        if (action == null) {
            Notification.$$$reportNull$$$0(30);
        }
        Notification.fire(notification, action, null);
    }

    public static void fire(@NotNull Notification notification, @NotNull AnAction action, @Nullable DataContext context) {
        AnActionEvent event;
        if (notification == null) {
            Notification.$$$reportNull$$$0(31);
        }
        if (action == null) {
            Notification.$$$reportNull$$$0(32);
        }
        if (ActionUtil.lastUpdateAndCheckDumb(action, event = AnActionEvent.createFromAnAction(action, null, "Notification", dataId -> {
            if (KEY.is(dataId)) {
                return notification;
            }
            return context == null ? null : context.getData(dataId);
        }), false)) {
            ActionUtil.performActionDumbAwareWithCallbacks(action, event, event.getDataContext());
        }
    }

    public static void setDataProvider(@NotNull Notification notification, @NotNull JComponent component) {
        if (notification == null) {
            Notification.$$$reportNull$$$0(33);
        }
        if (component == null) {
            Notification.$$$reportNull$$$0(34);
        }
        DataManager.registerDataProvider(component, dataId -> KEY.getName().equals(dataId) ? notification : null);
    }

    @NotNull
    public String getDropDownText() {
        if (this.myDropDownText == null) {
            this.myDropDownText = "Actions";
        }
        String string = this.myDropDownText;
        if (string == null) {
            Notification.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public Notification setDropDownText(@NotNull @NlsContexts.LinkLabel String dropDownText) {
        if (dropDownText == null) {
            Notification.$$$reportNull$$$0(36);
        }
        this.myDropDownText = dropDownText;
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(37);
        }
        return notification;
    }

    public CollapseActionsDirection getCollapseActionsDirection() {
        return this.myCollapseActionsDirection;
    }

    public void setCollapseActionsDirection(CollapseActionsDirection collapseActionsDirection) {
        this.myCollapseActionsDirection = collapseActionsDirection;
    }

    @NotNull
    public Notification addAction(@NotNull AnAction action) {
        if (action == null) {
            Notification.$$$reportNull$$$0(38);
        }
        if (this.myActions == null) {
            this.myActions = new ArrayList<AnAction>();
        }
        this.myActions.add(action);
        Notification notification = this;
        if (notification == null) {
            Notification.$$$reportNull$$$0(39);
        }
        return notification;
    }

    public Notification setContextHelpAction(AnAction action) {
        this.myContextHelpAction = action;
        return this;
    }

    public AnAction getContextHelpAction() {
        return this.myContextHelpAction;
    }

    @NotNull
    public NotificationType getType() {
        NotificationType notificationType = this.myType;
        if (notificationType == null) {
            Notification.$$$reportNull$$$0(40);
        }
        return notificationType;
    }

    public boolean isExpired() {
        return this.myExpired.get();
    }

    public void expire() {
        if (!this.myExpired.compareAndSet(false, true)) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(this::hideBalloon);
        NotificationsManager.getNotificationsManager().expire(this);
        Runnable whenExpired = this.myWhenExpired;
        if (whenExpired != null) {
            whenExpired.run();
        }
    }

    public Notification whenExpired(@Nullable Runnable whenExpired) {
        this.myWhenExpired = whenExpired;
        return this;
    }

    public void hideBalloon() {
        if (this.myBalloonRef != null) {
            Balloon balloon = (Balloon)this.myBalloonRef.get();
            if (balloon != null) {
                balloon.hide();
            }
            this.myBalloonRef = null;
        }
    }

    public void setBalloon(final @NotNull Balloon balloon) {
        if (balloon == null) {
            Notification.$$$reportNull$$$0(41);
        }
        this.hideBalloon();
        this.myBalloonRef = new WeakReference<Balloon>(balloon);
        balloon.addListener(new JBPopupListener(){

            @Override
            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (SoftReference.dereference((Reference)Notification.this.myBalloonRef) == balloon) {
                    Notification.this.myBalloonRef = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/notification/Notification$1", "onClosed"));
            }
        });
    }

    @Nullable
    public Balloon getBalloon() {
        return (Balloon)SoftReference.dereference(this.myBalloonRef);
    }

    public void notify(@Nullable Project project) {
        Notifications.Bus.notify(this, project);
    }

    public Notification setImportant(boolean important) {
        this.myImportant = important;
        return this;
    }

    public boolean isImportant() {
        if (this.myImportant != null) {
            return this.myImportant;
        }
        return this.getListener() != null || !ContainerUtil.isEmpty(this.myActions);
    }

    @NotNull
    private static String calculateId(@NotNull Object notification) {
        if (notification == null) {
            Notification.$$$reportNull$$$0(42);
        }
        String string = System.currentTimeMillis() + "." + System.identityHashCode(notification);
        if (string == null) {
            Notification.$$$reportNull$$$0(43);
        }
        return string;
    }

    public final void assertHasTitleOrContent() {
        LOG.assertTrue(this.hasTitle() || this.hasContent(), (Object)("Notification should have title and/or content; groupId: " + this.myGroupId));
    }

    public String toString() {
        return String.format("Notification{id='%s', myGroupId='%s', myType=%s, myTitle='%s', mySubtitle='%s', myContent='%s'}", new Object[]{this.id, this.myGroupId, this.myType, this.myTitle, this.mySubtitle, this.myContent});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/Notification";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 30: 
            case 32: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dropDownText";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/Notification";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setTitle";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setSubtitle";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setContent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setListener";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDropDownText";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "setDropDownText";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "addAction";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setListener";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fire";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setDropDownText";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setBalloon";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "calculateId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CollapseActionsDirection {
        KEEP_LEFTMOST,
        KEEP_RIGHTMOST;

    }
}

