/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.CallbackData;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateRequestsQueue {
    private static final Logger LOG = Logger.getInstance(UpdateRequestsQueue.class);
    private final Project myProject;
    private final ChangeListManagerImpl.Scheduler myScheduler;
    private final BooleanSupplier myDelegate;
    private final Object myLock;
    private volatile boolean myStarted;
    private volatile boolean myStopped;
    private volatile boolean myIgnoreBackgroundOperation;
    private boolean myRequestSubmitted;
    private boolean myRequestRunning;
    private final List<Runnable> myWaitingUpdateCompletionQueue;
    private final List<Semaphore> myWaitingUpdateCompletionSemaphores;

    public UpdateRequestsQueue(@NotNull Project project, @NotNull ChangeListManagerImpl.Scheduler scheduler, @NotNull BooleanSupplier delegate) {
        if (project == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(0);
        }
        if (scheduler == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(1);
        }
        if (delegate == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myWaitingUpdateCompletionQueue = new ArrayList<Runnable>();
        this.myWaitingUpdateCompletionSemaphores = new ArrayList<Semaphore>();
        this.myProject = project;
        this.myScheduler = scheduler;
        this.myDelegate = delegate;
        this.myStarted = false;
        this.myStopped = false;
    }

    public void initialized() {
        LOG.debug("Initialized for project: " + this.myProject.getName());
        this.myStarted = true;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myStarted && ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (this.myStopped) {
                return;
            }
            if (this.myRequestSubmitted) {
                return;
            }
            this.myRequestSubmitted = true;
            MyRunnable runnable = new MyRunnable();
            this.myScheduler.schedule(runnable, 300L, TimeUnit.MILLISECONDS);
            LOG.debug("Scheduled for project: " + this.myProject.getName() + ", runnable: " + runnable.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceGo() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = false;
            this.myRequestSubmitted = false;
            this.myRequestRunning = false;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        Object object = this.myLock;
        synchronized (object) {
            this.myStopped = false;
        }
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.debug("Calling stop for project: " + this.myProject.getName());
        ArrayList<Runnable> waiters = new ArrayList<Runnable>(this.myWaitingUpdateCompletionQueue.size());
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            this.myStopped = true;
            waiters.addAll(this.myWaitingUpdateCompletionQueue);
            this.myWaitingUpdateCompletionQueue.clear();
        }
        LOG.debug("Calling runnables in stop for project: " + this.myProject.getName());
        for (Runnable runnable : waiters) {
            runnable.run();
        }
        LOG.debug("Stop finished for project: " + this.myProject.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilRefreshed() {
        Semaphore semaphore;
        do {
            semaphore = new Semaphore();
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myRequestSubmitted && !this.myRequestRunning) {
                    return;
                }
                if (!this.myRequestRunning) {
                    this.myScheduler.submit(new MyRunnable());
                }
                semaphore.down();
                this.myWaitingUpdateCompletionSemaphores.add(semaphore);
            }
        } while (semaphore.waitFor(100000L));
        LOG.error("Too long VCS update\n" + ThreadDumper.dumpThreadsToString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSemaphores() {
        Object object = this.myLock;
        synchronized (object) {
            for (Semaphore semaphore : this.myWaitingUpdateCompletionSemaphores) {
                semaphore.up();
            }
            this.myWaitingUpdateCompletionSemaphores.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title2, @Nullable ModalityState state) {
        boolean stopped;
        if (afterUpdate == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(3);
        }
        if (mode == null) {
            UpdateRequestsQueue.$$$reportNull$$$0(4);
        }
        LOG.debug("invokeAfterUpdate for project: " + this.myProject.getName());
        CallbackData data = CallbackData.create(this.myProject, mode, afterUpdate, title2, state);
        Object object = this.myLock;
        synchronized (object) {
            stopped = this.myStopped;
            if (!stopped) {
                this.myWaitingUpdateCompletionQueue.add(data.getCallback());
                this.schedule();
            }
        }
        if (stopped) {
            LOG.debug("invokeAfterUpdate: stopped, invoke right now for project: " + this.myProject.getName());
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    afterUpdate.run();
                }
            }, (ModalityState)ObjectUtils.notNull((Object)state, (Object)ModalityState.defaultModalityState()));
            return;
        }
        data.getWrapperStarter().run();
        LOG.debug("invokeAfterUpdate: exit for project: " + this.myProject.getName());
    }

    private boolean checkHeavyOperations() {
        return !this.myIgnoreBackgroundOperation && ProjectLevelVcsManager.getInstance((Project)this.myProject).isBackgroundVcsOperationRunning();
    }

    private boolean checkLifeCycle() {
        return !this.myStarted || !StartupManagerEx.getInstanceEx((Project)this.myProject).startupActivityPassed();
    }

    public void setIgnoreBackgroundOperation(boolean ignoreBackgroundOperation) {
        this.myIgnoreBackgroundOperation = ignoreBackgroundOperation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheduler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/UpdateRequestsQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeAfterUpdate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            ArrayList copy;
            block32: {
                copy = new ArrayList();
                Object object = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object
                if (UpdateRequestsQueue.this.myRequestSubmitted) break block32;
                // MONITOREXIT : object
                Iterator iterator = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : iterator
                UpdateRequestsQueue.this.myRequestRunning = false;
                LOG.debug("MyRunnable: delete executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                if (!(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() || UpdateRequestsQueue.this.myRequestSubmitted || UpdateRequestsQueue.this.myStopped)) {
                    LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : iterator
                iterator = copy.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        UpdateRequestsQueue.this.freeSemaphores();
                        LOG.debug("MyRunnable: Runnables executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                        return;
                    }
                    Runnable runnable = (Runnable)iterator.next();
                    runnable.run();
                }
            }
            UpdateRequestsQueue.this.myRequestSubmitted = false;
            LOG.assertTrue(!UpdateRequestsQueue.this.myRequestRunning);
            UpdateRequestsQueue.this.myRequestRunning = true;
            if (UpdateRequestsQueue.this.myStopped) {
                LOG.debug("MyRunnable: STOPPED, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                // MONITOREXIT : object
                Iterator iterator = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : iterator
                UpdateRequestsQueue.this.myRequestRunning = false;
                LOG.debug("MyRunnable: delete executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                if (!(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() || UpdateRequestsQueue.this.myRequestSubmitted || UpdateRequestsQueue.this.myStopped)) {
                    LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : iterator
                iterator = copy.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        UpdateRequestsQueue.this.freeSemaphores();
                        LOG.debug("MyRunnable: Runnables executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                        return;
                    }
                    Runnable runnable = (Runnable)iterator.next();
                    runnable.run();
                }
            }
            if (UpdateRequestsQueue.this.checkLifeCycle() || UpdateRequestsQueue.this.checkHeavyOperations()) {
                LOG.debug("MyRunnable: reschedule, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                UpdateRequestsQueue.this.schedule();
                // MONITOREXIT : object
                Iterator iterator = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : iterator
                UpdateRequestsQueue.this.myRequestRunning = false;
                LOG.debug("MyRunnable: delete executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                if (!(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.isEmpty() || UpdateRequestsQueue.this.myRequestSubmitted || UpdateRequestsQueue.this.myStopped)) {
                    LOG.error("No update task to handle request(s)");
                }
                // MONITOREXIT : iterator
                iterator = copy.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        UpdateRequestsQueue.this.freeSemaphores();
                        LOG.debug("MyRunnable: Runnables executed, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                        return;
                    }
                    Runnable runnable = (Runnable)iterator.next();
                    runnable.run();
                }
            }
            try {
                copy.addAll(UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue);
                UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.clear();
                // MONITOREXIT : object
                LOG.debug("MyRunnable: INVOKE, project: " + UpdateRequestsQueue.this.myProject.getName() + ", runnable: " + this.hashCode());
                boolean success2 = UpdateRequestsQueue.this.myDelegate.getAsBoolean();
                LOG.debug("MyRunnable: invokeD, project: " + UpdateRequestsQueue.this.myProject.getName() + ", was success: " + success2 + ", runnable: " + this.hashCode());
                if (success2) return;
                Object object = UpdateRequestsQueue.this.myLock;
                // MONITORENTER : object
                UpdateRequestsQueue.this.myWaitingUpdateCompletionQueue.addAll(0, copy);
                copy.clear();
                // MONITOREXIT : object
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Iterator iterator = UpdateRequestsQueue.this.myLock;
            }
        }

        public String toString() {
            return "UpdateRequestQueue delegate: " + UpdateRequestsQueue.this.myDelegate;
        }
    }
}

