/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSchemeChooserDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JBList mySchemeList;
    private JTextField myTargetNameField;
    private JCheckBox myUseCurrentScheme;
    private String mySelectedName;
    private static final String UNNAMED_SCHEME_ITEM = "<" + ApplicationBundle.message((String)"code.style.scheme.import.unnamed", (Object[])new Object[0]) + ">";
    private final List<String> myNames;

    public ImportSchemeChooserDialog(@NotNull Project project, String[] schemeNames, final @Nullable String currScheme) {
        if (project == null) {
            ImportSchemeChooserDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.$$$setupUI$$$();
        this.myNames = new ArrayList<String>();
        if (schemeNames.length > 0) {
            this.myNames.addAll(Arrays.asList(schemeNames));
        } else {
            this.myNames.add(UNNAMED_SCHEME_ITEM);
        }
        this.mySchemeList.setModel((ListModel)new DefaultListModel(){

            @Override
            public int getSize() {
                return ImportSchemeChooserDialog.this.myNames.size();
            }

            @Override
            public Object getElementAt(int index) {
                return ImportSchemeChooserDialog.this.myNames.get(index);
            }
        });
        this.mySchemeList.setSelectionMode(0);
        this.mySchemeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ImportSchemeChooserDialog.this.mySchemeList.getSelectedIndex();
                if (index >= 0) {
                    ImportSchemeChooserDialog.this.mySelectedName = (String)ImportSchemeChooserDialog.this.myNames.get(index);
                    if (!ImportSchemeChooserDialog.this.myUseCurrentScheme.isSelected() && !UNNAMED_SCHEME_ITEM.equals(ImportSchemeChooserDialog.this.mySelectedName)) {
                        ImportSchemeChooserDialog.this.myTargetNameField.setText(ImportSchemeChooserDialog.this.mySelectedName);
                    }
                }
            }
        });
        this.myUseCurrentScheme.setEnabled(currScheme != null);
        this.myUseCurrentScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImportSchemeChooserDialog.this.myUseCurrentScheme.isSelected()) {
                    ImportSchemeChooserDialog.this.myTargetNameField.setEnabled(false);
                    if (currScheme != null) {
                        ImportSchemeChooserDialog.this.myTargetNameField.setText(currScheme);
                    }
                } else {
                    ImportSchemeChooserDialog.this.myTargetNameField.setEnabled(true);
                    if (ImportSchemeChooserDialog.this.mySelectedName != null) {
                        ImportSchemeChooserDialog.this.myTargetNameField.setText(ImportSchemeChooserDialog.this.mySelectedName);
                    }
                }
            }
        });
        this.mySchemeList.getSelectionModel().setSelectionInterval(0, 0);
        this.init();
        this.setTitle(ApplicationBundle.message((String)"title.import.scheme.chooser", (Object[])new Object[0]));
    }

    public String getSelectedName() {
        return UNNAMED_SCHEME_ITEM.equals(this.mySelectedName) ? null : this.mySelectedName;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public boolean isUseCurrentScheme() {
        return this.myUseCurrentScheme.isSelected();
    }

    @Nullable
    public String getTargetName() {
        String name = this.myTargetNameField.getText();
        return name != null && !name.trim().isEmpty() ? name : null;
    }

    public static Pair<String, CodeStyleScheme> selectOrCreateTargetScheme(@NotNull Project project, @NotNull CodeStyleScheme currentScheme, @NotNull SchemeFactory<? extends CodeStyleScheme> schemeFactory, String ... schemeNames) {
        ImportSchemeChooserDialog schemeChooserDialog;
        if (project == null) {
            ImportSchemeChooserDialog.$$$reportNull$$$0(1);
        }
        if (currentScheme == null) {
            ImportSchemeChooserDialog.$$$reportNull$$$0(2);
        }
        if (schemeFactory == null) {
            ImportSchemeChooserDialog.$$$reportNull$$$0(3);
        }
        if ((schemeChooserDialog = new ImportSchemeChooserDialog(project, schemeNames, !currentScheme.isDefault() ? currentScheme.getName() : null)).showAndGet()) {
            return Pair.create((Object)schemeChooserDialog.getSelectedName(), (Object)(schemeChooserDialog.isUseCurrentScheme() && !currentScheme.isDefault() ? currentScheme : (CodeStyleScheme)schemeFactory.createNewScheme(schemeChooserDialog.getTargetName())));
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, new Dimension(200, -1), null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ImportSchemeChooserDialog.class).getString("import.scheme.chooser.destination"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTargetNameField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUseCurrentScheme = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/LangBundle", ImportSchemeChooserDialog.class).getString("checkbox.import.scheme.current.scheme"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySchemeList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/ApplicationBundle", ImportSchemeChooserDialog.class).getString("import.scheme.chooser.source"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentScheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeFactory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/ImportSchemeChooserDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOrCreateTargetScheme";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

