/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.FindUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExHelpPopup
extends JPanel {
    private static final Logger LOG = Logger.getInstance(RegExHelpPopup.class);
    private final JEditorPane myEditorPane;
    private final JScrollPane myScrollPane;

    public RegExHelpPopup() {
        String text;
        this.setLayout(new BorderLayout());
        this.myEditorPane = new JEditorPane();
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myEditorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myEditorPane.setBackground(HintUtil.getInformationColor());
        try {
            text = ResourceUtil.loadText((InputStream)ResourceUtil.getResourceAsStream(this.getClass(), (String)"messages", (String)"RegExHelpPopup.html"));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            text = "Failed to load help page: " + e.getMessage();
        }
        this.myEditorPane.setText(StringUtil.replace((String)text, (String)"LABEL_BACKGROUND", (String)ColorUtil.toHtmlColor((Color)UIUtil.getLabelBackground())));
        this.myEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    BrowserUtil.browse((URL)e.getURL());
                }
            }
        });
        this.myEditorPane.setCaretPosition(0);
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myEditorPane);
        this.myScrollPane.setBorder(null);
        this.add((Component)this.myScrollPane, "Center");
    }

    public static LinkLabel createRegExLink(@NotNull String title, @Nullable Component owner, @Nullable Logger logger) {
        if (title == null) {
            RegExHelpPopup.$$$reportNull$$$0(0);
        }
        return RegExHelpPopup.createRegExLink(title, owner, logger, null);
    }

    @NotNull
    public static LinkLabel createRegExLink(@NotNull String title, @Nullable Component owner, @Nullable Logger logger, final @Nullable String place) {
        if (title == null) {
            RegExHelpPopup.$$$reportNull$$$0(1);
        }
        final Runnable action2 = RegExHelpPopup.createRegExLinkRunnable(owner);
        return new LinkLabel(title, null, (LinkListener)new LinkListener<Object>(){

            public void linkSelected(LinkLabel<Object> aSource, Object aLinkData) {
                FindUtil.triggerRegexHelpClicked(place);
                action2.run();
            }
        });
    }

    @NotNull
    public static Runnable createRegExLinkRunnable(final @Nullable Component owner) {
        return new Runnable(){
            JBPopup helpPopup;

            @Override
            public void run() {
                if (this.helpPopup != null && !this.helpPopup.isDisposed() && this.helpPopup.isVisible()) {
                    return;
                }
                RegExHelpPopup content2 = new RegExHelpPopup();
                ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)content2, (JComponent)content2);
                this.helpPopup = builder2.setCancelOnClickOutside(false).setBelongsToGlobalPopupStack(true).setFocusable(true).setRequestFocus(true).setMovable(true).setResizable(true).setCancelOnOtherWindowOpen(false).setCancelButton((IconButton)new MinimizeButton("Hide")).setTitle(LangBundle.message((String)"popup.title.regular.expressions.syntax", (Object[])new Object[0])).setDimensionServiceKey(null, "RegExHelpPopup", true).createPopup();
                Disposer.register((Disposable)this.helpPopup, (Disposable)new Disposable(){

                    public void dispose() {
                        this.destroyPopup();
                    }
                });
                if (owner != null) {
                    this.helpPopup.showInCenterOf(owner);
                } else {
                    this.helpPopup.showInFocusCenter();
                }
            }

            private void destroyPopup() {
                this.helpPopup = null;
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        return JBUI.size((int)600, (int)300);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/find/impl/RegExHelpPopup", "createRegExLink"));
    }
}

