/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.OldRecentDirectoryProjectsManager;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.RecentProjectIconHelper;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectManagerState;
import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.RecentProjectsManagerBaseKt;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.platform.ProjectSelfieUtil;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SingleAlarmKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.Icon;
import javax.swing.JFrame;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RecentProjectsManager", storages={@Storage(value="recentProjects.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 ^2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0003^_`B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020\tJ\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020!0\u0007H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020*H\u0014J\u0018\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010#\u001a\u00020\t2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u0004\u0018\u00010\n2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tJ\u000e\u00103\u001a\u00020,2\u0006\u0010#\u001a\u00020\tJ\u0012\u00104\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020*H\u0016J\f\u00105\u001a\b\u0012\u0004\u0012\u00020\t0\u0007J\u001a\u00106\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0014J\u001b\u00107\u001a\b\u0012\u0004\u0012\u000209082\u0006\u0010:\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010;J%\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u000109082\u0006\u0010:\u001a\u00020.2\u0006\u0010<\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010=J\u0006\u0010>\u001a\u00020\u0003J\u0012\u0010?\u001a\u00020.2\b\u0010#\u001a\u0004\u0018\u00010\tH\u0016J\u000e\u0010@\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0003J\u0018\u0010A\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u0010B\u001a\u00020\u001f2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\t0DH\u0002J\u0006\u0010E\u001a\u00020\u001fJ\u001a\u0010F\u001a\u0004\u0018\u00010*2\u0006\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010K\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\tH\u0016J\b\u0010L\u001a\u00020.H\u0016J\u0012\u0010M\u001a\u00020\u001f2\b\u0010N\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010O\u001a\u00020\u001f2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\tH\u0002J\b\u0010S\u001a\u00020\u001fH\u0016J \u0010T\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020.H\u0002J\b\u0010X\u001a\u00020.H\u0016J\u001a\u0010Y\u001a\u00020\u001f2\b\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020]H\u0002R&\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/intellij/ide/RecentProjectsManagerBase;", "Lcom/intellij/ide/RecentProjectsManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ide/RecentProjectManagerState;", "Lcom/intellij/openapi/util/ModificationTracker;", "()V", "lastOpenedProjects", "", "", "", "Lcom/intellij/ide/RecentProjectMetaInfo;", "getLastOpenedProjects", "()Ljava/util/List;", "modCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "nameCache", "", "nameResolver", "Lcom/intellij/util/SingleAlarm;", "namesToResolve", "", "projectIconHelper", "Lcom/intellij/ide/RecentProjectIconHelper;", "getProjectIconHelper", "()Lcom/intellij/ide/RecentProjectIconHelper;", "projectIconHelper$delegate", "Lkotlin/Lazy;", "state", "stateLock", "", "addGroup", "", "group", "Lcom/intellij/ide/ProjectGroup;", "getDisplayName", "path", "getGroups", "getLastProjectCreationLocation", "getModificationCount", "", "getProjectDisplayName", "project", "Lcom/intellij/openapi/project/Project;", "getProjectIcon", "Ljavax/swing/Icon;", "isDark", "", "getProjectMetaInfo", "file", "Ljava/nio/file/Path;", "getProjectName", "getProjectOrAppIcon", "getProjectPath", "getRecentPaths", "getRecentProjectMetadata", "getRecentProjectsActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "addClearListItem", "(Z)[Lcom/intellij/openapi/actionSystem/AnAction;", "useGroups", "(ZZ)[Lcom/intellij/openapi/actionSystem/AnAction;", "getState", "hasPath", "loadState", "markPathRecent", "migrateOpenPaths", "openPaths", "", "noStateLoaded", "openProject", "projectFile", "openProjectOptions", "Lcom/intellij/ide/impl/OpenProjectTask;", "removeGroup", "removePath", "reopenLastProjectsOnStart", "setLastProjectCreationLocation", "value", "takeASelfie", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "workspaceId", "updateLastProjectPath", "updateProjectInfo", "windowManager", "Lcom/intellij/openapi/wm/impl/WindowManagerImpl;", "writLastProjectInfo", "willReopenProjectOnStart", "writeInfoFile", "frameInfo", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "frame", "Ljavax/swing/JFrame;", "Companion", "MyAppLifecycleListener", "MyProjectListener", "intellij.platform.ide.impl"})
public class RecentProjectsManagerBase
extends RecentProjectsManager
implements PersistentStateComponent<RecentProjectManagerState>,
ModificationTracker {
    private final AtomicLong modCounter = new AtomicLong();
    private final Lazy projectIconHelper$delegate = LazyKt.lazy((Function0)projectIconHelper.2.INSTANCE);
    private final Set<String> namesToResolve = (Set)new THashSet(6);
    private final Map<String, String> nameCache;
    private final SingleAlarm nameResolver;
    private final Object stateLock;
    private RecentProjectManagerState state;
    public static final int MAX_PROJECTS_IN_MAIN_MENU = 6;
    @JvmField
    public static boolean dontReopenProjects;
    public static final Companion Companion;

    private final RecentProjectIconHelper getProjectIconHelper() {
        Lazy lazy = this.projectIconHelper$delegate;
        RecentProjectsManagerBase recentProjectsManagerBase = this;
        Object var3_3 = null;
        boolean bl = false;
        return (RecentProjectIconHelper)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RecentProjectManagerState getState() {
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.state.getRecentPaths().clear();
            this.state.getRecentPaths().addAll(CollectionsKt.reversed((Iterable)this.state.getAdditionalInfo().keySet()));
            if (this.state.getPid() == null) {
                this.state.setPid(null);
            }
            RecentProjectManagerState recentProjectManagerState = this.state;
            return recentProjectManagerState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RecentProjectMetaInfo getProjectMetaInfo(@NotNull Path file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            RecentProjectMetaInfo recentProjectMetaInfo = this.state.getAdditionalInfo().get(PathKt.getSystemIndependentPath((Path)file2));
            return recentProjectMetaInfo;
        }
    }

    public final void noStateLoaded() {
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(OldRecentDirectoryProjectsManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        RecentProjectManagerState recentProjectManagerState = ((OldRecentDirectoryProjectsManager)object).getLoadedState();
        if (recentProjectManagerState == null) {
            return;
        }
        RecentProjectManagerState old = recentProjectManagerState;
        RecentProjectManagerState newState2 = new RecentProjectManagerState();
        BaseState.copyFrom$default((BaseState)newState2, (BaseState)old, (boolean)false, (int)2, null);
        newState2.intIncrementModificationCount();
        this.loadState(newState2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(@NotNull RecentProjectManagerState state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.state = state;
            state.setPid(null);
            this.migrateOpenPaths(state.getOpenPaths());
            List<String> recentPaths = state.getRecentPaths();
            Collection collection = recentPaths;
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                RecentProjectsManagerBaseKt.access$convertToSystemIndependentPaths(recentPaths);
                for (String key : CollectionsKt.toList((Iterable)state.getAdditionalInfo().keySet())) {
                    RecentProjectMetaInfo recentProjectMetaInfo;
                    String normalizedKey;
                    Intrinsics.checkExpressionValueIsNotNull((Object)FileUtilRt.toSystemIndependentName((String)key), (String)"FileUtilRt.toSystemIndependentName(key)");
                    if (!(Intrinsics.areEqual((Object)normalizedKey, (Object)key) ^ true)) continue;
                    if (state.getAdditionalInfo().remove(key) == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    RecentProjectMetaInfo it = recentProjectMetaInfo;
                    boolean bl7 = false;
                    state.getAdditionalInfo().put(normalizedKey, it);
                }
                boolean bl8 = false;
                LinkedHashMap<String, RecentProjectMetaInfo> newAdditionalInfo = new LinkedHashMap<String, RecentProjectMetaInfo>();
                for (String recentPath : CollectionsKt.asReversedMutable(recentPaths)) {
                    RecentProjectMetaInfo value2;
                    if (state.getAdditionalInfo().get(recentPath) == null) {
                        continue;
                    }
                    newAdditionalInfo.put(recentPath, value2);
                }
                if (Intrinsics.areEqual(newAdditionalInfo, state.getAdditionalInfo()) ^ true) {
                    state.getAdditionalInfo().clear();
                    state.getAdditionalInfo().putAll((Map<String, RecentProjectMetaInfo>)newAdditionalInfo);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void migrateOpenPaths(List<String> openPaths) {
        RecentProjectMetaInfo info;
        if (openPaths.isEmpty()) {
            return;
        }
        RecentProjectsManagerBaseKt.access$convertToSystemIndependentPaths(openPaths);
        boolean bl = false;
        Map oldInfoMap = new LinkedHashMap();
        for (String path : openPaths) {
            info = this.state.getAdditionalInfo().remove(path);
            if (info == null) continue;
            oldInfoMap.put(path, info);
        }
        for (String path : CollectionsKt.asReversedMutable(openPaths)) {
            RecentProjectMetaInfo recentProjectMetaInfo = (RecentProjectMetaInfo)((Object)oldInfoMap.get(path));
            if (recentProjectMetaInfo == null) {
                recentProjectMetaInfo = new RecentProjectMetaInfo();
            }
            info = recentProjectMetaInfo;
            info.setOpened(true);
            this.state.getAdditionalInfo().put(path, info);
        }
        openPaths.clear();
        this.modCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.state.getAdditionalInfo().remove(path) != null) {
                this.modCounter.incrementAndGet();
            }
            for (ProjectGroup group : this.state.getGroups()) {
                if (!group.removeProject(path)) continue;
                this.modCounter.incrementAndGet();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPath(@Nullable String path) {
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Map<String, RecentProjectMetaInfo> map2 = this.state.getAdditionalInfo();
            String string = path;
            boolean bl4 = false;
            Map<String, RecentProjectMetaInfo> map3 = map2;
            if (map3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            boolean bl5 = map3.containsKey(string);
            return bl5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLastProjectCreationLocation() {
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            String string = this.state.getLastProjectLocation();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastProjectCreationLocation(@Nullable String value2) {
        String newValue2 = PathUtil.toSystemIndependentName((String)StringKt.nullize((String)value2, (boolean)true));
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.state.setLastProjectLocation(newValue2);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastProjectPath() {
        Project[] projectArray = ProjectUtil.getOpenProjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectUtil.getOpenProjects()");
        Project[] openProjects = projectArray;
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (RecentProjectMetaInfo info : this.state.getAdditionalInfo().values()) {
                info.setOpened(false);
            }
            Project[] projectArray2 = openProjects;
            int n = projectArray2.length;
            for (int j = 0; j < n; ++j) {
                RecentProjectMetaInfo info;
                Project project;
                Project project2 = project = projectArray2[j];
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                String path = this.getProjectPath(project2);
                RecentProjectMetaInfo recentProjectMetaInfo = info = path == null ? null : this.state.getAdditionalInfo().get(path);
                if (info == null) continue;
                info.setOpened(true);
                info.setProjectOpenTimestamp(System.currentTimeMillis());
                info.setDisplayName(this.getProjectDisplayName(project));
            }
            this.state.validateRecentProjects(this.modCounter);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    protected String getProjectDisplayName(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return null;
    }

    @Nullable
    public final Icon getProjectIcon(@NotNull String path, boolean isDark) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.getProjectIconHelper().getProjectIcon(path, isDark);
    }

    @NotNull
    public final Icon getProjectOrAppIcon(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return this.getProjectIconHelper().getProjectOrAppIcon(path);
    }

    @NotNull
    public AnAction[] getRecentProjectsActions(boolean addClearListItem) {
        Collection $this$toTypedArray$iv = RecentProjectListActionProvider.getActions$default(RecentProjectListActionProvider.Companion.getInstance(), addClearListItem, false, 2, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
        if (anActionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return anActionArray;
    }

    @NotNull
    public AnAction[] getRecentProjectsActions(boolean addClearListItem, boolean useGroups) {
        Collection $this$toTypedArray$iv = RecentProjectListActionProvider.Companion.getInstance().getActions(addClearListItem, useGroups);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
        if (anActionArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return anActionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void markPathRecent(String path, Project project) {
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            RecentProjectMetaInfo recentProjectMetaInfo;
            boolean bl3 = false;
            for (ProjectGroup group : this.state.getGroups()) {
                if (!group.markProjectFirst(path)) continue;
                this.modCounter.incrementAndGet();
                break;
            }
            if ((recentProjectMetaInfo = this.state.getAdditionalInfo().remove(path)) == null) {
                recentProjectMetaInfo = new RecentProjectMetaInfo();
            }
            RecentProjectMetaInfo info = recentProjectMetaInfo;
            this.state.getAdditionalInfo().put(path, info);
            this.modCounter.incrementAndGet();
            ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
            info.setDisplayName(this.getProjectDisplayName(project));
            info.setProjectWorkspaceId(ProjectKt.getStateStore(project).getProjectWorkspaceId());
            info.setFrame(ProjectFrameBounds.Companion.getInstance(project).getState());
            ApplicationInfoEx applicationInfoEx = appInfo;
            if (applicationInfoEx == null) {
                Intrinsics.throwNpe();
            }
            info.setBuild(applicationInfoEx.getBuild().asString());
            BuildNumber buildNumber = appInfo.getBuild();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"appInfo.build");
            info.setProductionCode(buildNumber.getProductCode());
            info.setEap(appInfo.isEAP());
            info.setBinFolder(FileUtilRt.toSystemIndependentName((String)PathManager.getBinPath()));
            info.setProjectOpenTimestamp(System.currentTimeMillis());
            Calendar calendar = appInfo.getBuildDate();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"appInfo.buildDate");
            info.setBuildTimestamp(calendar.getTimeInMillis());
            info.setMetadata(this.getRecentProjectMetadata(path, project));
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    protected String getRecentProjectMetadata(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return null;
    }

    @Nullable
    public String getProjectPath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = project.getPresentableUrl();
        if (string == null) {
            return null;
        }
        return FileUtilRt.toSystemIndependentName((String)string);
    }

    @Nullable
    public Project openProject(@NotNull Path projectFile, @NotNull OpenProjectTask openProjectOptions) {
        Intrinsics.checkParameterIsNotNull((Object)projectFile, (String)"projectFile");
        Intrinsics.checkParameterIsNotNull((Object)openProjectOptions, (String)"openProjectOptions");
        if (ProjectUtil.isValidProjectPath(projectFile)) {
            Project project = ProjectUtil.findAndFocusExistingProjectForPath(projectFile);
            if (project == null) {
                project = ProjectManagerEx.getInstanceEx().openProject(projectFile, openProjectOptions);
            }
            return project;
        }
        return ProjectUtil.openOrImport(projectFile, openProjectOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<String> getRecentPaths() {
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.state.validateRecentProjects(this.modCounter);
            List list2 = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.state.getAdditionalInfo().keySet()));
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getDisplayName(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            RecentProjectMetaInfo recentProjectMetaInfo = this.state.getAdditionalInfo().get(path);
            String string = recentProjectMetaInfo != null ? recentProjectMetaInfo.getDisplayName() : null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getProjectName(@NotNull String path) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String cached = this.nameCache.get(path);
        if (cached != null) {
            return cached;
        }
        this.nameResolver.cancel();
        Set<String> set = this.namesToResolve;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.namesToResolve.add(path);
        }
        SingleAlarm.request$default(this.nameResolver, false, 0, 3, null);
        String string2 = PathUtilRt.getFileName((String)path);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getFileName(path)");
        String name = string2;
        if (StringsKt.endsWith$default((String)path, (String)".ipr", (boolean)false, (int)2, null)) {
            String string3 = FileUtilRt.getNameWithoutExtension((String)name);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileUtilRt.getNameWithoutExtension(name)");
        } else {
            string = name;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean willReopenProjectOnStart() {
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalSettings, (String)"GeneralSettings.getInstance()");
        if (!generalSettings.isReopenLastProject() || dontReopenProjects) {
            return false;
        }
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3;
            block7: {
                boolean bl4 = false;
                Iterable $this$any$iv = this.state.getAdditionalInfo().values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RecentProjectMetaInfo it = (RecentProjectMetaInfo)((Object)element$iv);
                        boolean bl5 = false;
                        if (!it.getOpened()) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
            }
            boolean bl6 = bl3;
            return bl6;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean reopenLastProjectsOnStart() {
        List<Map.Entry<String, RecentProjectMetaInfo>> openPaths = this.getLastOpenedProjects();
        boolean someProjectWasOpened = false;
        Iterator<Map.Entry<String, RecentProjectMetaInfo>> iterator2 = openPaths.iterator();
        while (iterator2.hasNext()) {
            void key;
            Map.Entry<String, RecentProjectMetaInfo> entry;
            Map.Entry<String, RecentProjectMetaInfo> entry2 = entry = iterator2.next();
            boolean bl = false;
            String string = entry2.getKey();
            entry2 = entry;
            bl = false;
            RecentProjectMetaInfo value2 = entry2.getValue();
            Function1 function1 = null;
            Function1 function12 = null;
            Function1 function13 = null;
            String string2 = value2.getProjectWorkspaceId();
            boolean bl2 = false;
            FrameInfo frameInfo = value2.getFrame();
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n = 0;
            int n2 = 0;
            boolean bl6 = false;
            ProjectOpenedCallback projectOpenedCallback = null;
            boolean bl7 = someProjectWasOpened;
            OpenProjectTask options2 = new OpenProjectTask(true, null, false, false, null, null, bl6, projectOpenedCallback, frameInfo, n2, n, bl5, bl4, bl3, string2, bl2, bl7, function13, function12, function1, 966334, null);
            Path path = Paths.get((String)key, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(key)");
            Project project = this.openProject(path, options2);
            if (someProjectWasOpened) continue;
            someProjectWasOpened = project != null;
        }
        return someProjectWasOpened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Map.Entry<String, RecentProjectMetaInfo>> getLastOpenedProjects() {
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void $this$filterTo$iv$iv;
            boolean bl3 = false;
            Iterable $this$filter$iv = this.state.getAdditionalInfo().entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl4 = false;
                if (!((RecentProjectMetaInfo)((Object)it.getValue())).getOpened()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = CollectionsKt.asReversed((List)((List)destination$iv$iv));
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ProjectGroup> getGroups() {
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            List<ProjectGroup> list2 = Collections.unmodifiableList(this.state.getGroups());
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.unmodifiableList(state.groups)");
            List<ProjectGroup> list3 = list2;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(@NotNull ProjectGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (!this.state.getGroups().contains(group)) {
                this.state.getGroups().add(group);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(@NotNull ProjectGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (String path : group.getProjects()) {
                this.state.getAdditionalInfo().remove(path);
                for (ProjectGroup anotherGroup : this.state.getGroups()) {
                    if (anotherGroup == group) continue;
                    group.removeProject(path);
                }
            }
            this.state.getGroups().remove(group);
            long l = this.modCounter.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModificationCount() {
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            long l = this.modCounter.get() + this.state.getModificationCount();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateProjectInfo(Project project, WindowManagerImpl windowManager, boolean writLastProjectInfo) {
        ProjectFrameHelper projectFrameHelper = windowManager.getFrameHelper(project);
        if (projectFrameHelper == null) {
            return;
        }
        ProjectFrameHelper frame = projectFrameHelper;
        String workspaceId = ProjectKt.getStateStore(project).getProjectWorkspaceId();
        FrameInfo frameInfo = ProjectFrameBounds.Companion.getInstance(project).getActualFrameInfoInDeviceSpace(frame, windowManager);
        String path = this.getProjectPath(project);
        Object object = this.stateLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Map<String, RecentProjectMetaInfo> map2 = this.state.getAdditionalInfo();
            String string = path;
            boolean bl4 = false;
            RecentProjectMetaInfo info = map2.get(string);
            if (info != null) {
                if (info.getFrame() != frameInfo) {
                    info.setFrame(frameInfo);
                }
                info.setProjectWorkspaceId(workspaceId);
            }
            Unit unit = Unit.INSTANCE;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RecentProjectsManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        try {
            boolean bl5 = false;
            if (writLastProjectInfo) {
                IdeFrameImpl ideFrameImpl = frame.getFrame();
                Intrinsics.checkExpressionValueIsNotNull((Object)ideFrameImpl, (String)"frame.frame");
                this.writeInfoFile(frameInfo, ideFrameImpl);
            }
            if (workspaceId != null && Registry.is((String)"ide.project.loading.show.last.state")) {
                this.takeASelfie(frame, workspaceId);
            }
        }
        catch (ProcessCanceledException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (CancellationException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (Throwable e$iv) {
            $this$runAndLogException$iv.error(e$iv);
        }
    }

    private final void writeInfoFile(FrameInfo frameInfo, JFrame frame) {
        Rectangle bounds2;
        if (!RecentProjectsManagerBaseKt.access$isUseProjectFrameAsSplash()) {
            return;
        }
        Path infoFile = RecentProjectsManagerBaseKt.access$getLastProjectFrameInfoFile();
        FrameInfo frameInfo2 = frameInfo;
        Rectangle rectangle = bounds2 = frameInfo2 != null ? frameInfo2.getBounds() : null;
        if (bounds2 == null) {
            Files.deleteIfExists(infoFile);
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(27);
        buffer.putShort((short)0);
        buffer.putInt(bounds2.x);
        buffer.putInt(bounds2.y);
        buffer.putInt(bounds2.width);
        buffer.putInt(bounds2.height);
        Container container2 = frame.getContentPane();
        Intrinsics.checkExpressionValueIsNotNull((Object)container2, (String)"frame.contentPane");
        Color color = container2.getBackground();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"frame.contentPane.background");
        buffer.putInt(color.getRGB());
        buffer.put((byte)(frameInfo.getFullScreen() ? 1 : 0));
        buffer.putInt(frameInfo.getExtendedState());
        buffer.flip();
        Path path = infoFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"infoFile");
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        PathKt.write$default((Path)path, (ByteBuffer)byteBuffer, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void takeASelfie(ProjectFrameHelper frameHelper, String workspaceId) {
        IdeFrameImpl ideFrameImpl = frameHelper.getFrame();
        Intrinsics.checkExpressionValueIsNotNull((Object)ideFrameImpl, (String)"frameHelper.frame");
        IdeFrameImpl frame = ideFrameImpl;
        int width = frame.getWidth();
        int height = frame.getHeight();
        BufferedImage bufferedImage = UIUtil.createImage((Component)frame, (int)width, (int)height, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedImage, (String)"UIUtil.createImage(frame\u2026feredImage.TYPE_INT_ARGB)");
        BufferedImage image = bufferedImage;
        Graphics graphics = image.getGraphics();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphics, (String)"image.graphics");
        UISettings.Companion.setupAntialiasing(graphics);
        frame.paint(image.getGraphics());
        Path path = ProjectSelfieUtil.getSelfieLocation(workspaceId);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"ProjectSelfieUtil.getSelfieLocation(workspaceId)");
        Path selfieFile = path;
        Closeable closeable = PathKt.outputStream((Path)selfieFile);
        boolean bl = false;
        Throwable throwable = null;
        try {
            OutputStream stream = (OutputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new MemoryCacheImageOutputStream(stream);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                MemoryCacheImageOutputStream out = (MemoryCacheImageOutputStream)closeable2;
                boolean bl4 = false;
                ImageWriter writer = ImageIO.getImageWriters(ImageTypeSpecifier.createFromRenderedImage(image), "png").next();
                try {
                    ImageWriter imageWriter = writer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)imageWriter, (String)"writer");
                    imageWriter.setOutput(out);
                    writer.write(null, new IIOImage(image, null, null), null);
                }
                finally {
                    writer.dispose();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Path lastLink = selfieFile.getParent().resolve("last.png");
        if (SystemInfo.isUnix) {
            Files.deleteIfExists(lastLink);
            Files.createSymbolicLink(lastLink, selfieFile, new FileAttribute[0]);
        } else {
            Files.copy(selfieFile, lastLink, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public RecentProjectsManagerBase() {
        Map map2 = Collections.synchronizedMap((Map)new THashMap());
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.synchronizedMap(THashMap())");
        this.nameCache = map2;
        this.nameResolver = SingleAlarmKt.pooledThreadSingleAlarm$default(50, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ RecentProjectsManagerBase this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Ref.ObjectRef paths = new Ref.ObjectRef();
                Set set = RecentProjectsManagerBase.access$getNamesToResolve$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (set) {
                    boolean bl3 = false;
                    paths.element = (Set)new THashSet((Collection)RecentProjectsManagerBase.access$getNamesToResolve$p(this.this$0));
                    RecentProjectsManagerBase.access$getNamesToResolve$p(this.this$0).clear();
                    Unit unit = Unit.INSTANCE;
                }
                for (String p : (Set)paths.element) {
                    RecentProjectsManagerBase.access$getNameCache$p(this.this$0).put(p, RecentProjectsManagerBaseKt.access$readProjectName(p));
                }
            }
            {
                this.this$0 = recentProjectsManagerBase;
                super(0);
            }
        }, 2, null);
        this.stateLock = new Object();
        this.state = new RecentProjectManagerState();
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ Set access$getNamesToResolve$p(RecentProjectsManagerBase $this) {
        return $this.namesToResolve;
    }

    @NotNull
    public static final RecentProjectsManagerBase getInstanceEx() {
        return Companion.getInstanceEx();
    }

    @JvmStatic
    public static final boolean isFileSystemPath(@NotNull String path) {
        return Companion.isFileSystemPath(path);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/RecentProjectsManagerBase$MyProjectListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "()V", "manager", "Lcom/intellij/ide/RecentProjectsManagerBase;", "projectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "projectClosing", "projectOpened", "Companion", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static final class MyProjectListener
    implements ProjectManagerListener {
        private final RecentProjectsManagerBase manager = Companion.getInstanceEx();
        public static final Companion Companion = new Companion(null);

        public void projectOpened(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String path = this.manager.getProjectPath(project);
            if (path != null) {
                this.manager.markPathRecent(path, project);
            }
            this.manager.updateLastProjectPath();
            MyProjectListener.Companion.updateSystemDockMenu();
        }

        public void projectClosing(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String string = this.manager.getProjectPath(project);
            if (string == null) {
                return;
            }
            String path = string;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isHeadlessEnvironment()) {
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
                }
                this.manager.updateProjectInfo(project, (WindowManagerImpl)windowManager, false);
            }
            Map map2 = this.manager.nameCache;
            String string2 = project.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
            map2.put(path, string2);
        }

        public void projectClosed(@NotNull Project project) {
            Project[] openProjects;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] projectArray2 = openProjects = projectArray;
            boolean bl = false;
            Project[] projectArray3 = projectArray2;
            boolean bl2 = false;
            if (!(projectArray3.length == 0)) {
                Project openProject2;
                Project project2 = openProject2 = openProjects[openProjects.length - 1];
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"openProject");
                String path = this.manager.getProjectPath(project2);
                if (path != null) {
                    this.manager.markPathRecent(path, openProject2);
                }
            }
            MyProjectListener.Companion.updateSystemDockMenu();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/RecentProjectsManagerBase$MyProjectListener$Companion;", "", "()V", "updateSystemDockMenu", "", "intellij.platform.ide.impl"})
        public static final class Companion {
            private final void updateSystemDockMenu() {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isHeadlessEnvironment()) {
                    SystemDock.updateMenu();
                }
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/RecentProjectsManagerBase$MyAppLifecycleListener;", "Lcom/intellij/ide/AppLifecycleListener;", "()V", "appClosing", "", "projectFrameClosed", "projectOpenFailed", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static final class MyAppLifecycleListener
    implements AppLifecycleListener {
        @Override
        public void projectOpenFailed() {
            Companion.getInstanceEx().updateLastProjectPath();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void appClosing() {
            Project[] openProjects;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isHeadlessEnvironment()) {
                return;
            }
            WindowManager windowManager = WindowManager.getInstance();
            if (windowManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.WindowManagerImpl");
            }
            WindowManagerImpl windowManager2 = (WindowManagerImpl)windowManager;
            RecentProjectsManagerBase manager = Companion.getInstanceEx();
            Project[] projectArray = ProjectUtil.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectUtil.getOpenProjects()");
            Project[] projectArray2 = openProjects = projectArray;
            boolean bl = false;
            if (projectArray2.length == 0 || !RecentProjectsManagerBaseKt.access$isUseProjectFrameAsSplash()) {
                Files.deleteIfExists(RecentProjectsManagerBaseKt.access$getLastProjectFrameInfoFile());
            }
            Project[] projectArray3 = openProjects;
            int n = projectArray3.length;
            int n2 = 0;
            while (n2 < n) {
                void index;
                Project project;
                Project project2 = project = projectArray3[n2];
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                manager.updateProjectInfo(project2, windowManager2, index == false);
                ++index;
            }
        }

        @Override
        public void projectFrameClosed() {
            Companion.getInstanceEx().updateLastProjectPath();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/RecentProjectsManagerBase$Companion;", "", "()V", "MAX_PROJECTS_IN_MAIN_MENU", "", "dontReopenProjects", "", "instanceEx", "Lcom/intellij/ide/RecentProjectsManagerBase;", "instanceEx$annotations", "getInstanceEx", "()Lcom/intellij/ide/RecentProjectsManagerBase;", "isFileSystemPath", "path", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void instanceEx$annotations() {
        }

        @NotNull
        public final RecentProjectsManagerBase getInstanceEx() {
            RecentProjectsManager recentProjectsManager = RecentProjectsManager.getInstance();
            if (recentProjectsManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.RecentProjectsManagerBase");
            }
            return (RecentProjectsManagerBase)recentProjectsManager;
        }

        @JvmStatic
        public final boolean isFileSystemPath(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            return StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null) != -1 || StringsKt.indexOf$default((CharSequence)path, (char)'\\', (int)0, (boolean)false, (int)6, null) != -1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

